/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Condition;
import debugger.Program;
import debugger.Statement;
import java.util.LinkedList;
import java.util.Stack;
import sourceCode.SourceCode;

public class IfElse
extends Statement {
    private int elseLine;
    private boolean isIf;

    public IfElse(int startLine, Condition condition, Program currentProgram, SourceCode code, LinkedList<Program> programs, Stack<Statement> stack) {
        this.sourceCode = code;
        this.programs = programs;
        this.condition = condition;
        this.startLine = startLine;
        this.endLine = this.getFiLine(this.startLine);
        this.elseLine = this.getElseLine(this.startLine, this.endLine);
        this.currentProgram = currentProgram;
        this.runLine = startLine;
        this.runStack = stack;
        this.runStack.push(this);
        this.isIf = false;
        this.type = Statement.InstructionType.IFELSE;
    }

    public int run(Program.StepType step) {
        if (this.runLine == this.startLine) {
            if (this.condition.executeCondition()) {
                this.isIf = true;
                ++this.runLine;
            } else {
                int fi = this.getFiLine(this.startLine);
                this.runLine = this.getElseLine(this.runLine, fi);
            }
        } else if (this.runLine == this.elseLine && !this.isIf) {
            ++this.runLine;
        } else if (this.runLine == this.elseLine && this.isIf || this.runLine == this.endLine) {
            this.runLine = this.endLine + 1;
            this.runStack.pop();
        } else {
            this.runLine = this.currentProgram.run(this.runLine, this.runStack, step);
        }
        return this.runLine;
    }
}

