/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Variable;
import java.math.BigInteger;

public class Operation {
    private Variable operand1;
    private Variable operand2;
    private Operators operator;

    public Operation(Variable op1, Variable op2, String op) {
        this.operand1 = op1;
        this.operand2 = op2;
        this.operator = this.buildOperator(op);
    }

    public Operators buildOperator(String name) {
        Operators result = name.equalsIgnoreCase("+") ? Operators.SUM : (name.equalsIgnoreCase("-") ? Operators.SUBSTRACTION : (name.equalsIgnoreCase("*") ? Operators.MULTIPLICATION : Operators.DIVISION));
        return result;
    }

    public BigInteger evaluate() {
        BigInteger result = new BigInteger("0");
        switch (this.operator) {
            case SUM: {
                result = this.operand1.getValue().add(this.operand2.getValue());
                break;
            }
            case SUBSTRACTION: {
                result = this.operand1.getValue().subtract(this.operand2.getValue());
                break;
            }
            case MULTIPLICATION: {
                result = this.operand1.getValue().multiply(this.operand2.getValue());
                break;
            }
            case DIVISION: {
                result = this.operand1.getValue().divide(this.operand2.getValue());
            }
        }
        return result;
    }

    public String toString() {
        String result = "";
        switch (this.operator) {
            case SUM: {
                result = this.operand1.getValue() + " + " + this.operand2.getValue();
                break;
            }
            case SUBSTRACTION: {
                result = this.operand1.getValue() + " - " + this.operand2.getValue();
                break;
            }
            case MULTIPLICATION: {
                result = this.operand1.getValue() + " * " + this.operand2.getValue();
                break;
            }
            case DIVISION: {
                result = this.operand1.getValue() + " / " + this.operand2.getValue();
            }
        }
        return result;
    }

    private static enum Operators {
        SUM,
        SUBSTRACTION,
        MULTIPLICATION,
        DIVISION;

    }
}

