/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Assignment;
import debugger.BreakpointCond;
import debugger.Condition;
import debugger.DoTimes;
import debugger.Function;
import debugger.IfElse;
import debugger.Operation;
import debugger.ProgramWhileA;
import debugger.Statement;
import debugger.Variable;
import debugger.Variables;
import debugger.WhileDo;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java_cup.runtime.Symbol;
import sourceCode.SourceCode;

public class Program {
    String name;
    int startLine;
    int endLine;
    int startCodeLine;
    int runLine;
    int steps;
    Stack<Statement> runStack;
    LinkedList<Program> programs;
    SourceCode sourceCode;
    Variables inputVariables;
    Variable outputVariable;
    Variables auxVariables;
    int numVariablesInput;
    BreakpointCond condBreakpoints;
    LinkedList<Integer> breakpoints;
    boolean stopBreakpoint;
    boolean stopBPC;
    String breakpointCVar;
    Condition breakpointCCond;

    public int getStartCodeLine() {
        return this.startCodeLine;
    }

    public void setStartCodeLine(int startCodeLine) {
        this.startCodeLine = startCodeLine;
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(SourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getNumInputVariables() {
        return this.numVariablesInput;
    }

    public String getProgramName() {
        return this.name;
    }

    public Program getProgram(String name) {
        Program result = null;
        boolean find = false;
        Iterator st = this.programs.iterator();
        while (st.hasNext() && !find) {
            Program aux = (Program)st.next();
            if (!aux.getProgramName().equalsIgnoreCase(name)) continue;
            find = true;
            result = aux;
        }
        return result;
    }

    public boolean isSourceCodeProgram(String name) {
        boolean isProgram = false;
        for (Program program : this.programs) {
            if (!program.getProgramName().equalsIgnoreCase(name)) continue;
            isProgram = true;
        }
        return isProgram;
    }

    public LinkedList<String> getInputVariable() {
        return this.inputVariables.getVariablesName();
    }

    public int getStartProgramLine() {
        return this.startLine;
    }

    public int getEndProgramLine() {
        return this.endLine;
    }

    public String getStringRunLine() {
        return this.sourceCode.paintLine(this.runLine);
    }

    public int getRunLine() {
        return this.runLine;
    }

    public int getNextRunLine() {
        int nextLine = this.runLine;
        while (this.isEmptyLine(nextLine) && nextLine <= this.endLine) {
            ++nextLine;
        }
        return nextLine;
    }

    public BigInteger getProgramOutput() {
        return this.outputVariable.getValue();
    }

    public int getSteps() {
        return this.steps;
    }

    public String[] getVariableList() {
        LinkedList<String> inputs = this.inputVariables.getVariablesName();
        LinkedList<String> auxInputs = this.auxVariables.getVariablesName();
        int length = inputs.size() + auxInputs.size() + 1;
        String[] finalList = new String[length];
        int i = 0;
        while (i < inputs.size()) {
            finalList[i] = inputs.get(i);
            ++i;
        }
        int j = inputs.size();
        while (j < inputs.size() + auxInputs.size()) {
            finalList[j] = auxInputs.get(j);
            ++j;
        }
        finalList[length - 1] = this.outputVariable.getName();
        return finalList;
    }

    public Variable getVariable(String name) {
        Variable result = null;
        if (this.auxVariables.isVariable(name)) {
            result = this.auxVariables.getVariable(name);
        } else if (this.inputVariables.isVariable(name)) {
            result = this.inputVariables.getVariable(name);
        } else if (this.outputVariable.getName().equalsIgnoreCase(name)) {
            result = this.outputVariable;
        }
        return result;
    }

    public Variable addAndGetVariable(String name, BigInteger value, boolean isFinal) {
        if (isFinal) {
            if (this.auxVariables.isVariable(name)) {
                this.auxVariables.setVariableValue(name, value);
            } else {
                this.auxVariables.addVariable(name, value, isFinal);
            }
        } else {
            this.auxVariables.addVariable(name, value, isFinal);
        }
        return this.auxVariables.getVariable(name);
    }

    public void removeAuxVariables() {
        this.auxVariables.removeFinalVariables();
    }

    public boolean isVariable(String name) {
        boolean result = false;
        if (name != null) {
            result = this.auxVariables.isVariable(name) || this.inputVariables.isVariable(name) || this.outputVariable.getName().equalsIgnoreCase(name);
        }
        return result;
    }

    public boolean isInputVariable(String name) {
        boolean result = false;
        if (name != null) {
            result = this.inputVariables.isVariable(name);
        }
        return result;
    }

    public boolean isOutputVariable(String name) {
        boolean result = false;
        if (name != null) {
            result = this.outputVariable.getName().equalsIgnoreCase(name);
        }
        return result;
    }

    public void removeVariable(String name) {
        if (name != null) {
            this.auxVariables.removeVariable(name);
        }
    }

    public void setVariable(String name, BigInteger value) {
        if (this.auxVariables.isVariable(name)) {
            this.auxVariables.setVariableValue(name, value);
        } else if (this.inputVariables.isVariable(name)) {
            this.inputVariables.setVariableValue(name, value);
        } else if (this.outputVariable.getName().equalsIgnoreCase(name)) {
            this.outputVariable.setValue(value);
        }
    }

    public void addBPC(Condition cond) {
        this.getBPC().addCondition(cond);
    }

    public void removeBPC(String programName, String name) {
        if (name != null) {
            Program auxProgram = this.getProgram(programName);
            auxProgram.getBPC().removeCondition(name);
        }
    }

    public void removeAllBPC() {
        for (Program auxProgram : this.programs) {
            auxProgram.setBPC(new BreakpointCond());
        }
    }

    public boolean isBPC(String programName, Condition condition) {
        boolean result = false;
        if (condition != null) {
            result = this.getProgram(programName).getBPC().isCondition(condition);
        }
        return result;
    }

    public BreakpointCond getBPC() {
        return this.condBreakpoints;
    }

    public void setBPC(BreakpointCond newBreakpointConditional) {
        this.condBreakpoints = newBreakpointConditional;
    }

    public Condition getConditionBPC() {
        return this.breakpointCCond;
    }

    public boolean updateConditions() {
        return this.condBreakpoints.updateCandidates();
    }

    public void updateCondition() {
        for (Program auxProgram : this.programs) {
            auxProgram.getBPC().updateConditions();
        }
    }

    public boolean isStopBPC() {
        return this.stopBPC;
    }

    public boolean programsStopBPC() {
        boolean programStoped = false;
        for (Program programAux : this.programs) {
            if (!programAux.isStopBPC()) continue;
            programStoped = true;
        }
        return programStoped;
    }

    public boolean programsStopBreakpoint() {
        boolean programStoped = false;
        for (Program auxProgram : this.programs) {
            if (!auxProgram.stopBreakpoint()) continue;
            programStoped = true;
        }
        return programStoped;
    }

    public String getVariableBreakpointCond() {
        return this.breakpointCVar;
    }

    public void setStopBPC(boolean state) {
        this.stopBPC = state;
    }

    public void setProgramContinueBPC() {
        for (Program auxProgram : this.programs) {
            auxProgram.setStopBPC(false);
        }
    }

    public void addBreakpoint(Integer point) {
        for (Program auxProgram : this.programs) {
            if (auxProgram.getBreakpoints().contains(point)) continue;
            auxProgram.getBreakpoints().add(point);
        }
    }

    public void removeBreakpoint(Integer point) {
        for (Program auxProgram : this.programs) {
            if (!auxProgram.getBreakpoints().contains(point)) continue;
            auxProgram.getBreakpoints().remove(point);
        }
    }

    public boolean isBreakpoint(Integer line) {
        boolean isBreakpoint = false;
        for (Program auxProgram : this.programs) {
            if (!auxProgram.getBreakpoints().contains(line)) continue;
            isBreakpoint = true;
        }
        return isBreakpoint;
    }

    public void setStateBreakpoint(boolean state) {
        this.stopBreakpoint = state;
    }

    public boolean stopBreakpoint() {
        return this.stopBreakpoint;
    }

    public void checkBreakpoint(int runLine) {
        for (Program auxProgram : this.programs) {
            if (!auxProgram.stopBreakpoint() && auxProgram.isBreakpoint(runLine)) {
                auxProgram.setStateBreakpoint(true);
                continue;
            }
            if (auxProgram.isBreakpoint(runLine) && (!auxProgram.stopBreakpoint() || !auxProgram.isBreakpoint(runLine))) continue;
            auxProgram.setStateBreakpoint(false);
        }
    }

    public int run(int start, Stack<Statement> stack, StepType optionStep) {
        Condition cond = null;
        Operation opAux = null;
        Variable aux1 = null;
        Variable aux2 = null;
        Variable aux3 = null;
        Assignment instrAsignacion = null;
        Function funcion1 = null;
        Function funcion2 = null;
        WhileDo InstrWhile = null;
        DoTimes InstrDoTimes = null;
        IfElse InstrIfElse = null;
        String operador = "";
        String op1 = " ";
        String op2 = " ";
        String op3 = " ";
        VariableType varClass1 = null;
        VariableType varClass2 = null;
        int index = 0;
        int indexCond = 0;
        Symbol token = null;
        Symbol tokenCond1 = null;
        Symbol tokenCond2 = null;
        this.runLine = start;
        index = 0;
        if (this.runLine == this.sourceCode.sizeSourceCode()) {
            ++index;
        }
        if (this.sourceCode.isTokenComment(token = this.sourceCode.getTokenLine(this.runLine, index)) || this.sourceCode.isTokenEmptyLine(token)) {
            ++this.runLine;
        } else if (this.sourceCode.isStartToken(token)) {
            if (!this.sourceCode.isTokenDo(token)) {
                indexCond = index + 1;
                tokenCond1 = this.sourceCode.getTokenLine(this.runLine, indexCond);
                if (this.sourceCode.isTokenNum(tokenCond1)) {
                    aux1 = this.addAndGetVariable("temp1", new BigInteger(tokenCond1.value.toString()), true);
                } else {
                    op1 = (String)tokenCond1.value;
                    if (!this.isVariable(op1)) {
                        aux1 = this.addAndGetVariable(op1, new BigInteger("0"), false);
                    }
                    aux1 = this.getVariable(op1);
                }
                token = this.sourceCode.getTokenLine(this.runLine, ++indexCond);
                operador = (String)token.value;
                tokenCond2 = this.sourceCode.getTokenLine(this.runLine, ++indexCond);
                if (this.sourceCode.isTokenNum(tokenCond2)) {
                    aux2 = this.addAndGetVariable("temp2", new BigInteger(tokenCond2.value.toString()), true);
                } else {
                    op2 = (String)tokenCond2.value;
                    if (!this.isVariable(op2)) {
                        aux2 = this.addAndGetVariable(op2, new BigInteger("0"), false);
                    }
                    aux2 = this.getVariable(op2);
                }
                cond = new Condition(aux1, aux2, operador, this);
                token = this.sourceCode.getTokenLine(this.runLine, index);
                ++index;
            }
            if (this.sourceCode.isTokenWhile(token)) {
                index += 3;
                InstrWhile = new WhileDo(this.runLine, cond, this, this.sourceCode, this.programs, true, this.runStack);
                this.runLine = InstrWhile.run(optionStep);
            } else if (this.sourceCode.isTokenIf(token)) {
                index += 3;
                InstrIfElse = new IfElse(this.runLine, cond, this, this.sourceCode, this.programs, this.runStack);
                this.runLine = InstrIfElse.run(optionStep);
            } else if (this.sourceCode.isTokenDo(token)) {
                index += 3;
                InstrDoTimes = new DoTimes(this.runLine, this, this.sourceCode, this.programs, this.runStack);
                this.runLine = InstrDoTimes.run(optionStep);
            }
        } else if (this.sourceCode.isTokenID(token) || this.sourceCode.isTokenIDWhile(token)) {
            op1 = (String)this.sourceCode.getTokenLine((Integer)Integer.valueOf((int)this.runLine), (int)index).value;
            ++index;
            token = this.sourceCode.getTokenLine(this.runLine, ++index);
            if (this.sourceCode.isTokenNum(token)) {
                aux2 = this.addAndGetVariable("temp1", new BigInteger(token.value.toString()), true);
                varClass1 = VariableType.NUMBER;
            } else if (this.sourceCode.isTokenID(token) || this.sourceCode.isTokenIDWhile(token)) {
                op2 = (String)token.value;
                if (this.getProgram(op2) != null) {
                    funcion1 = new Function(this.runLine, this, this.sourceCode, this.programs, this.runStack, op2);
                    index = funcion1.getLastToken();
                    varClass1 = VariableType.FUNCTION;
                } else {
                    aux2 = this.isVariable(op2) ? this.getVariable(op2) : this.addAndGetVariable(op2, new BigInteger("0"), false);
                    varClass1 = VariableType.VARIABLE;
                }
            }
            token = this.sourceCode.getTokenLine(this.runLine, ++index);
            if (this.sourceCode.isTokenOpMult(token) || this.sourceCode.isTokenOpSum(token)) {
                operador = (String)token.value;
                token = this.sourceCode.getTokenLine(this.runLine, ++index);
                if (this.sourceCode.isTokenNum(token)) {
                    aux3 = this.addAndGetVariable("temp2", new BigInteger(token.value.toString()), true);
                    varClass2 = VariableType.NUMBER;
                } else if (this.sourceCode.isTokenID(token) || this.sourceCode.isTokenIDWhile(token)) {
                    op3 = (String)token.value;
                    if (this.getProgram(op3) != null) {
                        funcion2 = new Function(this.runLine, this, this.sourceCode, this.programs, this.runStack, op3);
                        index = funcion2.getLastToken();
                        varClass2 = VariableType.FUNCTION;
                    } else {
                        aux3 = this.isVariable(op3) ? this.getVariable(op3) : this.addAndGetVariable(op3, new BigInteger("0"), false);
                        varClass2 = VariableType.VARIABLE;
                    }
                }
                if (varClass1 == VariableType.NUMBER && varClass2 == VariableType.NUMBER || varClass1 == VariableType.NUMBER && varClass2 == VariableType.VARIABLE || varClass1 == VariableType.VARIABLE && varClass2 == VariableType.NUMBER || varClass1 == VariableType.VARIABLE && varClass2 == VariableType.VARIABLE) {
                    opAux = new Operation(aux2, aux3, operador);
                    instrAsignacion = new Assignment(this.runLine, op1, opAux, this, this.sourceCode, this.programs, this.runStack);
                } else if (varClass1 == VariableType.FUNCTION && varClass2 == VariableType.NUMBER || varClass1 == VariableType.FUNCTION && varClass2 == VariableType.VARIABLE) {
                    instrAsignacion = new Assignment(this.runLine, op1, funcion1, aux3.getValue(), operador, this, this.sourceCode, this.programs, this.runStack);
                } else if (varClass1 == VariableType.NUMBER && varClass2 == VariableType.FUNCTION || varClass1 == VariableType.VARIABLE && varClass2 == VariableType.FUNCTION) {
                    instrAsignacion = new Assignment(this.runLine, op1, aux2.getValue(), funcion2, operador, this, this.sourceCode, this.programs, this.runStack);
                } else if (varClass1 == VariableType.FUNCTION && varClass2 == VariableType.FUNCTION) {
                    instrAsignacion = new Assignment(this.runLine, op1, funcion1, funcion2, operador, this, this.sourceCode, this.programs, this.runStack);
                }
            } else if (varClass1 == VariableType.VARIABLE || varClass1 == VariableType.NUMBER) {
                instrAsignacion = new Assignment(this.runLine, op1, aux2.getValue(), this, this.sourceCode, this.programs, this.runStack);
            } else if (varClass1 == VariableType.FUNCTION) {
                instrAsignacion = new Assignment(this.runLine, op1, funcion1, this, this.sourceCode, this.programs, this.runStack);
            }
            this.runLine = instrAsignacion.run(optionStep);
            if (this.getVariable(instrAsignacion.getVariableName()) != null && this.getBPC().checkConditions(instrAsignacion.getVariableName()) != null) {
                this.stopBPC = true;
                --this.runLine;
                this.breakpointCVar = instrAsignacion.getVariableName();
                this.breakpointCCond = this.condBreakpoints.checkConditions(instrAsignacion.getVariableName());
            }
        }
        this.removeAuxVariables();
        return this.runLine;
    }

    public boolean isEmptyLine(int line) {
        Symbol token = this.sourceCode.getTokenLine(line, 0);
        return this.sourceCode.isTokenComment(token) || this.sourceCode.isTokenEmptyLine(token);
    }

    public boolean step(StepType opcionStep) {
        if (!this.stopBPC) {
            if (this.runLine != this.endLine + 1) {
                if (!this.sourceCode.isTokenComment(this.sourceCode.getFirstTokenLine(this.runLine)) && !this.sourceCode.isTokenEmptyLine(this.sourceCode.getFirstTokenLine(this.runLine))) {
                    ++this.steps;
                }
                if (this.runStack.empty()) {
                    if (opcionStep != StepType.STEP_OUT) {
                        this.runLine = this.run(this.runLine, this.runStack, opcionStep);
                    }
                } else {
                    Statement instrAux = this.runStack.pop();
                    this.runStack.push(instrAux);
                    switch (instrAux.type) {
                        case WHILEDO: {
                            ((WhileDo)instrAux).setRunLine(this.runLine);
                            this.runLine = ((WhileDo)instrAux).run(opcionStep);
                            break;
                        }
                        case ASSIGNMENT: {
                            this.runLine = ((Assignment)instrAux).run(opcionStep);
                            Condition cond = this.condBreakpoints.checkConditions(((Assignment)instrAux).getVariableName());
                            if (cond == null) break;
                            this.stopBPC = true;
                            --this.runLine;
                            this.breakpointCVar = ((Assignment)instrAux).getVariableName();
                            this.breakpointCCond = cond;
                            break;
                        }
                        case IFELSE: {
                            ((IfElse)instrAux).setRunLine(this.runLine);
                            this.runLine = ((IfElse)instrAux).run(opcionStep);
                            break;
                        }
                        case DOTIMES: {
                            ((DoTimes)instrAux).setRunLine(this.runLine);
                            this.runLine = ((DoTimes)instrAux).run(opcionStep);
                        }
                    }
                }
                this.removeAuxVariables();
            }
        } else {
            this.stopBPC = false;
            ++this.runLine;
        }
        while (this.isEmptyLine(this.runLine)) {
            ++this.runLine;
        }
        return this.runLine == this.endLine + 1;
    }

    public LinkedList<Integer> getBreakpoints() {
        return this.breakpoints;
    }

    public void setBreakpoints(LinkedList<Integer> breakpoints) {
        this.breakpoints = breakpoints;
    }

    public void removeAllBreakpoints() {
        for (Program auxProgram : this.programs) {
            auxProgram.setBreakpoints(new LinkedList<Integer>());
        }
    }

    public boolean isWhileA() {
        return this instanceof ProgramWhileA;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Variables de Entrada \n");
        stringBuilder.append(String.valueOf(this.inputVariables.toString()) + "\n");
        if (!this.auxVariables.isEmptyVariables()) {
            stringBuilder.append("Variables de Auxiliares \n");
            stringBuilder.append(String.valueOf(this.auxVariables.toString()) + "\n");
        }
        stringBuilder.append("Variable de Salida \n");
        stringBuilder.append("\t" + this.outputVariable.toString() + "\n");
        return stringBuilder.toString();
    }

    public String programsToString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < this.programs.size()) {
            stringBuilder.append(String.valueOf(this.programs.get(i).getProgramName()) + "\n");
            stringBuilder.append(this.programs.get(i).toString());
            ++i;
        }
        return stringBuilder.toString();
    }

    public int runStackSize() {
        return this.runStack.size();
    }

    public void resetBPC() {
        this.condBreakpoints.resetConditions();
    }

    public void nextLineRunAfterBPC() {
        for (Program programAux : this.programs) {
            if (!programAux.isStopBPC()) continue;
            programAux.setRunLine(programAux.getRunLine() + 1);
        }
    }

    public Condition getprogramsBPC() {
        Condition bpc = null;
        for (Program programAux : this.programs) {
            if (!programAux.isStopBPC()) continue;
            bpc = programAux.getConditionBPC();
        }
        return bpc;
    }

    public boolean isFinished() {
        return this.runLine == this.endLine + 1;
    }

    public void setRunLine(int runLine) {
        this.runLine = runLine;
    }

    public Program getMainProgram() {
        return this.programs.getFirst();
    }

    public static enum StepType {
        STEP_OVER,
        STEP_INTO,
        STEP_OUT;

    }

    public static enum VariableType {
        NUMBER,
        VARIABLE,
        FUNCTION;

    }
}

