/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.BreakpointCond;
import debugger.Program;
import debugger.Variables;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Stack;
import sourceCode.SourceCode;

public class ProgramWhile
extends Program {
    private int variablesSize;
    private LinkedList<LinkedList<BigInteger>> configurations;

    public ProgramWhile(String name, int start, int end, SourceCode source, LinkedList<Program> program, int inputs, int totalVar, String sourceName) {
        this.name = name;
        this.sourceCode = source;
        this.programs = program;
        this.breakpoints = new LinkedList();
        this.condBreakpoints = new BreakpointCond();
        this.stopBreakpoint = false;
        this.stopBPC = false;
        this.breakpointCVar = "";
        this.configurations = new LinkedList();
        this.startLine = start;
        this.endLine = end;
        this.numVariablesInput = inputs;
        this.variablesSize = totalVar;
        int runLineIndex = this.startLine + 1;
        while (this.isEmptyLine(runLineIndex)) {
            ++runLineIndex;
        }
        ++runLineIndex;
        while (this.isEmptyLine(runLineIndex)) {
            ++runLineIndex;
        }
        this.startCodeLine = this.runLine = runLineIndex;
        this.inputVariables = new Variables(this.sourceCode);
        this.inputVariables.addInputVariables(this.numVariablesInput);
        this.auxVariables = new Variables(this.sourceCode);
        this.auxVariables.addAuxiliarVariables(this.numVariablesInput + 1, this.variablesSize);
        this.outputVariable = this.inputVariables.getVariable("X1");
        this.runStack = new Stack();
        this.steps = 0;
    }

    public boolean updateConfiguration() {
        boolean isInstruction = false;
        if (!this.sourceCode.isTokenComment(this.sourceCode.getFirstTokenLine(this.runLine)) && !this.sourceCode.isTokenEmptyLine(this.sourceCode.getFirstTokenLine(this.runLine))) {
            LinkedList<BigInteger> variablesConfiguracion = new LinkedList<BigInteger>();
            BigInteger NumLinea = new BigInteger(Integer.toString(this.runLine));
            variablesConfiguracion.add(NumLinea.subtract(BigInteger.ONE));
            int i = 1;
            while (i <= this.numVariablesInput) {
                variablesConfiguracion.add(this.inputVariables.getVariable("X" + i).getValue());
                ++i;
            }
            i = 1 + this.numVariablesInput;
            while (i <= this.variablesSize) {
                variablesConfiguracion.add(this.auxVariables.getVariable("X" + i).getValue());
                ++i;
            }
            this.configurations.add(variablesConfiguracion);
            this.showConfigurations();
            isInstruction = true;
        }
        return isInstruction;
    }

    public String showConfiguration(LinkedList<BigInteger> configuration) {
        String stringConfiguracion = "( " + configuration.getFirst() + " , ";
        int j = 1;
        while (j < configuration.size() - 1) {
            stringConfiguracion = String.valueOf(stringConfiguracion) + configuration.get(j) + " , ";
            ++j;
        }
        stringConfiguracion = String.valueOf(stringConfiguracion) + configuration.getLast() + " )";
        return stringConfiguracion;
    }

    public String showConfigurations() {
        String programConfiguration = "";
        if (this.configurations.size() > 1) {
            programConfiguration = this.showConfiguration(this.configurations.getFirst());
            int i = 1;
            while (i < this.configurations.size() - 1) {
                programConfiguration = String.valueOf(programConfiguration) + " |- " + this.showConfiguration(this.configurations.get(i));
                ++i;
            }
            programConfiguration = String.valueOf(programConfiguration) + " |- " + this.showConfiguration(this.configurations.getLast());
        } else {
            programConfiguration = this.showConfiguration(this.configurations.getFirst());
        }
        return programConfiguration;
    }

    public void addInputs(LinkedList<BigInteger> ent) {
        if (this.getNumInputVariables() == ent.size()) {
            Integer i = 1;
            while (i <= this.getNumInputVariables()) {
                String name = "X" + i;
                this.setVariable(name, ent.get(i - 1));
                i = i + 1;
            }
        }
    }

    public void endDebug() {
        int runLineIndex = this.startLine + 1;
        while (this.isEmptyLine(runLineIndex)) {
            ++runLineIndex;
        }
        ++runLineIndex;
        while (this.isEmptyLine(runLineIndex)) {
            ++runLineIndex;
        }
        this.startCodeLine = this.runLine = runLineIndex;
        this.inputVariables = new Variables(this.sourceCode);
        this.inputVariables.addInputVariables(this.numVariablesInput);
        this.auxVariables = new Variables(this.sourceCode);
        this.auxVariables.addAuxiliarVariables(this.numVariablesInput + 1, this.variablesSize);
        this.outputVariable = this.inputVariables.getVariable("X1");
        this.runStack = new Stack();
        this.steps = 0;
        this.breakpoints = new LinkedList();
        this.stopBreakpoint = false;
    }
}

