/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.BreakpointCond;
import debugger.Condition;
import debugger.Program;
import debugger.Variable;
import debugger.Variables;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.Stack;
import sourceCode.SourceCode;

public class ProgramWhileA
extends Program {
    private boolean auxBPC;
    private Condition auxBPCCondition;
    private int auxBPCLine;

    public ProgramWhileA(String name, int startLine, int endLine, SourceCode source, LinkedList<Program> programs) {
        this.sourceCode = source;
        this.programs = programs;
        this.startLine = startLine;
        this.endLine = endLine;
        this.runStack = new Stack();
        int i = startLine;
        while (i >= 0 && source.getFirstTokenLine((Integer)Integer.valueOf((int)i)).sym != 3) {
            --i;
        }
        if (source.getFirstTokenLine((Integer)Integer.valueOf((int)i)).sym == 3) {
            this.name = (String)source.getFirstTokenLine((Integer)Integer.valueOf((int)i)).value;
        }
        this.inputVariables = new Variables(this.sourceCode);
        int inputIndex = startLine + 1;
        while (source.getFirstTokenLine((Integer)Integer.valueOf((int)inputIndex)).sym != 32) {
            ++inputIndex;
        }
        this.inputVariables.addVariablesLine(inputIndex);
        int outAuxIndex = inputIndex + 1;
        while (!source.isSalidaLine(outAuxIndex)) {
            ++outAuxIndex;
        }
        String outAux = (String)this.sourceCode.getTokenLine((Integer)Integer.valueOf((int)outAuxIndex), (int)2).value;
        this.outputVariable = this.inputVariables.isVariable(outAux) ? this.inputVariables.getVariable(outAux) : new Variable(outAux, BigInteger.ZERO, false, this.sourceCode);
        int runLineIndex = outAuxIndex + 1;
        while (!source.isMetodoLine(runLineIndex)) {
            ++runLineIndex;
        }
        int emptyLine = ++runLineIndex;
        while (this.isEmptyLine(emptyLine)) {
            ++emptyLine;
        }
        this.startCodeLine = this.runLine = emptyLine;
        this.auxVariables = new Variables(this.sourceCode);
        this.steps = 0;
        this.breakpoints = new LinkedList();
        this.condBreakpoints = new BreakpointCond();
        this.stopBreakpoint = false;
        this.stopBPC = false;
        this.breakpointCVar = "";
    }

    public boolean isAuxBPC() {
        return this.auxBPC;
    }

    public void setAuxBPC(boolean auxBPC) {
        this.auxBPC = auxBPC;
    }

    public Condition getAuxBPCCondition() {
        return this.auxBPCCondition;
    }

    public void setAuxBPCCondition(Condition auxBPCCondition) {
        this.auxBPCCondition = auxBPCCondition;
    }

    public int getAuxBPCLine() {
        return this.auxBPCLine;
    }

    public void setAuxBPCLine(int auxBPCLine) {
        this.auxBPCLine = auxBPCLine;
    }

    public void endDebug() {
        int i = this.startLine;
        while (i >= 0 && this.sourceCode.getFirstTokenLine((Integer)Integer.valueOf((int)i)).sym != 3) {
            --i;
        }
        if (this.sourceCode.getFirstTokenLine((Integer)Integer.valueOf((int)i)).sym == 3) {
            this.name = (String)this.sourceCode.getFirstTokenLine((Integer)Integer.valueOf((int)i)).value;
        }
        int inputIndex = this.startLine + 1;
        while (this.sourceCode.getFirstTokenLine((Integer)Integer.valueOf((int)inputIndex)).sym != 32) {
            ++inputIndex;
        }
        int outAuxIndex = inputIndex + 1;
        while (!this.sourceCode.isSalidaLine(outAuxIndex)) {
            ++outAuxIndex;
        }
        this.auxVariables = new Variables(this.sourceCode);
        this.outputVariable.setValue(BigInteger.ZERO);
        int runLineIndex = outAuxIndex + 1;
        while (!this.sourceCode.isMetodoLine(runLineIndex)) {
            ++runLineIndex;
        }
        int emptyLine = ++runLineIndex;
        while (this.isEmptyLine(emptyLine)) {
            ++emptyLine;
        }
        this.startCodeLine = this.runLine = emptyLine;
        this.runStack = new Stack();
        this.steps = 0;
    }

    public void addInputs(LinkedList<String> names, LinkedList<BigInteger> values) {
        int i = 0;
        while (i < names.size()) {
            Variable aux = this.inputVariables.getVariable(names.get(i));
            if (aux != null) {
                this.inputVariables.setVariableValue(names.get(i), values.get(i));
            } else {
                this.inputVariables.addVariable(names.get(i), values.get(i), false);
            }
            ++i;
        }
    }

    public void addAuxiliarVariables() {
        LinkedList<String> names = this.sourceCode.getPossibleVariablesName();
        ProgramWhileA auxProgram = null;
        int i = 0;
        while (i < names.size()) {
            if (this.isSourceCodeProgram(names.get(i))) {
                auxProgram = (ProgramWhileA)this.getProgram(names.get(i));
            } else if (auxProgram != null && !auxProgram.isInputVariable(names.get(i)) && !auxProgram.isOutputVariable(names.get(i))) {
                auxProgram.addAndGetVariable(names.get(i), new BigInteger("0"), false);
            }
            ++i;
        }
    }

    public boolean isRecursion() {
        SortedMap<Integer, String> stringLines = this.sourceCode.getSourceCode();
        boolean isRecursion = false;
        for (Program auxProgram : this.programs) {
            int i = auxProgram.getStartLine() + 1;
            while (i <= auxProgram.getEndLine()) {
                if (stringLines.get(i) != null) {
                    String[] tokens;
                    String[] stringArray = tokens = ((String)stringLines.get(i)).split(" ");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s.equalsIgnoreCase(auxProgram.getProgramName()) || s.contains(String.valueOf(auxProgram.getProgramName()) + "(")) {
                            isRecursion = true;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return isRecursion;
    }
}

