/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Condition;
import debugger.Program;
import java.util.LinkedList;
import java.util.Stack;
import java_cup.runtime.Symbol;
import sourceCode.SourceCode;

public class Statement {
    Condition condition;
    InstructionType type;
    int startLine;
    int runLine;
    int endLine;
    Stack<Statement> runStack;
    SourceCode sourceCode;
    Program currentProgram;
    LinkedList<Program> programs;

    public Statement() {
    }

    public Statement(int startLine, Condition condition, Program currentProgram, SourceCode sourceCode, LinkedList<Program> programs) {
        this.sourceCode = sourceCode;
        this.startLine = startLine;
        this.condition = condition;
        this.programs = programs;
        this.currentProgram = currentProgram;
    }

    public static boolean isNumber(String number) {
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public int getRunLine() {
        return this.runLine;
    }

    public void setRunLine(int runLine) {
        this.runLine = runLine;
    }

    public int getFiLine(int start) {
        int sourceSize = this.sourceCode.sizeSourceCode();
        int numFi = 1;
        int index1 = 0;
        int index2 = 1;
        int index3 = 2;
        int fiLine = start + 2;
        int numLinea = start + 1;
        while (numFi > 0 && numLinea <= sourceSize) {
            Symbol token1 = this.sourceCode.getTokenLine(numLinea, index1);
            Symbol token2 = this.sourceCode.getTokenLine(numLinea, index2);
            Symbol token3 = this.sourceCode.getTokenLine(numLinea, index3);
            if (this.sourceCode.isTokenFi(token1) || this.sourceCode.isTokenFi(token2) || this.sourceCode.isTokenFi(token3)) {
                --numFi;
                fiLine = numLinea;
            } else if (this.sourceCode.isTokenIf(token1) || this.sourceCode.isTokenIf(token2) || this.sourceCode.isTokenIf(token3)) {
                ++numFi;
            }
            ++numLinea;
        }
        return fiLine;
    }

    public int getElseLine(int startLine, int endLine) {
        int elseCount = 1;
        int index1 = 0;
        int index2 = 1;
        int index3 = 3;
        int lineaElse = startLine + 2;
        int numLine = startLine + 1;
        String lastToken = "if";
        while (elseCount > 0 && numLine < endLine) {
            Symbol token1 = this.sourceCode.getTokenLine(numLine, index1);
            Symbol token2 = this.sourceCode.getTokenLine(numLine, index2);
            Symbol token3 = this.sourceCode.getTokenLine(numLine, index3);
            if (this.sourceCode.isTokenElse(token1) || this.sourceCode.isTokenElse(token2) || this.sourceCode.isTokenElse(token3)) {
                --elseCount;
                lineaElse = numLine;
                lastToken = "else";
            } else if (this.sourceCode.isTokenIf(token1) || this.sourceCode.isTokenIf(token2) || this.sourceCode.isTokenIf(token3)) {
                ++elseCount;
                lastToken = "if";
            } else if (this.sourceCode.isTokenFi(token1) || this.sourceCode.isTokenFi(token2) || this.sourceCode.isTokenFi(token3) && lastToken.equalsIgnoreCase("if")) {
                --elseCount;
                lastToken = "fi";
            }
            ++numLine;
        }
        if (numLine == endLine) {
            lineaElse = numLine;
        }
        return lineaElse;
    }

    public int getOdLine(int whileLine) {
        int sourceSize = this.sourceCode.sizeSourceCode();
        int odCount = 1;
        int index1 = 0;
        int index2 = 1;
        int index3 = 2;
        int odLine = whileLine + 2;
        int numLinea = whileLine + 1;
        while (odCount > 0 && numLinea <= sourceSize) {
            Symbol token1 = this.sourceCode.getTokenLine(numLinea, index1);
            Symbol token2 = this.sourceCode.getTokenLine(numLinea, index2);
            Symbol token3 = this.sourceCode.getTokenLine(numLinea, index3);
            if (this.sourceCode.isTokenOd(token1) || this.sourceCode.isTokenOd(token2) || this.sourceCode.isTokenOd(token3)) {
                --odCount;
                odLine = numLinea;
            } else if (this.sourceCode.isTokenWhile(token1) || this.sourceCode.isTokenWhile(token2) || this.sourceCode.isTokenWhile(token3) || this.sourceCode.isTokenDo(token1) || this.sourceCode.isTokenDo(token2) || this.sourceCode.isTokenDo(token3)) {
                ++odCount;
            }
            ++numLinea;
        }
        return odLine;
    }

    public InstructionType getType() {
        return this.type;
    }

    static enum InstructionType {
        WHILEDO,
        IFELSE,
        ASSIGNMENT,
        DOTIMES,
        FUNCTION;

    }
}

