/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import java.math.BigInteger;
import sourceCode.SourceCode;

public class Variable {
    private String name;
    private BigInteger value;
    private boolean isFinal;

    public Variable(String nom, BigInteger val, boolean varFinal, SourceCode cod) {
        this.name = nom;
        this.value = val.compareTo(BigInteger.ZERO) < 0 ? new BigInteger("0") : val;
        this.isFinal = varFinal;
    }

    public Variable(String name, BigInteger value, boolean varFinal) {
        this.name = name;
        this.value = value.compareTo(BigInteger.ZERO) < 0 ? new BigInteger("0") : value;
        this.isFinal = varFinal;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(BigInteger value) {
        this.value = value.compareTo(BigInteger.ZERO) < 0 ? new BigInteger("0") : value;
    }

    public void setType(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String toString() {
        return this.isFinal ? this.value.toString() : String.valueOf(this.name) + " = " + this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Variable && ((Variable)object).name.equalsIgnoreCase(this.name) && ((Variable)object).value == this.value && ((Variable)object).isFinal == this.isFinal;
    }
}

