/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Variable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;
import sourceCode.SourceCode;

public class Variables {
    private SourceCode sourceCode;
    private LinkedList<Variable> variables = new LinkedList();

    public Variables() {
        this.sourceCode = null;
    }

    public Variables(SourceCode cod) {
        this.sourceCode = cod;
    }

    public int getVariablesSize() {
        return this.variables.size();
    }

    public boolean isEmptyVariables() {
        return this.variables.isEmpty();
    }

    public void addVariable(String name, BigInteger value, boolean isFinal) {
        boolean found = false;
        Variable aux = new Variable(name, value, isFinal, this.sourceCode);
        Variable auxiliar2 = null;
        for (Variable auxiliar2 : this.variables) {
            if (!auxiliar2.getName().equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            this.variables.add(aux);
        }
    }

    public void removeFinalVariables() {
        LinkedList<Variable> variablesToRemove = new LinkedList<Variable>();
        if (this.variables != null) {
            for (Variable var : this.variables) {
                if (!var.isFinal()) continue;
                variablesToRemove.add(var);
            }
            int i = 0;
            while (i < variablesToRemove.size()) {
                this.variables.remove(variablesToRemove.get(i));
                ++i;
            }
        }
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    public boolean isVariable(String name) {
        boolean found = false;
        if (this.variables != null) {
            Iterator st = this.variables.iterator();
            while (st.hasNext() && !found) {
                Variable variable = (Variable)st.next();
                if (!variable.getName().equalsIgnoreCase(name)) continue;
                found = true;
            }
        }
        return found;
    }

    public void setVariableValue(String name, BigInteger value) {
        boolean found = false;
        Iterator st = this.variables.iterator();
        while (st.hasNext() && !found) {
            Variable var = (Variable)st.next();
            if (!var.getName().equalsIgnoreCase(name)) continue;
            found = true;
            var.setValue(value);
        }
    }

    public void addVariablesLine(int start) {
        int numElements = this.sourceCode.getNumTokenLine(start);
        int i = 3;
        while (i < numElements) {
            if (this.sourceCode.isTokenID(this.sourceCode.getTokenLine(start, i)) || this.sourceCode.isTokenIDWhile(this.sourceCode.getTokenLine(start, i))) {
                this.addVariable((String)this.sourceCode.getTokenLine((Integer)Integer.valueOf((int)start), (int)i).value, new BigInteger("0"), false);
            }
            ++i;
        }
    }

    public void removeVariable(String name) {
        Iterator iter = this.variables.iterator();
        boolean exit = false;
        while (!exit && iter.hasNext()) {
            Variable aux = (Variable)iter.next();
            if (!aux.getName().equalsIgnoreCase(name)) continue;
            this.variables.remove(aux);
            exit = true;
        }
    }

    public Variable getVariable(String name) {
        boolean found = false;
        Variable var = null;
        Iterator st = this.variables.iterator();
        Variable varOut = null;
        var = (Variable)st.next();
        while (var != null && !found) {
            if (var.getName().equalsIgnoreCase(name)) {
                found = true;
                varOut = var;
                continue;
            }
            var = (Variable)st.next();
        }
        return varOut;
    }

    public LinkedList<String> getVariablesName() {
        LinkedList<String> list = new LinkedList<String>();
        for (Variable aux : this.variables) {
            list.add(aux.getName());
        }
        return list;
    }

    public void addInputVariables(int to) {
        Integer index = 1;
        while (index <= to) {
            String name = "X" + index.toString();
            this.addVariable(name, new BigInteger("0"), false);
            index = index + 1;
        }
    }

    public void addAuxiliarVariables(int from, int to) {
        Integer index = from;
        while (index <= to) {
            String name = "X" + index.toString();
            this.addVariable(name, new BigInteger("0"), false);
            index = index + 1;
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (this.variables == null) {
            text.append("No hay variables");
        } else {
            for (Variable aux : this.variables) {
                text.append("\t" + aux.toString() + "\n");
            }
        }
        return text.toString();
    }
}

