/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Variable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JCheckBox;

public class Watches
implements ActionListener {
    private LinkedList<NodeWatch> watches = new LinkedList();
    private LinkedList<Integer> candidates = new LinkedList();
    private int identificador = 0;

    public LinkedList<NodeWatch> getWatches() {
        return this.watches;
    }

    public void addNodeWatch(Variable variable) {
        Integer id = this.identificador;
        ++this.identificador;
        JCheckBox auxCheck = new JCheckBox("", false);
        auxCheck.setActionCommand(id.toString());
        auxCheck.addActionListener(this);
        NodeWatch aux = new NodeWatch(variable, auxCheck, id);
        this.watches.add(aux);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Integer causante = Integer.parseInt(e.getActionCommand());
        this.candidates.add(causante);
    }

    public boolean isVariableWatch(String name) {
        boolean result = false;
        int i = 0;
        while (i < this.watches.size()) {
            if (this.watches.get(i).getVariable().getName().equalsIgnoreCase(name)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void removeNode(int id) {
        boolean end = false;
        Iterator nc = this.watches.iterator();
        while (nc.hasNext() && !end) {
            NodeWatch aux = (NodeWatch)nc.next();
            if (aux.showId() != id) continue;
            this.watches.remove(aux);
            end = true;
        }
    }

    public void update() {
        if (!this.candidates.isEmpty()) {
            int i = 0;
            while (i < this.candidates.size()) {
                this.removeNode(this.candidates.get(i));
                ++i;
            }
            this.candidates = new LinkedList();
        }
    }

    public boolean condicionesPendientes() {
        boolean result = false;
        if (!this.candidates.isEmpty()) {
            result = true;
        }
        return result;
    }

    public LinkedList<Variable> showVariables() {
        LinkedList<Variable> aux = new LinkedList<Variable>();
        int i = 0;
        while (i < this.watches.size()) {
            aux.add(this.watches.get(i).getVariable());
            ++i;
        }
        return aux;
    }

    public static class NodeWatch {
        private int identificador;
        private Variable variable;
        private JCheckBox remove;

        public NodeWatch(Variable variable, JCheckBox checkBox, int id) {
            this.variable = variable;
            this.remove = checkBox;
            this.identificador = id;
        }

        public Variable getVariable() {
            return this.variable;
        }

        public int showId() {
            return this.identificador;
        }

        public JCheckBox getButton() {
            return this.remove;
        }
    }
}

