/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Condition;
import debugger.Program;
import debugger.Statement;
import java.util.LinkedList;
import java.util.Stack;
import sourceCode.SourceCode;

public class WhileDo
extends Statement {
    public WhileDo(int line, Condition cond, Program current, SourceCode sourceList, LinkedList<Program> programs, boolean step, Stack<Statement> stack) {
        this.sourceCode = sourceList;
        this.programs = programs;
        this.condition = cond;
        this.runLine = this.startLine = line;
        this.endLine = this.getOdLine(this.startLine + 1);
        this.currentProgram = current;
        this.runStack = stack;
        this.runStack.push(this);
        this.type = Statement.InstructionType.WHILEDO;
    }

    public int run(Program.StepType step) {
        if (this.runLine == this.startLine) {
            if (this.condition.executeCondition()) {
                ++this.runLine;
            } else {
                this.runLine = this.getOdLine(this.runLine) + 1;
                this.runStack.pop();
            }
        } else {
            this.runLine = this.runLine == this.endLine ? this.startLine : this.currentProgram.run(this.runLine, this.runStack, step);
        }
        return this.runLine;
    }
}

