/*
 * Decompiled with CFR 0.152.
 */
package debuggerPanels;

import debugger.BreakpointCond;
import debugger.Watches;
import debuggerExceptions.DebuggerException;
import debuggerPanels.EditorPanel;
import debuggerPanels.Menu;
import gui.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedMap;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class DebuggerPanel
extends JPanel
implements View {
    private JLabel panelActionState;
    private JTextField variable;
    private JTextField value;
    private JComboBox operating;
    private JButton add;
    private JButton remove;
    private JButton removeWatch;
    private JButton addWatch;
    private JButton BIni;
    private JButton BEditSource;
    private JButton BDp;
    private JButton BDpSusp;
    private JButton BDpCont;
    private JButton BDpFin;
    private JButton BDpStepOver;
    private JButton BDpStepIn;
    private JButton BDpStepOut;
    private JButton BNew;
    private JButton BOpen;
    private JButton BCopy;
    private JButton BCut;
    private JButton BPaste;
    private JButton BSave;
    private JTextPane panelBPC;
    private JTextPane areaWatches;
    private EditorPanel editor;
    private JScrollPane editorScroll;
    private JTextArea panelConfig;
    private JSplitPane editorSplit;
    private JSplitPane leftRightSplit;
    private JSplitPane leftSplit;
    private JPanel panelWatches;
    private Menu menu;

    public DebuggerPanel(Menu menu) {
        this.menu = menu;
        this.initHelpComponent();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        JToolBar panelBotonesEste = new JToolBar(1);
        this.BIni = new JButton(new ImageIcon(this.getClass().getResource("go-button.png")));
        this.BEditSource = new JButton(new ImageIcon(this.getClass().getResource("page_white_edit.png")));
        this.BDp = new JButton(new ImageIcon(this.getClass().getResource("bug_go.png")));
        this.BDpSusp = new JButton(new ImageIcon(this.getClass().getResource("bug_pausar.png")));
        this.BDpCont = new JButton(new ImageIcon(this.getClass().getResource("bug_continuar.png")));
        this.BDpFin = new JButton(new ImageIcon(this.getClass().getResource("bug_parar.png")));
        this.BDpStepOver = new JButton(new ImageIcon(this.getClass().getResource("step_over.png")));
        this.BDpStepIn = new JButton(new ImageIcon(this.getClass().getResource("step_in.png")));
        this.BDpStepOut = new JButton(new ImageIcon(this.getClass().getResource("step_out.png")));
        panelBotonesEste.add(this.BIni);
        panelBotonesEste.add(this.BEditSource);
        panelBotonesEste.addSeparator();
        panelBotonesEste.add(this.BDp);
        panelBotonesEste.add(this.BDpSusp);
        panelBotonesEste.add(this.BDpCont);
        panelBotonesEste.add(this.BDpFin);
        panelBotonesEste.addSeparator();
        panelBotonesEste.add(this.BDpStepOver);
        panelBotonesEste.add(this.BDpStepIn);
        panelBotonesEste.add(this.BDpStepOut);
        this.BIni.setToolTipText("Cargar el programa While ampliado");
        this.BEditSource.setToolTipText("Editar el c\u00f3digo del programa");
        this.BDp.setToolTipText("Depurar el programa completamente");
        this.BDpStepOver.setToolTipText("Step over: Ejecuta una l\u00ednea del programa");
        this.BDpStepIn.setToolTipText("Step in: Ejecuta una l\u00ednea del programa");
        this.BDpStepOut.setToolTipText("Step out: Ejecuta una l\u00ednea del programa");
        this.BDpSusp.setToolTipText("Suspender la ejecucion del programa");
        this.BDpCont.setToolTipText("Continuar con la ejecuci\u00f3n del programa");
        this.BDpFin.setToolTipText("Terminar con la ejecuci\u00f3n del programa");
        this.add((Component)panelBotonesEste, "East");
        JToolBar northPanelButtons = new JToolBar();
        this.BNew = new JButton(new ImageIcon(this.getClass().getResource("document-new.png")));
        this.BOpen = new JButton(new ImageIcon(this.getClass().getResource("document-open.png")));
        this.BCopy = new JButton(new ImageIcon(this.getClass().getResource("edit-copy.png")));
        this.BCut = new JButton(new ImageIcon(this.getClass().getResource("edit-cut.png")));
        this.BPaste = new JButton(new ImageIcon(this.getClass().getResource("edit-paste.png")));
        this.BSave = new JButton(new ImageIcon(this.getClass().getResource("media-floppy.png")));
        northPanelButtons.add(this.BNew);
        northPanelButtons.add(this.BOpen);
        northPanelButtons.add(this.BSave);
        northPanelButtons.addSeparator();
        northPanelButtons.add(this.BCopy);
        northPanelButtons.add(this.BCut);
        northPanelButtons.add(this.BPaste);
        this.BSave.setToolTipText("Guardar");
        this.BNew.setToolTipText("Nuevo");
        this.BOpen.setToolTipText("Abrir");
        this.BCopy.setToolTipText("Copiar");
        this.BCut.setToolTipText("Cortar");
        this.BPaste.setToolTipText("Pegar");
        northPanelButtons.setFloatable(false);
        this.add((Component)northPanelButtons, "North");
        this.panelActionState = new JLabel(" ");
        this.add((Component)this.panelActionState, "South");
        this.editor = new EditorPanel();
        this.editorScroll = new JScrollPane(this.editor);
        this.editorScroll.setVerticalScrollBarPolicy(22);
        this.editorScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Editor"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.areaWatches = new JTextPane();
        this.areaWatches.setEditable(false);
        this.panelWatches = new JPanel();
        this.panelWatches.setLayout(new BorderLayout());
        JToolBar watchesButton = new JToolBar(0);
        this.addWatch = new JButton(new ImageIcon(this.getClass().getResource("Knob_Add.png")));
        this.addWatch.setToolTipText("A\u00f1ade una variable de la tabla");
        watchesButton.add(this.addWatch);
        watchesButton.addSeparator();
        this.removeWatch = new JButton(new ImageIcon(this.getClass().getResource("Knob_Remove_Red.png")));
        this.removeWatch.setToolTipText("Borra una variable de la tabla");
        watchesButton.add(this.removeWatch);
        this.panelWatches.setPreferredSize(new Dimension(100, 220));
        this.panelWatches.add((Component)this.areaWatches, "Center");
        this.panelWatches.add((Component)watchesButton, "South");
        this.panelWatches.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Watches"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.panelConfig = new JTextArea();
        this.panelConfig.setEditable(false);
        JScrollPane configScroll = new JScrollPane(this.panelConfig);
        configScroll.setVerticalScrollBarPolicy(22);
        configScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Configuraciones"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel bpcPanel = new JPanel();
        bpcPanel.setLayout(new BorderLayout());
        this.panelBPC = new JTextPane();
        this.panelBPC.setEditable(false);
        JScrollPane bpc = new JScrollPane(this.panelBPC);
        bpc.setVerticalScrollBarPolicy(22);
        bpc.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Puntos de ruptura condicionales "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel addBPC = new JPanel();
        addBPC.setLayout(new FlowLayout());
        this.variable = new JTextField(5);
        this.variable.setToolTipText("Variable del Programa");
        JLabel var = new JLabel("Variable: ");
        String[] auxOperators = new String[]{"  ", ">", "<", ">=", "<=", "=", "!="};
        this.operating = new JComboBox<String>(auxOperators);
        JLabel op = new JLabel("Operando: ");
        this.value = new JTextField(3);
        this.value.setToolTipText("N\u00famero natural");
        JLabel val = new JLabel("Valor: ");
        this.add = new JButton("A\u00f1adir");
        this.add.setToolTipText("A\u00f1ade un punto de ruptura condicional");
        addBPC.add(var);
        addBPC.add(this.variable);
        addBPC.add(op);
        addBPC.add(this.operating);
        addBPC.add(val);
        addBPC.add(this.value);
        addBPC.add(this.add);
        addBPC.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("A\u00f1adir punto de ruptura condicional"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel removeBPC = new JPanel();
        removeBPC.setLayout(new FlowLayout());
        JLabel removeTitle = new JLabel("Eliminar condiciones seleccionadas");
        this.remove = new JButton(new ImageIcon(this.getClass().getResource("Knob_Remove_Red.png")));
        this.remove.setToolTipText("Elimina los puntos de ruptura condicional");
        removeBPC.add(removeTitle);
        removeBPC.add(this.remove);
        removeBPC.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Eliminar punto de ruptura condicional"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        bpcPanel.add((Component)addBPC, "North");
        bpcPanel.add((Component)bpc, "Center");
        bpcPanel.add((Component)removeBPC, "South");
        bpcPanel.setMinimumSize(new Dimension(500, 300));
        this.leftRightSplit = new JSplitPane(1, bpcPanel, this.panelWatches);
        this.leftRightSplit.setContinuousLayout(true);
        this.leftRightSplit.setMinimumSize(new Dimension(450, 350));
        this.leftSplit = new JSplitPane(0, this.leftRightSplit, configScroll);
        this.leftSplit.setContinuousLayout(true);
        this.editorScroll.setMinimumSize(new Dimension(480, 200));
        this.editorSplit = new JSplitPane(1, this.editorScroll, this.leftSplit);
        this.add((Component)this.editorSplit, "Center");
        this.editSourceState();
    }

    public void debugStepState(boolean estado) {
        this.BDpStepOver.setEnabled(estado);
        this.BDpStepOut.setEnabled(estado);
        this.BDpStepIn.setEnabled(estado);
    }

    public void editSourceCodeState(boolean estado) {
        this.BNew.setEnabled(estado);
        this.BOpen.setEnabled(estado);
        this.BSave.setEnabled(estado);
        this.BCopy.setEnabled(estado);
        this.BCut.setEnabled(estado);
        this.BPaste.setEnabled(estado);
    }

    @Override
    public void setRunState(boolean estado) {
        this.BDpSusp.setEnabled(estado);
        this.BDpCont.setEnabled(estado);
        this.BDpFin.setEnabled(estado);
        this.menu.debugState();
    }

    public void setDebugPanelState(boolean estado) {
        this.add.setEnabled(estado);
        this.remove.setEnabled(estado);
        this.variable.setEnabled(estado);
        this.operating.setEnabled(estado);
        this.value.setEnabled(estado);
        this.addWatch.setEnabled(estado);
        this.removeWatch.setEnabled(estado);
    }

    @Override
    public void finishRunState() {
        this.editor.disablePanelLines();
        this.BEditSource.setEnabled(true);
        this.BDp.setEnabled(false);
        this.debugStepState(false);
        this.setRunState(false);
        this.setDebugPanelState(false);
        this.menu.endDebug();
    }

    @Override
    public void editSourceState() {
        this.editSourceCodeState(true);
        this.BIni.setEnabled(true);
        this.BEditSource.setEnabled(false);
        this.BDp.setEnabled(false);
        this.debugStepState(false);
        this.setRunState(false);
        this.setDebugPanelState(false);
        this.editor.disablePanelLines();
        this.menu.editState();
    }

    @Override
    public void debugState() {
        this.BIni.setEnabled(false);
        this.BEditSource.setEnabled(true);
        this.setDebugPanelState(true);
        this.BDp.setEnabled(true);
        this.debugStepState(true);
        this.editor.activatePanelLines();
        this.editSourceCodeState(false);
        this.menu.debugStepState();
    }

    public void enableSourceCode() {
        this.BIni.setEnabled(true);
    }

    public void enableRun() {
        this.BDpSusp.setEnabled(true);
        this.BDpCont.setEnabled(true);
        this.BDpFin.setEnabled(true);
    }

    @Override
    public void controladorRatonPD(MouseAdapter adapter) {
        this.editor.controladorRaton(adapter);
    }

    @Override
    public void controlador(ActionListener controlador) {
        this.BIni.addActionListener(controlador);
        this.BIni.setActionCommand("LOAD_SOURCE_CODE");
        this.BEditSource.addActionListener(controlador);
        this.BEditSource.setActionCommand("EDIT");
        this.BDp.addActionListener(controlador);
        this.BDp.setActionCommand("DEBUG");
        this.BDpStepOver.addActionListener(controlador);
        this.BDpStepOver.setActionCommand("STEP_OVER");
        this.BDpStepIn.addActionListener(controlador);
        this.BDpStepIn.setActionCommand("STEP_INTO");
        this.BDpStepOut.addActionListener(controlador);
        this.BDpStepOut.setActionCommand("STEP_OUT");
        this.BDpSusp.addActionListener(controlador);
        this.BDpSusp.setActionCommand("STOP");
        this.BDpCont.addActionListener(controlador);
        this.BDpCont.setActionCommand("CONTINUE");
        this.BDpFin.addActionListener(controlador);
        this.BDpFin.setActionCommand("END");
        this.BNew.addActionListener(controlador);
        this.BNew.setActionCommand("NEW");
        this.BOpen.addActionListener(controlador);
        this.BOpen.setActionCommand("OPEN");
        this.BSave.addActionListener(controlador);
        this.BSave.setActionCommand("SAVE");
        this.BCopy.addActionListener(controlador);
        this.BCopy.setActionCommand("COPY");
        this.BCut.addActionListener(controlador);
        this.BCut.setActionCommand("CUT");
        this.BPaste.addActionListener(controlador);
        this.BPaste.setActionCommand("PASTE");
        this.add.addActionListener(controlador);
        this.add.setActionCommand("ADD_BPC");
        this.remove.addActionListener(controlador);
        this.remove.setActionCommand("REMOVE_BPC");
        this.addWatch.addActionListener(controlador);
        this.addWatch.setActionCommand("ADD_WATCH");
        this.removeWatch.addActionListener(controlador);
        this.removeWatch.setActionCommand("REMOVE_WATCH");
    }

    public void initStylesForTextPane(JTextPane textPane) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = textPane.addStyle("regular", def);
        StyleConstants.setFontSize(def, 18);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = textPane.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = textPane.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = textPane.addStyle("large", regular);
        StyleConstants.setFontSize(s, 15);
        s = textPane.addStyle("red", regular);
        StyleConstants.setFontSize(s, 18);
        StyleConstants.setForeground(s, Color.blue);
        StyleConstants.setBackground(s, Color.red);
        s = textPane.addStyle("redbold", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.blue);
        StyleConstants.setBackground(s, Color.red);
    }

    @Override
    public void actionState(String s) {
        this.panelActionState.setText(String.valueOf(this.editor.getFilename()) + " : " + s);
    }

    @Override
    public File openFile() throws BadLocationException {
        StringBuilder text = new StringBuilder();
        JFileChooser selector = new JFileChooser();
        selector.setFileSelectionMode(0);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("Archivo de Texto (.txt)", "txt");
        selector.setFileFilter(filtro);
        selector.showOpenDialog(null);
        File file = selector.getSelectedFile();
        if (file != null) {
            this.removeTextEditor();
            try {
                String line;
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    text.append(String.valueOf(line) + "\n");
                }
                bufferedReader.close();
                this.appendTextEditor(text.toString());
            }
            catch (IOException ioException) {
                throw new DebuggerException("Error en la lectura del fichero");
            }
        }
        return file;
    }

    @Override
    public File saveTemporaryFile() {
        File textFile = new File("depurar.txt");
        try {
            FileWriter textOut = new FileWriter(textFile);
            textOut.write(String.valueOf(this.getTextEditor()) + "\n");
            textOut.close();
        }
        catch (IOException ioException) {
            throw new DebuggerException("Error al crear el fichero");
        }
        return textFile;
    }

    public File saveFile() {
        String fileName = this.editor.getFilename();
        File textFile = new File(fileName);
        try {
            FileWriter textOut = new FileWriter(textFile);
            textOut.write(this.getTextEditor());
            textOut.close();
        }
        catch (IOException ioException) {
            throw new DebuggerException("Error al crear el fichero");
        }
        return textFile;
    }

    @Override
    public File saveFileAs() {
        File file = null;
        PrintWriter writer = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "La extension del archivo debe de ser (*.txt)");
            }
        });
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        int select = fileChooser.showSaveDialog(this.editor);
        if (select == 0) {
            file = fileChooser.getSelectedFile();
        }
        try {
            if (file != null) {
                writer = new PrintWriter(new FileWriter(file));
                writer.print(this.getTextEditor());
                writer.close();
                this.editor.changeFilename(file.getName());
            }
        }
        catch (IOException ioException) {
            throw new DebuggerException("Error al crear el fichero");
        }
        return file;
    }

    @Override
    public void aboutDebugger() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "                                         UNIVERSIDAD DE M\u00c1LAGA \n                ESCUELA T\u00c9CNICA SUPERIOR DE INGENIER\u00cdA INFORM\u00c1TICA \n                     INGENIERO T\u00c9CNICO EN INFORM\u00c1TICA DE SISTEMAS \n\n                                         Proyecto Fin de Carrera \n                       Entorno de Ejecuci\u00f3n y Depuraci\u00f3n de Algoritmos\n                                  para la M\u00e1quina Abstracta WHILE \n\n                                                Realizado por \n                               Miguel \u00c1ngel P\u00e9rez de los Santos \n\n                                                 Dirigido por \n                               Juan Miguel Ortiz de Lazcano Lobato \n\n                                                 Departamento \n                              Lenguajes y Ciencias de la Computaci\u00f3n\n\n                     Soporte para aritm\u00e9tica multiprecisi\u00f3n a\u00f1adido por\n                                           Ezequiel L\u00f3pez Rubio ");
            }
        });
    }

    private void initHelpComponent() {
        try {
            URL fileURL = DebuggerPanel.class.getResource("help_set.hs");
            HelpSet helpset = new HelpSet(this.getClass().getClassLoader(), fileURL);
            HelpBroker hb = helpset.createHelpBroker();
            hb.enableHelpOnButton(this.menu.getMenuHelpItem(), "aplicacion", helpset);
        }
        catch (Exception e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Mensaje", 2);
                }
            });
        }
    }

    @Override
    public void paintConfigurations(String s) {
        if (this.panelConfig.getText().equals("")) {
            this.panelConfig.setText(s);
        } else {
            this.panelConfig.setText(String.valueOf(this.panelConfig.getText()) + "\n" + s);
        }
    }

    @Override
    public void removeConfigurations() {
        this.panelConfig.setText("");
    }

    @Override
    public void changeStateEditor(boolean estado) {
        this.editor.changeStateEditor(estado);
    }

    @Override
    public void appendTextEditor(String s) {
        this.editor.addTextEditor(s);
    }

    @Override
    public void copyTextEditor() {
        this.editor.copyTextEditor();
    }

    @Override
    public void cutTextEditor() {
        this.editor.cutTextEditor();
    }

    @Override
    public void setTextEditor(String s) {
        this.editor.setTextEditor(s);
    }

    @Override
    public String getTextEditor() {
        return this.editor.getTextEditor();
    }

    @Override
    public void removeTextEditor() {
        this.editor.removeTextEditor();
    }

    @Override
    public void pasteTextEditor() {
        this.editor.pasteTextEditor();
    }

    @Override
    public void paintRun(SortedMap<Integer, String> source, int sourceSize, LinkedList<Integer> breakPoints, int runLine) {
        this.editor.paintRun(source, sourceSize, breakPoints, runLine);
    }

    @Override
    public int sizeLine() {
        return this.editor.sizeLine();
    }

    @Override
    public int sizeEditor() {
        return this.editor.sizeEditor();
    }

    @Override
    public String getConditionVariable() {
        return this.variable.getText();
    }

    @Override
    public String getConditionOperator() {
        int index = this.operating.getSelectedIndex();
        return this.operating.getItemAt(index).toString();
    }

    @Override
    public String getConditionValue() {
        return this.value.getText();
    }

    @Override
    public void removeBPC() {
        this.panelBPC.setText("");
    }

    @Override
    public void removeWatches() {
        this.areaWatches.setText("");
    }

    @Override
    public String getFilename() {
        return this.editor.getFilename();
    }

    @Override
    public void changeFilename(String newName) {
        this.editor.changeFilename(newName);
    }

    @Override
    public void paintWatches(Watches w) {
        this.areaWatches.setText("");
        this.initStylesForTextPane(this.areaWatches);
        Document doc = this.areaWatches.getDocument();
        int i = 0;
        while (i < w.getWatches().size()) {
            this.areaWatches.insertComponent(w.getWatches().get(i).getButton());
            try {
                doc.insertString(doc.getLength(), "  " + w.getWatches().get(i).getVariable().toString(), this.areaWatches.getStyle("large"));
                doc.insertString(doc.getLength(), "\n  ----------------------- \n", this.areaWatches.getStyle("large"));
            }
            catch (BadLocationException e) {
                throw new DebuggerException("Error al mostrar las variables");
            }
            ++i;
        }
    }

    @Override
    public void setProgramWhile(boolean isWhile) {
        this.editor.setProgramWhile(isWhile);
    }

    @Override
    public Menu getMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    @Override
    public JTextPane getBPC() {
        return this.panelBPC;
    }

    @Override
    public boolean isProgramLoad() {
        return !this.BIni.isEnabled();
    }

    @Override
    public String getEditorText() {
        return this.editor.getEditorText();
    }

    @Override
    public void paintBPC(HashMap<String, BreakpointCond> conditions) {
        this.panelBPC.setText("");
        this.initStylesForTextPane(this.panelBPC);
        Document doc = this.panelBPC.getDocument();
        Set<String> programsBPC = conditions.keySet();
        for (String programName : programsBPC) {
            int i = 0;
            while (i < conditions.get(programName).getConditions().size()) {
                this.panelBPC.insertComponent(conditions.get(programName).getNodeConditions().get(i).selectedBox());
                try {
                    doc.insertString(doc.getLength(), "      " + programName + "   " + conditions.get(programName).getNodeConditions().get(i).getCondition().toString() + "\n", this.panelBPC.getStyle("large"));
                    doc.insertString(doc.getLength(), "-------------------------------------------------------\n", this.panelBPC.getStyle("large"));
                }
                catch (BadLocationException e) {
                    throw new DebuggerException("Error al mostrar los puntos de ruptura condicionales");
                }
                ++i;
            }
        }
    }
}

