/*
 * Decompiled with CFR 0.152.
 */
package debuggerPanels;

import debuggerExceptions.DebuggerException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.util.LinkedList;
import java.util.SortedMap;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class EditorPanel
extends JPanel {
    private String filename = "new.txt";
    boolean isWhile;
    private JTextPane panelEditor;
    private Document document;
    protected FontMetrics fm;
    String newline;
    private BreakPointPanel panelLine;

    public EditorPanel() {
        Font regular = new Font("regular", 0, 18);
        new JPanel();
        this.setLayout(new BorderLayout());
        this.panelEditor = new JTextPane();
        this.initStylesForTextPane(this.panelEditor);
        this.panelEditor.setFont(regular);
        this.panelEditor.setCaretPosition(0);
        this.panelEditor.addCaretListener(new MyCaretListener());
        this.fm = this.panelEditor.getFontMetrics(regular);
        this.document = this.panelEditor.getDocument();
        this.panelLine = new BreakPointPanel();
        this.add((Component)this.panelLine, "West");
        this.add((Component)this.panelEditor, "Center");
    }

    public void changeStateEditor(boolean estado) {
        this.panelEditor.setEditable(estado);
    }

    public void controladorRaton(MouseAdapter adapter) {
        this.panelLine.controladorRaton(adapter);
    }

    public int sizeLine() {
        return this.fm.getHeight();
    }

    public void resetEditorText() {
        this.panelEditor.setText("");
    }

    public void addTextEditor(String s) {
        Document doc = this.panelEditor.getDocument();
        try {
            doc.insertString(doc.getLength(), s, this.panelEditor.getStyle("regular"));
        }
        catch (BadLocationException e) {
            throw new DebuggerException("Error al escribir en el editor de texto");
        }
    }

    public void setTextEditor(String s) {
        this.removeTextEditor();
        this.initStylesForTextPane(this.panelEditor);
        Document doc = this.panelEditor.getDocument();
        try {
            doc.insertString(0, s, this.panelEditor.getStyle("regular"));
        }
        catch (BadLocationException e) {
            throw new DebuggerException("Error al escribir en el editor de texto");
        }
    }

    public void removeTextEditor() {
        this.panelEditor.setText("");
    }

    public String getTextEditor() {
        return this.panelEditor.getText();
    }

    public void cutTextEditor() {
        this.panelEditor.cut();
    }

    public void copyTextEditor() {
        this.panelEditor.copy();
    }

    public void pasteTextEditor() {
        this.panelEditor.paste();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintRun(SortedMap<Integer, String> sourceCode, int sizeSourceCode, LinkedList<Integer> points, int runLine) {
        int cursorPosition = 0;
        this.panelEditor.setText("");
        Document doc = this.panelEditor.getDocument();
        int i = 0;
        while (i <= sizeSourceCode) {
            block15: {
                String newLine;
                block14: {
                    newLine = (String)sourceCode.get(i);
                    if (newLine == null) {
                        newLine = "                     ";
                    }
                    if (!points.contains(i)) break block14;
                    if (i == runLine) {
                        try {
                            doc.insertString(doc.getLength(), String.valueOf(newLine) + "\n", this.panelEditor.getStyle("redbold"));
                        }
                        catch (BadLocationException e) {
                            throw new DebuggerException("Error al escribir la l\u00ednea de ejecuci\u00f3n");
                        }
                        cursorPosition = doc.getLength();
                        break block15;
                    } else {
                        try {
                            doc.insertString(doc.getLength(), String.valueOf(newLine) + "\n", this.panelEditor.getStyle("red"));
                        }
                        catch (BadLocationException e) {
                            throw new DebuggerException("Error al escribir la l\u00ednea de ejecuci\u00f3n");
                        }
                    }
                }
                if (i == runLine) {
                    try {
                        doc.insertString(doc.getLength(), String.valueOf(newLine) + "\n", this.panelEditor.getStyle("blue"));
                    }
                    catch (BadLocationException e) {
                        throw new DebuggerException("Error al escribir la l\u00ednea de ejecuci\u00f3n");
                    }
                    cursorPosition = doc.getLength();
                } else {
                    try {
                        doc.insertString(doc.getLength(), String.valueOf(newLine) + "\n", this.panelEditor.getStyle("noBold"));
                    }
                    catch (BadLocationException e) {
                        throw new DebuggerException("Error al escribir la l\u00ednea de ejecuci\u00f3n");
                    }
                }
            }
            ++i;
        }
        this.panelEditor.setCaretPosition(cursorPosition);
    }

    public int sizeEditor() {
        return this.panelEditor.getDocument().getDefaultRootElement().getElementCount();
    }

    public int getLineLength(int line) {
        Element lineElement = this.panelEditor.getDocument().getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
    }

    public void initStylesForTextPane(JTextPane textPane) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = textPane.addStyle("regular", def);
        StyleConstants.setFontSize(def, 18);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = textPane.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = textPane.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = textPane.addStyle("noBold", regular);
        StyleConstants.setBold(s, false);
        s = textPane.addStyle("blue", regular);
        StyleConstants.setFontSize(s, 18);
        StyleConstants.setBackground(s, new Color(102, 204, 255));
        s = textPane.addStyle("red", regular);
        StyleConstants.setFontSize(s, 18);
        StyleConstants.setBackground(s, new Color(255, 51, 51));
        s = textPane.addStyle("redbold", regular);
        StyleConstants.setFontSize(s, 18);
        StyleConstants.setBold(s, true);
        StyleConstants.setBackground(s, new Color(255, 51, 51));
    }

    public void setProgramWhile(boolean isWhile) {
        this.isWhile = isWhile;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.document.addDocumentListener(listener);
    }

    public void disablePanelLines() {
        this.panelLine.setEnabled(false);
    }

    public void activatePanelLines() {
        this.panelLine.setEnabled(true);
    }

    public String getFilename() {
        return this.filename;
    }

    public void changeFilename(String name) {
        this.filename = name;
    }

    public String getEditorText() {
        return this.panelEditor.getText();
    }

    public class BreakPointPanel
    extends JPanel {
        private int sizeSourceCode;

        public BreakPointPanel() {
            new JPanel();
            int lineHeight = EditorPanel.this.fm.getHeight();
            int high = this.getPreferredSize().height;
            int sizeLineVisible = high / lineHeight;
            int width = EditorPanel.this.fm.stringWidth(String.valueOf(sizeLineVisible));
            this.setPreferredSize(new Dimension(width + 30, high));
            this.setOpaque(true);
            this.setToolTipText("A\u00f1adir / eliminar punto de ruptura");
            this.sizeSourceCode = 0;
        }

        public void controladorRaton(MouseAdapter adapter) {
            this.addMouseListener(adapter);
        }

        @Override
        public void paint(Graphics g) {
            super.paintComponent(g);
            int lineaHeight = EditorPanel.this.fm.getHeight();
            g.setColor(new Color(153, 153, 204));
            if (EditorPanel.this.isWhile) {
                Integer i = 0;
                while (i < this.sizeSourceCode - 1) {
                    if (i < 2) {
                        g.drawString(String.valueOf(i.toString()) + "   |", 0, (i + 1) * lineaHeight);
                    } else {
                        Integer j = i - 1;
                        if (i < 10) {
                            g.drawString(String.valueOf(i.toString()) + "   | " + j.toString(), 0, (i + 1) * lineaHeight);
                        } else {
                            g.drawString(String.valueOf(i.toString()) + "| " + j.toString(), 0, (i + 1) * lineaHeight);
                        }
                    }
                    i = i + 1;
                }
            } else {
                Integer i = 0;
                while (i < this.sizeSourceCode) {
                    g.drawString(i.toString(), 0, (i + 1) * lineaHeight);
                    i = i + 1;
                }
            }
        }

        public void changeNumLines(int newLines) {
            this.sizeSourceCode = newLines;
        }
    }

    protected class MyCaretListener
    implements CaretListener {
        protected MyCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            EditorPanel.this.panelLine.changeNumLines(EditorPanel.this.sizeEditor());
            EditorPanel.this.panelLine.revalidate();
            EditorPanel.this.panelLine.repaint();
        }
    }
}

