/*
 * Decompiled with CFR 0.152.
 */
package debuggerPanels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InputsTable
extends JDialog {
    private JScrollPane scroll;
    private JLabel text;
    private JButton okButton;
    private LinkedList<String> inputs;
    private LinkedList<BigInteger> inputsValues;
    private LinkedList<JTextField> inputsText;

    public InputsTable(Frame parent, boolean modal, LinkedList<String> ent) {
        super(parent, modal);
        this.inputs = ent;
        this.inputsText = new LinkedList();
        this.inputsValues = new LinkedList();
        this.text = new JLabel("Entradas del Programa");
        this.okButton = new JButton("Aceptar");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel main = new JPanel();
        main.setBackground(new Color(0xE0E0E0));
        main.setFont(new Font("Dialog", 0, 15));
        main.setLayout(new BoxLayout(main, 1));
        for (String input : this.inputs) {
            JPanel row = new JPanel();
            row.add(new JLabel(String.valueOf(input) + "  "));
            JTextField text = new JTextField(7);
            text.setText("0");
            text.setFont(new Font("Dialog", 0, 15));
            this.inputsText.add(text);
            row.add(text);
            main.add(row);
        }
        this.scroll = new JScrollPane(main, 22, 30);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputsTable.this.acceptActionPerformed(e);
            }
        });
        this.text.setPreferredSize(new Dimension(200, 50));
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "North");
        this.add((Component)this.scroll, "Center");
        this.add((Component)this.okButton, "South");
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setTitle("Entradas");
        this.pack();
        this.okButton.requestFocus();
        this.setVisible(true);
    }

    public LinkedList<BigInteger> getInputs() {
        return this.inputsValues;
    }

    void acceptActionPerformed(ActionEvent e) {
        for (JTextField text : this.inputsText) {
            BigInteger value;
            block9: {
                value = new BigInteger("0");
                try {
                    try {
                        value = new BigInteger(text.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (value == null || value.compareTo(BigInteger.ZERO) < 0) {
                            value = new BigInteger("0");
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (value == null || value.compareTo(BigInteger.ZERO) < 0) {
                        value = new BigInteger("0");
                    }
                    throw throwable;
                }
                if (value == null || value.compareTo(BigInteger.ZERO) < 0) {
                    value = new BigInteger("0");
                }
            }
            this.inputsValues.add(value);
        }
        this.setVisible(false);
    }
}

