/*
 * Decompiled with CFR 0.152.
 */
package gui;

import debugger.BreakpointCond;
import debugger.Condition;
import debugger.ContrProgram;
import debugger.Program;
import debugger.ProgramWhile;
import debugger.ProgramWhileA;
import debugger.Variable;
import debugger.Watches;
import debuggerExceptions.DebuggerException;
import debuggerPanels.InputBPCAdd;
import debuggerPanels.InputsTable;
import gui.View;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;

public class Control
implements ActionListener {
    private View window;
    private ContrProgram control;
    private Program program;
    private boolean endDebug;
    private File fileEditor;
    private LinkedList<Integer> breakpoints;
    private HashMap<String, BreakpointCond> bpcs;
    private int index;
    private MiMouseAdapter mouseAdapter;
    private RunThread thread;
    private InputsTable inputs;
    private Watches variablesWatches;

    public Control(View view) {
        this.window = view;
        this.control = new ContrProgram();
        this.index = 0;
        this.breakpoints = new LinkedList();
        this.bpcs = new LinkedHashMap<String, BreakpointCond>();
        this.variablesWatches = new Watches();
        this.endDebug = true;
        this.mouseAdapter = new MiMouseAdapter();
    }

    public MiMouseAdapter mouseAdapter() {
        return this.mouseAdapter;
    }

    public boolean isMainProgramWhile() {
        return !this.program.isWhileA();
    }

    @Override
    public void actionPerformed(ActionEvent av) {
        int numLine;
        String command = av.getActionCommand();
        if (command.equals("NEW")) {
            this.window.removeTextEditor();
            this.window.actionState(" ");
            this.window.changeFilename("nuevo.txt");
        }
        if (command.equals("OPEN")) {
            File file = null;
            try {
                file = this.window.openFile();
            }
            catch (BadLocationException e) {
                this.window.actionState("Error al abrir el fichero de texto");
                throw new DebuggerException("Error al abrir el fichero de texto");
            }
            if (file != null) {
                this.window.changeFilename(file.getName());
                this.window.actionState("Fichero cargado");
            } else {
                this.window.actionState("Operaci\u00f3n cancelada");
            }
        }
        if (command.equals("RESET") && this.window.isProgramLoad()) {
            int confirmation = JOptionPane.showConfirmDialog(null, "\u00bf Desea salir de Depurador de WHILE Ampliado ?");
            if (confirmation == 0) {
                this.window.setTextEditor("");
                this.window.editSourceState();
                this.window.removeWatches();
                this.variablesWatches = new Watches();
                this.window.removeBPC();
                this.program.removeAllBPC();
                this.program.removeAllBreakpoints();
                this.window.removeConfigurations();
                this.window.changeStateEditor(true);
                this.fileEditor.delete();
            } else if (confirmation == 1 || confirmation == 2) {
                // empty if block
            }
        }
        if (command.equals("LOAD_SOURCE_CODE") && !this.window.getEditorText().isEmpty()) {
            this.fileEditor = this.window.saveTemporaryFile();
            this.fileEditor.deleteOnExit();
            if (!this.control.loadSourceCode(this.fileEditor)) {
                this.control.loadPrograms();
                this.program = this.control.getMainProgram();
                if (this.program.isWhileA() && !((ProgramWhileA)this.program).isRecursion() || !this.program.isWhileA()) {
                    if (!this.program.isWhileA() && !this.control.programComment() || this.program.isWhileA()) {
                        this.window.setProgramWhile(!this.program.isWhileA() && !this.control.programComment());
                        this.inputs = new InputsTable(null, true, this.program.getInputVariable());
                        if (this.program.isWhileA()) {
                            ((ProgramWhileA)this.program).addInputs(this.program.getInputVariable(), this.inputs.getInputs());
                            ((ProgramWhileA)this.program).addAuxiliarVariables();
                        } else {
                            ((ProgramWhile)this.program).addInputs(this.inputs.getInputs());
                            this.paintConfiguration();
                        }
                        this.window.setTextEditor(this.control.paintSourceCode());
                        numLine = this.program.getRunLine();
                        this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, numLine);
                        this.window.actionState("Estructura inicializada, el programa principal es " + this.program.getProgramName() + ".");
                        this.window.debugState();
                        this.window.changeStateEditor(false);
                        this.endDebug = false;
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, "No se permiten comentarios en un programa WHILE", "Mensaje", 0);
                            }
                        });
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "No se permiten llamadas recursivas en el programa", "Mensaje", 0);
                        }
                    });
                }
            } else {
                this.window.actionState("Error en la lectura del fichero.");
            }
        }
        if (command.equals("EDIT")) {
            this.window.setTextEditor("");
            this.window.setTextEditor(this.control.paintSourceCode());
            this.window.editSourceState();
            this.window.removeWatches();
            this.variablesWatches = new Watches();
            this.window.removeBPC();
            this.program.removeAllBPC();
            this.bpcs = new LinkedHashMap<String, BreakpointCond>();
            this.program.removeAllBreakpoints();
            this.breakpoints = new LinkedList();
            this.window.removeConfigurations();
            this.window.changeStateEditor(true);
            this.fileEditor.delete();
        }
        if (command.equals("DEBUG")) {
            this.window.actionState("Ejecutando ...");
            this.thread = new RunThread(this.program.getProgramName());
            this.window.setRunState(true);
            this.thread.start();
            this.window.actionState("Fin de la ejecuci\u00f3n");
        }
        if (command.equals("STEP_OVER")) {
            boolean end = false;
            try {
                end = this.program.step(Program.StepType.STEP_OVER);
                this.window.paintWatches(this.variablesWatches);
                this.paintConfiguration();
            }
            catch (Exception e) {
                this.window.actionState("Error en la lectura del fichero.");
                throw new DebuggerException("Error en la lectura del fichero");
            }
            numLine = this.program.getRunLine();
            this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, numLine);
            if (end) {
                this.endRun();
            } else if (this.program.programsStopBPC()) {
                this.program.nextLineRunAfterBPC();
                this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, this.program.getRunLine() + 1);
                final Condition bpc = this.program.getprogramsBPC();
                this.program.setProgramContinueBPC();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Se ha cumplido la condici\u00f3n " + bpc, "Mensaje", 2);
                    }
                });
            }
        }
        if (command.equals("STEP_OUT")) {
            if (this.program.getRunLine() < this.program.getEndLine() + 1 && this.program.getRunLine() > this.program.getStartLine()) {
                this.window.actionState("Depurando ...");
                this.thread = new RunThread(this.program.getProgramName());
                this.window.setRunState(true);
                this.thread.start();
                this.window.actionState("Fin depuraci\u00f3n");
            } else {
                boolean end = false;
                boolean breakpointEnd = false;
                int level = this.program.runStackSize();
                while (!(breakpointEnd || this.program.getRunLine() <= this.program.getEndLine() + 1 && this.program.getRunLine() >= this.program.getStartLine())) {
                    int programLine = this.program.getRunLine();
                    if (!this.program.programsStopBPC()) {
                        this.program.checkBreakpoint(programLine);
                        if (!this.program.programsStopBreakpoint()) {
                            try {
                                end = this.program.step(Program.StepType.STEP_INTO);
                            }
                            catch (Exception e) {
                                this.window.actionState("Error en la ejecuci\u00f3n del programa WHILE");
                                throw new DebuggerException("Error en la ejecuci\u00f3n del programa WHILE");
                            }
                            this.paintConfiguration();
                            this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, programLine);
                            continue;
                        }
                        this.window.paintWatches(this.variablesWatches);
                        this.paintConfiguration();
                        this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, programLine);
                        breakpointEnd = true;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, "Programa parado por un punto de ruptura incondicional en la l\u00ef\u00bf\u00bdnea " + Control.this.program.getRunLine(), "Mensaje", 2);
                            }
                        });
                        continue;
                    }
                    this.program.nextLineRunAfterBPC();
                    this.window.paintWatches(this.variablesWatches);
                    this.paintConfiguration();
                    this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, this.program.getNextRunLine());
                    final Condition bpc = this.program.getprogramsBPC();
                    this.program.setProgramContinueBPC();
                    breakpointEnd = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Se ha cumplido la condici\u00f3n " + bpc, "Mensaje", 2);
                        }
                    });
                }
                if (end) {
                    this.endRun();
                } else {
                    numLine = this.program.getRunLine();
                    this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, numLine);
                }
            }
        }
        if (command.equals("STEP_INTO")) {
            boolean endProgram = false;
            try {
                endProgram = this.program.step(Program.StepType.STEP_INTO);
                this.window.paintWatches(this.variablesWatches);
                this.paintConfiguration();
            }
            catch (Exception e) {
                this.window.actionState("Error en la ejecuci\u00f3n del programa WHILE");
                throw new DebuggerException("Error en la ejecuci\u00f3n del programa WHILE");
            }
            numLine = this.program.getRunLine();
            this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, numLine);
            if (endProgram) {
                this.endRun();
            } else if (this.program.programsStopBPC()) {
                this.program.nextLineRunAfterBPC();
                this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, this.program.getNextRunLine());
                final Condition bpc = this.program.getprogramsBPC();
                this.program.setProgramContinueBPC();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Se ha cumplido la condici\u00f3n " + bpc, "Mensaje", 2);
                    }
                });
            }
        }
        if (command.equals("STOP")) {
            this.thread.stop();
            numLine = this.program.getRunLine();
            this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, numLine);
            this.window.actionState("Suspendido en programa \"" + this.program.getProgramName() + "  \" en la l\u00ednea " + numLine);
        }
        if (command.equals("CONTINUE")) {
            this.thread = new RunThread(this.program.getProgramName());
            this.thread.start();
            this.window.setRunState(true);
            this.window.actionState("Fin de la ejecuci\u00f3n");
        }
        if (command.equals("END")) {
            this.thread.stop();
            this.endDebug = true;
            this.window.finishRunState();
            this.window.removeWatches();
            this.variablesWatches = new Watches();
            this.window.removeBPC();
            this.program.removeAllBPC();
            this.bpcs = new LinkedHashMap<String, BreakpointCond>();
            this.breakpoints = new LinkedList();
            this.program.removeAllBreakpoints();
            this.window.removeConfigurations();
            this.window.setTextEditor(this.control.paintSourceCode());
            this.window.actionState("Terminada la ejecuci\u00f3n del programa \"" + this.program.getProgramName() + "  \" ");
        }
        if (command.equals("ADD_BREAKPOINT")) {
            Integer breakLine = -1;
            try {
                breakLine = Integer.parseInt(JOptionPane.showInputDialog("Introduzca la l\u00ednea donde establecer el punto de ruptura "));
            }
            catch (NumberFormatException e) {
                this.window.actionState("Error.Campo de valor vac\u00edo");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Campo de valor vac\u00edo. El punto de ruptura no se a\u00f1adira", "Mensaje", 2);
                    }
                });
            }
            if (this.program != null) {
                boolean bpInserted = false;
                for (Program auxProgram : this.control.getPrograms()) {
                    if (bpInserted) continue;
                    int startLine = auxProgram.getStartCodeLine();
                    int endLine = auxProgram.getEndProgramLine();
                    if (breakLine < startLine || breakLine > endLine || auxProgram.isEmptyLine(breakLine)) continue;
                    bpInserted = true;
                    this.breakpoints.add(breakLine);
                    auxProgram.addBreakpoint(breakLine);
                    this.window.actionState("A\u00f1adido punto de ruptua en la l\u00ef\u00bf\u00bdnea " + breakLine);
                    numLine = auxProgram.getRunLine();
                    this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, this.program.getRunLine());
                }
                if (!bpInserted && breakLine != -1) {
                    final String message = "No es posible establecer un punto de ruptura en la l\u00ednea " + breakLine;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, message, "Mensaje", 0);
                        }
                    });
                    this.window.actionState("Error al a\u00f1adir punto de ruptura");
                }
            }
        }
        if (command.equals("REMOVE_BREAKPOINT")) {
            Integer breakLine = 0;
            if (this.breakpoints.isEmpty()) {
                final String message = "No existe puntos de ruptura en el programa " + this.program.getProgramName();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, message, "Mensaje", 2);
                    }
                });
            } else {
                try {
                    breakLine = Integer.parseInt(JOptionPane.showInputDialog("Introduzca la l\u00ednea del punto de ruptura "));
                }
                catch (NumberFormatException e) {
                    this.window.actionState("Error. Campo de valor vac\u00edo");
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Campo de valor vac\u00edo. El punto de ruptura no se eliminara", "Mensaje", 2);
                        }
                    });
                }
                for (Program auxProgram : this.control.getPrograms()) {
                    int startLine = auxProgram.getStartCodeLine();
                    int endLine = auxProgram.getEndProgramLine();
                    if (breakLine < startLine || breakLine > endLine) continue;
                    if (this.breakpoints.contains(breakLine)) {
                        this.breakpoints.remove(breakLine);
                        auxProgram.removeBreakpoint(breakLine);
                        numLine = this.program.getRunLine();
                        this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, numLine);
                        continue;
                    }
                    final String message = "No existe un punto de ruptura en la l\u00ednea " + breakLine;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, message, "Mensaje", 2);
                        }
                    });
                }
            }
        }
        if (command.equals("REMOVE_ALL_BREAKPOINTS")) {
            for (Program auxProgram : this.control.getPrograms()) {
                if (auxProgram == null) continue;
                this.breakpoints = new LinkedList();
                auxProgram.setBreakpoints(this.breakpoints);
            }
            this.window.paintRun(this.control.getSourceCode(), this.control.sizeSourceCode(), this.breakpoints, this.program.getRunLine());
        }
        if (command.equals("ADD_BPC")) {
            boolean variableFound = false;
            for (Program auxProgram : this.control.getPrograms()) {
                Condition cond;
                if (!auxProgram.isVariable(this.window.getConditionVariable()) || variableFound) continue;
                variableFound = true;
                Variable var = auxProgram.getVariable(this.window.getConditionVariable());
                BigInteger value = new BigInteger("0");
                try {
                    try {
                        value = new BigInteger(Integer.toString(Integer.parseInt(this.window.getConditionValue())));
                    }
                    catch (NumberFormatException e) {
                        this.window.actionState("Campo de valor vac\u00edo. Por defecto tomara valor 0");
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, "Campo de valor vac\u00edo. Por defecto tomara valor 0", "Mensaje", 2);
                            }
                        });
                        Variable val = new Variable("temp" + this.index, value, true);
                        cond = new Condition(var, val, this.window.getConditionOperator(), auxProgram);
                        if (auxProgram.isBPC(auxProgram.getProgramName(), cond)) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(null, "El punto de ruptura condicional ya existe ... ", "Mensaje", 2);
                                }
                            });
                            continue;
                        }
                        auxProgram.addBPC(cond);
                        this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                        this.window.paintBPC(this.bpcs);
                        this.window.actionState("A\u00f1adido punto de ruptura condicional: " + cond);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Variable val = new Variable("temp" + this.index, value, true);
                    cond = new Condition(var, val, this.window.getConditionOperator(), auxProgram);
                    if (auxProgram.isBPC(auxProgram.getProgramName(), cond)) {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        auxProgram.addBPC(cond);
                        this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                        this.window.paintBPC(this.bpcs);
                        this.window.actionState("A\u00f1adido punto de ruptura condicional: " + cond);
                    }
                    throw throwable;
                }
                Variable val = new Variable("temp" + this.index, value, true);
                cond = new Condition(var, val, this.window.getConditionOperator(), auxProgram);
                if (auxProgram.isBPC(auxProgram.getProgramName(), cond)) {
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
                auxProgram.addBPC(cond);
                this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                this.window.paintBPC(this.bpcs);
                this.window.actionState("A\u00f1adido punto de ruptura condicional: " + cond);
            }
            if (!variableFound) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "No es posible a\u00f1adir esta variable como punto de ruptura condicional", "Mensaje", 2);
                    }
                });
            }
        }
        if (command.equals("ADD_BPC_MENU")) {
            InputBPCAdd bpcInput = new InputBPCAdd(null, true);
            boolean variableFound = false;
            for (Program auxProgram : this.control.getPrograms()) {
                Condition cond;
                if (!auxProgram.isVariable(bpcInput.getVariable()) || variableFound) continue;
                variableFound = true;
                Variable var = auxProgram.getVariable(bpcInput.getVariable());
                BigInteger value = new BigInteger("0");
                try {
                    try {
                        value = new BigInteger(Integer.toString(Integer.parseInt(bpcInput.getValue())));
                    }
                    catch (NumberFormatException e) {
                        this.window.actionState("Campo de valor vac\u00edo. Por defecto tomara valor 0");
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, "Campo de valor vac\u00edo. Por defecto tomara valor 0", "Mensaje", 2);
                            }
                        });
                        Variable val = new Variable("temp" + this.index, value, true);
                        cond = new Condition(var, val, bpcInput.getOperating(), auxProgram);
                        if (auxProgram.isBPC(auxProgram.getProgramName(), cond)) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(null, "El punto de ruptura condicional ya existe ... ", "Mensaje", 2);
                                }
                            });
                            continue;
                        }
                        auxProgram.addBPC(cond);
                        this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                        this.window.paintBPC(this.bpcs);
                        this.window.actionState("A\u00f1adido punto de ruptura condicional: " + cond);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Variable val = new Variable("temp" + this.index, value, true);
                    cond = new Condition(var, val, bpcInput.getOperating(), auxProgram);
                    if (auxProgram.isBPC(auxProgram.getProgramName(), cond)) {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        auxProgram.addBPC(cond);
                        this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                        this.window.paintBPC(this.bpcs);
                        this.window.actionState("A\u00f1adido punto de ruptura condicional: " + cond);
                    }
                    throw throwable;
                }
                Variable val = new Variable("temp" + this.index, value, true);
                cond = new Condition(var, val, bpcInput.getOperating(), auxProgram);
                if (auxProgram.isBPC(auxProgram.getProgramName(), cond)) {
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
                auxProgram.addBPC(cond);
                this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                this.window.paintBPC(this.bpcs);
                this.window.actionState("A\u00f1adido punto de ruptura condicional: " + cond);
            }
            if (!variableFound) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "No es posible a\u00f1adir esta variable como punto de ruptura condicional", "Mensaje", 2);
                    }
                });
            }
        }
        if (command.equals("REMOVE_BPC")) {
            boolean variableFound = false;
            for (Program auxProgram : this.control.getPrograms()) {
                if (!auxProgram.updateConditions()) continue;
                variableFound = true;
                auxProgram.updateCondition();
                this.bpcs.put(auxProgram.getProgramName(), auxProgram.getBPC());
                this.window.removeBPC();
                this.window.paintBPC(this.bpcs);
                this.window.actionState("Condiciones eliminadas");
            }
            if (!variableFound) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Seleccione alg\u00fan punto de ruptura condicional", "Warning", 2);
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Los puntos de ruptura condicional seleccionados se han eliminado", "Warning", 2);
                    }
                });
            }
        }
        if (command.equals("REMOVE_ALL_BPC_MENU")) {
            this.window.removeBPC();
            this.program.removeAllBPC();
            this.bpcs = new LinkedHashMap<String, BreakpointCond>();
            this.window.actionState("Todas las condiciones han sido eliminadas");
        }
        if (command.equals("SAVE")) {
            File file = this.window.saveFileAs();
            if (file != null) {
                this.window.actionState("Archivo guardado como " + file.getName());
            } else {
                this.window.actionState("Operaci\u00f3n cancelada");
            }
        }
        if (command.equals("COPY")) {
            this.window.copyTextEditor();
        }
        if (command.equals("CUT")) {
            this.window.cutTextEditor();
        }
        if (command.equals("PASTE")) {
            this.window.pasteTextEditor();
        }
        if (command.equals("EXIT")) {
            int confirmation = JOptionPane.showConfirmDialog(null, "\u00bf Desea salir de Depurador de while Ampliado ?");
            if (confirmation == 0) {
                System.exit(0);
            } else if (confirmation == 1 || confirmation == 2) {
                // empty if block
            }
        }
        if (command.equals("ADD_WATCH")) {
            String varName = JOptionPane.showInputDialog("Nombre de la variable:");
            boolean variableFound = false;
            for (Program auxProgram : this.control.getPrograms()) {
                if (!auxProgram.isVariable(varName) || variableFound) continue;
                variableFound = true;
                if (!this.variablesWatches.isVariableWatch(varName)) {
                    Variable varAux = auxProgram.getVariable(varName);
                    this.variablesWatches.addNodeWatch(varAux);
                    this.window.paintWatches(this.variablesWatches);
                    continue;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "La variable ya esta siendo visualizada");
                    }
                });
            }
            if (!variableFound) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "La variable no pertenece al programa " + Control.this.program.getProgramName());
                    }
                });
            }
        }
        if (command.equals("REMOVE_WATCH")) {
            if (this.variablesWatches.condicionesPendientes()) {
                this.variablesWatches.update();
                this.window.removeWatches();
                this.window.paintWatches(this.variablesWatches);
                this.window.actionState("Variables eliminadas");
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Seleccione alguna variable del programa", "Warning", 2);
                    }
                });
            }
        }
        if (command.equals("ABOUT")) {
            this.window.aboutDebugger();
        }
    }

    public void paintConfiguration() {
        if (!this.program.isWhileA()) {
            if (((ProgramWhile)this.program).updateConfiguration()) {
                this.window.paintConfigurations(((ProgramWhile)this.program).showConfigurations());
            }
        } else {
            this.window.paintConfigurations("");
        }
    }

    public void endRun() {
        final String result = "Nombre del programa: " + this.program.getProgramName() + "\n" + this.program.toString() + "\n" + "Pasos de computo: " + this.program.getSteps();
        this.window.finishRunState();
        this.endDebug = true;
        this.window.removeWatches();
        this.variablesWatches = new Watches();
        this.window.removeBPC();
        this.program.removeAllBPC();
        this.bpcs = new LinkedHashMap<String, BreakpointCond>();
        this.breakpoints = new LinkedList();
        this.program.setBreakpoints(this.breakpoints);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, result, "Resultado", -1);
            }
        });
    }

    public class MiMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            int point = e.getPoint().y;
            int size = Control.this.window.sizeLine();
            Integer breakLine = new Integer(point / size);
            if (Control.this.program != null && !Control.this.endDebug) {
                boolean bpInserted = false;
                for (Program auxProgram : Control.this.control.getPrograms()) {
                    if (bpInserted) continue;
                    int startLine = auxProgram.getStartCodeLine();
                    int endLine = auxProgram.getEndProgramLine();
                    if (breakLine < startLine || breakLine > endLine || auxProgram.isEmptyLine(breakLine)) continue;
                    if (Control.this.breakpoints.contains(breakLine)) {
                        Control.this.breakpoints.remove(breakLine);
                        auxProgram.removeBreakpoint(breakLine);
                    } else {
                        Control.this.breakpoints.add(breakLine);
                        auxProgram.addBreakpoint(breakLine);
                    }
                    Control.this.window.actionState("A\u00f1adido punto de ruptua en la l\u00ednea " + breakLine);
                    Control.this.window.paintRun(Control.this.control.getSourceCode(), Control.this.control.sizeSourceCode(), Control.this.breakpoints, Control.this.program.getRunLine());
                }
            }
        }
    }

    public class RunThread
    extends Thread {
        public RunThread(String str) {
            super(str);
        }

        @Override
        public void run() {
            boolean end = false;
            boolean breakpointEnd = false;
            while (!breakpointEnd && !end) {
                int programLine = Control.this.program.getRunLine();
                if (!Control.this.program.programsStopBPC()) {
                    Control.this.program.checkBreakpoint(programLine);
                    if (!Control.this.program.programsStopBreakpoint()) {
                        try {
                            end = Control.this.program.step(Program.StepType.STEP_INTO);
                        }
                        catch (Exception e) {
                            Control.this.window.actionState("Error en la ejecuci\u00f3n del programa WHILE");
                            throw new DebuggerException("Error en la ejecuci\u00f3n del programa WHILE");
                        }
                        Control.this.paintConfiguration();
                        Control.this.window.paintRun(Control.this.control.getSourceCode(), Control.this.control.sizeSourceCode(), Control.this.breakpoints, programLine);
                        continue;
                    }
                    Control.this.window.paintRun(Control.this.control.getSourceCode(), Control.this.control.sizeSourceCode(), Control.this.breakpoints, programLine);
                    Control.this.window.paintWatches(Control.this.variablesWatches);
                    Control.this.paintConfiguration();
                    breakpointEnd = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Programa parado por un punto de ruptura incondicional en la l\u00ednea " + Control.this.program.getRunLine(), "Mensaje", 2);
                        }
                    });
                    continue;
                }
                Control.this.program.nextLineRunAfterBPC();
                final Condition bpc = Control.this.program.getprogramsBPC();
                Control.this.program.setProgramContinueBPC();
                breakpointEnd = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int nextLine = Control.this.program.getNextRunLine();
                        if (nextLine > Control.this.program.getEndLine() + 1) {
                            ++nextLine;
                        }
                        Control.this.window.paintWatches(Control.this.variablesWatches);
                        Control.this.paintConfiguration();
                        Control.this.window.paintRun(Control.this.control.getSourceCode(), Control.this.control.sizeSourceCode(), Control.this.breakpoints, nextLine);
                        JOptionPane.showMessageDialog(null, "Se ha cumplido la condici\u00f3n " + bpc, "Mensaje", 2);
                    }
                });
            }
            if (end) {
                Control.this.endRun();
            }
        }
    }
}

