/*
 * Decompiled with CFR 0.152.
 */
package sourceCode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.SortedMap;
import java_cup.runtime.Symbol;
import sourceCode.Parser;
import sourceCode.Yylex;

public class SourceCode {
    private Yylex lexer;
    private Parser parser;
    private boolean lexicalError = false;
    private boolean syntacticError = false;
    private LinkedList<String> possibleVariablesName = new LinkedList();

    public SourceCode(File source) {
        try {
            BufferedReader bf = new BufferedReader(new FileReader(source));
            this.lexer = new Yylex(bf);
            this.parser = new Parser(this.lexer);
            Symbol sroot = this.parser.parse();
        }
        catch (Exception e) {
            this.lexicalError = this.lexer.getData().isLexicalError();
            this.syntacticError = this.lexer.getData().isSyntacticError();
        }
        if (!this.lexicalError && !this.syntacticError) {
            Object aux;
            System.out.println(" CODIGO TOKENS numero de lineas:" + this.lexer.getData().getSize());
            System.out.println(" --------------------------------------------------------------------- ");
            SortedMap<Integer, LinkedList<Symbol>> symbolMap = this.lexer.getData().getSourceTokens();
            SortedMap<Integer, String> map = this.lexer.getData().getSourceCode();
            int i = 0;
            while (i <= this.lexer.getData().getSize() + 1) {
                aux = (LinkedList)symbolMap.get(new Integer(i));
                System.out.print(String.valueOf(i) + " ");
                if (aux != null) {
                    int j = 0;
                    while (j < ((LinkedList)aux).size()) {
                        System.out.print(((LinkedList)aux).get(j) + " ");
                        if (!this.isTokenNum((Symbol)((LinkedList)aux).get(j)) && (this.isTokenID((Symbol)((LinkedList)aux).get(j)) || this.isTokenIDWhile((Symbol)((LinkedList)aux).get(j))) && (((LinkedList)aux).size() > j + 1 && !this.isTokenParIz((Symbol)((LinkedList)aux).get(j + 1)) || ((LinkedList)aux).size() == 1 || j == ((LinkedList)aux).size() - 1)) {
                            this.addPossibleVariablesName((String)((Symbol)((LinkedList)aux).get((int)j)).value);
                        }
                        ++j;
                    }
                } else {
                    LinkedList<Symbol> aux2 = new LinkedList<Symbol>();
                    aux2.add(new Symbol(36, "vacia"));
                    symbolMap.put(new Integer(i), aux2);
                }
                System.out.println(" ");
                ++i;
            }
            System.out.println(" --------------------------------------------------------------------- ");
            System.out.println(" C\u00d3DIGO FUENTE n\u00famero de l\u00edneas:" + this.lexer.getData().getSize());
            System.out.println(" --------------------------------------------------------------------- ");
            i = 0;
            while (i <= this.lexer.getData().getSize()) {
                aux = (String)map.get(new Integer(i));
                System.out.println((String)aux);
                ++i;
            }
            System.out.println(" --------------------------------------------------------------------- ");
        }
    }

    public boolean isCommentLine() {
        boolean result = false;
        SortedMap<Integer, LinkedList<Symbol>> map = this.lexer.getData().getSourceTokens();
        int i = 0;
        while (i <= this.lexer.getData().getSize() + 1) {
            LinkedList aux = (LinkedList)map.get(new Integer(i));
            if (aux != null && this.isTokenComment((Symbol)aux.get(0))) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public int sizeSourceCode() {
        return this.lexer.getData().getSize();
    }

    public SortedMap<Integer, String> getSourceCode() {
        return this.lexer.getData().getSourceCode();
    }

    public boolean isTokenWhile(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 19;
        }
        return result;
    }

    public boolean isTokenSep(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 11;
        }
        return result;
    }

    public boolean isTokenEOF(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 0;
        }
        return result;
    }

    public boolean isTokenOd(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 21;
        }
        return result;
    }

    public boolean isTokenDo(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 20;
        }
        return result;
    }

    public boolean isTokenIf(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 22;
        }
        return result;
    }

    public boolean isTokenElse(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 23;
        }
        return result;
    }

    public boolean isTokenFi(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 24;
        }
        return result;
    }

    public boolean isStartToken(Symbol token) {
        return this.isTokenWhile(token) || this.isTokenDo(token) || this.isTokenIf(token);
    }

    public boolean isTokenID(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 3;
        }
        return result;
    }

    public boolean isTokenComa(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 9;
        }
        return result;
    }

    public boolean isTokenPuntoComa(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 10;
        }
        return result;
    }

    public boolean isTokenParIz(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 14;
        }
        return result;
    }

    public boolean isTokenParDer(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 15;
        }
        return result;
    }

    public boolean isTokenNum(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 4 || token.numSym() == 16 || token.numSym() == 17;
        }
        return result;
    }

    public boolean isTokenIDWhile(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 18;
        }
        return result;
    }

    public boolean isTokenOpSum(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 5;
        }
        return result;
    }

    public boolean isTokenOpMult(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 6;
        }
        return result;
    }

    public boolean isTokenComment(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 2;
        }
        return result;
    }

    public boolean isTokenEmptyLine(Symbol token) {
        boolean result = false;
        if (token != null) {
            result = token.numSym() == 36;
        }
        return result;
    }

    public boolean isStartProgramLineW(Integer line) {
        return ((Symbol)((LinkedList)this.lexer.getData().getSourceTokens().get(line)).getFirst()).numSym() == 31;
    }

    public boolean isStartProgramLineWA(Integer line) {
        return ((Symbol)((LinkedList)this.lexer.getData().getSourceTokens().get(line)).getFirst()).numSym() == 32;
    }

    public boolean isEndProgramLineW(Integer line) {
        boolean result = false;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = ((Symbol)listaAux.getFirst()).numSym() == 33;
        }
        return result;
    }

    public boolean isEndProgramLineWA(Integer line) {
        boolean result = false;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = ((Symbol)listaAux.getFirst()).numSym() == 34;
        }
        return result;
    }

    public boolean isEndSourceCodeLine(Integer line) {
        boolean result = false;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = ((Symbol)listaAux.getFirst()).numSym() == 35;
        }
        return result;
    }

    public boolean isMetodoLine(Integer line) {
        boolean result = false;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = ((Symbol)listaAux.getFirst()).numSym() == 30;
        }
        return result;
    }

    public boolean isSalidaLine(Integer line) {
        boolean result = false;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = ((Symbol)listaAux.getFirst()).numSym() == 29;
        }
        return result;
    }

    public boolean isEntradasLine(Integer line) {
        boolean result = false;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = ((Symbol)listaAux.getFirst()).numSym() == 28;
        }
        return result;
    }

    public int getNumTokenLine(Integer line) {
        int result = 0;
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = listaAux.size();
        }
        return result;
    }

    public Symbol getTokenLine(Integer line, int element) {
        Symbol result = null;
        if (line <= this.sizeSourceCode() && element < this.getNumTokenLine(line)) {
            result = (Symbol)((LinkedList)this.lexer.getData().getSourceTokens().get(line)).get(element);
        }
        return result;
    }

    public Symbol getFirstTokenLine(Integer line) {
        Symbol result = null;
        if (line <= this.sizeSourceCode()) {
            result = (Symbol)((LinkedList)this.lexer.getData().getSourceTokens().get(line)).getFirst();
        }
        return result;
    }

    public String getFirstStringLine(Integer line) {
        String result = "";
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = (String)this.lexer.getData().getSourceCode().get(line);
        }
        return result;
    }

    public String paintLine(Integer line) {
        String result = "";
        LinkedList listaAux = (LinkedList)this.lexer.getData().getSourceTokens().get(line);
        if (listaAux != null) {
            result = (String)this.lexer.getData().getSourceCode().get(line);
        }
        return result;
    }

    public boolean isSourceCodeError() {
        return this.lexicalError || this.syntacticError;
    }

    public LinkedList<String> getPossibleVariablesName() {
        return this.possibleVariablesName;
    }

    public void addPossibleVariablesName(String variableName) {
        if (!this.possibleVariablesName.contains(variableName)) {
            this.possibleVariablesName.add(variableName);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String string = "";
        int i = 0;
        while (i <= this.sizeSourceCode()) {
            string = this.lexer.getData().getSourceCode().get(i) == null ? "\n" : String.valueOf((String)this.lexer.getData().getSourceCode().get(i)) + "\n";
            result.append(string);
            ++i;
        }
        return result.toString();
    }
}

