% Batch tests of Unbiased Kernel Regression, T1 test image
% The full execution of this file may take days to complete
% Reference:
% E. Lpez-Rubio, M.N. Florentn-Nez, Kernel regression based feature extraction for 3D MR image denoising
% Medical Image Analysis. DOI:10.1016/j.media.2011.02.006
clear all

FileName='t1_icbm_normal_1mm_pn0_rf0.12bits.mat';
MatFileName='BatchUKR_t1_icbm_normal.mat';

% Load the original image
load(FileName,'MyData');

GroundTruth=double(MyData)/4095; % Values in the interval [0,1]
clear MyData;


% Do tests
FinalResults=[];
NdxLevel=1;
for NoiseLevel=0.01:0.02:0.09
    
    Quality=[];
    for NdxTest=1:10
        % Set pseudorandom number generator
        randn('state',NdxTest);

        % Generate noisy image
        OrigImg=ricernd(GroundTruth,NoiseLevel);

        % Denoise
        Results=UKR(OrigImg);    

        % Evaluate restoration quality
        Quality{NdxTest}=RestorationQuality(255*GroundTruth,255*Results.zkr);

        % Save intermediate results
        save('TempBatchT1.mat','Quality');
    end
    
    % Get final results
    FieldNames={'MSE','RMSE','PSNR','SSIM','BC'};    
    for NdxField=1:numel(FieldNames)
        for NdxTest=1:10
            MyData(NdxTest)=Quality{NdxTest}.(FieldNames{NdxField});
        end
        FinalResults{NdxLevel}.(FieldNames{NdxField}).Mean=mean(MyData);
        FinalResults{NdxLevel}.(FieldNames{NdxField}).StdDev=std(MyData);
    end

    % Save final results
    RestoredImg{NdxLevel}=uint8(255*Results.zkr);
    ElapsedTime{NdxLevel}=Results.ElapsedTime;
    save(MatFileName,'Quality','FinalResults','RestoredImg','ElapsedTime');
    NdxLevel=NdxLevel+1;
end



