% Unbiased Kernel Regression demo
% Reference:
% E. Lpez-Rubio, M.N. Florentn-Nez, Kernel regression based feature extraction for 3D MR image denoising
% Medical Image Analysis. DOI:10.1016/j.media.2011.02.006 
clear all

% Ask for the image type
ContinueAsking=1;
while ContinueAsking
    ImageType=input('Image type (t1, t2, pd)? ','s');
    ContinueAsking=(strcmp(ImageType,'t1')==0) & (strcmp(ImageType,'t2')==0) ...
        & (strcmp(ImageType,'pd')==0);
end

% Ask for the noise level
ContinueAsking=1;
while ContinueAsking
    NoiseLevel=input('Rician noise level (1, 3, 5, 7, 9)? ');
    ContinueAsking=(sum(NoiseLevel==[1 3 5 7 9])==0);
end
NoiseLevel=NoiseLevel/100;

FileName=sprintf('%s_icbm_normal_1mm_pn0_rf0.12bits.mat',ImageType);

% Load the original image
load(FileName,'MyData');

GroundTruth=double(MyData)/4095; % Values in the interval [0,1]
clear MyData;


% Ask for the desired slice
ContinueAsking=1;
while ContinueAsking
    MySlice=input(sprintf('Image slice to be displayed (1-%d)? ',size(GroundTruth,3)));
    ContinueAsking=~((MySlice>=1) & (MySlice<=size(GroundTruth,3)) & (MySlice==round(MySlice)));
end

% Compute the relevant section of the input image
if MySlice<10
    NdxIni=1;
    NdxMySlice=MySlice;
else
    NdxIni=MySlice-9;
    NdxMySlice=10;
end
NdxEnd=min(size(GroundTruth,3),MySlice+9);

% Restrict the input to the relevant section (this saves much time)
GroundTruth=GroundTruth(:,:,NdxIni:NdxEnd);


% Generate noisy image
OrigImg=ricernd(GroundTruth,NoiseLevel);

% Denoise
tic
Results=UKR(OrigImg);
toc

% Evaluate restoration quality
Quality=RestorationQuality(255*GroundTruth,255*Results.zkr);

imshow(GroundTruth(:,:,NdxMySlice))
hold on
title('Noiseless image')

figure
imshow(OrigImg(:,:,NdxMySlice))
title('Noisy image')

figure
imshow(Results.zkr(:,:,NdxMySlice))
title('Restored image')





    
