function [LowPass,GradX,GradY,GradZ]=EdgeDetectFourier(OrigImg,SmoothingParameter)
% Smooth and detect edges in a 3D image by Fast Fourier Transform
% SmoothingParameter>0 controls the degree of smoothing:
%   Smoothing=1 leaves most details (and noise)
%   Smoothing=4 removes many details (and noise)

S1=floor(size(OrigImg,1)/2);
S1end=S1-1+mod(size(OrigImg,1),2);
S2=floor(size(OrigImg,2)/2);
S2end=S2-1+mod(size(OrigImg,2),2);
S3=floor(size(OrigImg,3)/2);
S3end=S3-1+mod(size(OrigImg,3),2);
[X Y Z]=ndgrid(-S1:S1end,-S2:S2end,-S3:S3end);

% More details are removed as Sigma diminishes: if Sigma is small, more
% high frequency components are discarded
Sigma=max(size(OrigImg))/SmoothingParameter;

MaskFilterLowPass=exp(-(1/Sigma^2)*(X.^2+Y.^2+Z.^2));
%Constant=(2*pi*(Sigma^2));
%MaskFilterLowPass=Constant*MaskFilterLowPass;
FilterLowPass=ifftshift(MaskFilterLowPass);

FilterGradientX=ifftshift(exp(-(1/Sigma^2)*(X.^2+Y.^2+Z.^2)).*(-2*X/(Sigma^2)));
%FilterGradientX=FilterGradientX/sum(FilterGradientX(:));

FilterGradientY=ifftshift(exp(-(1/Sigma^2)*(X.^2+Y.^2+Z.^2)).*(-2*Y/(Sigma^2)));
%FilterGradientY=FilterGradientY/sum(FilterGradientY(:));

FilterGradientZ=ifftshift(exp(-(1/Sigma^2)*(X.^2+Y.^2+Z.^2)).*(-2*Z/(Sigma^2)));
%FilterGradientZ=FilterGradientZ/sum(FilterGradientZ(:));

TransOrig=fftn(OrigImg);

LowPass=real(ifftn(TransOrig.*FilterLowPass));
%Constant=1/max(LowP(:));
GradX=imag(ifftn(TransOrig.*FilterGradientX));
GradY=imag(ifftn(TransOrig.*FilterGradientY));
GradZ=imag(ifftn(TransOrig.*FilterGradientZ));



