function [Results]=RestorationQuality(OrigImg,RestoredImg)
% Computes restoration quality measures for images in the [0,255] range, as in:
% C.S. Anand, J.S. Sahambi / Magnetic Resonance Imaging 28 (2010) 842861


PlainErrors=(OrigImg-RestoredImg);

% Mean Squared Error (MSE)
Results.MSE=mean(PlainErrors(:).^2);

% Root Mean Squared Error (RMSE)
Results.RMSE=sqrt(Results.MSE);

% Power Signal-to-Noise Ratio (PSNR)
Results.PSNR=10*log10((255^2)/Results.MSE);

% Structural Similarity Index (SSIM)
for ZSlice=1:size(OrigImg,3)
    SSIM(ZSlice)=ssim_index(OrigImg(:,:,ZSlice),RestoredImg(:,:,ZSlice));
end
Results.SSIM=mean(SSIM);

% Bhattacharrya coefficient (BC)
HistOrig=histc(OrigImg(:),0:256);
HistOrig=HistOrig/sum(HistOrig);
HistRestored=histc(RestoredImg(:),0:256);
HistRestored=HistRestored/sum(HistRestored);
Results.BC=sum(sqrt(HistOrig.*HistRestored));


