function [Vmedian] = median3D(V,padoption)
% Compute the median on a 3x3x3 neighborhood
% Olivier Salvado, Case Western Reserve University, 16Aug04
% Ezequiel Lpez-Rubio, University of Mlaga, 23Sep10



if ~exist('padoption','var')
    padoption = 'replicate';
end

V = single(padarray(V,[1 1 1],padoption));
Vmedian=zeros(size(V),'single');
S = size(V);


%% Compute by sections to save memory
for Ndx=1:4:size(V,1)
    NdxEnd=min(Ndx+3,size(V,1));
    
    Vn=zeros(NdxEnd-Ndx+1,S(2),S(3),27,'single');
    
    i = Ndx:NdxEnd; ip1 = [i(2:end) min(i(end)+1,size(V,1))]; im1 = [max(i(1)-1,1) i(1:end-1)];
    j = 1:S(2); jp1 = [j(2:end) j(end)]; jm1 = [j(1) j(1:end-1)];
    k = 1:S(3); kp1 = [k(2:end) k(end)]; km1 = [k(1) k(1:end-1)];
    
    %%
    Vn(:,:,:,1) = V(i,j,k);
    % left
    Vn(:,:,:,2)     = V(im1    ,jm1    ,km1);
    Vn(:,:,:,3)     = V(im1    ,j      ,km1);
    Vn(:,:,:,4)     = V(im1    ,jp1    ,km1);
    
    Vn(:,:,:,5)     = V(im1    ,jm1    ,k);
    Vn(:,:,:,6)     = V(im1    ,j      ,k);
    Vn(:,:,:,7)     = V(im1    ,jp1    ,k);
    
    Vn(:,:,:,8)     = V(im1    ,jm1    ,kp1);
    Vn(:,:,:,9)     = V(im1    ,j      ,kp1);
    Vn(:,:,:,10)    = V(im1    ,jp1    ,kp1);
    
    %%
    % right
    Vn(:,:,:,11)    = V(ip1    ,jm1    ,km1);
    Vn(:,:,:,12)    = V(ip1    ,j      ,km1);
    Vn(:,:,:,13)    = V(ip1    ,jp1    ,km1);
    
    Vn(:,:,:,14)    = V(ip1    ,jm1    ,k);
    Vn(:,:,:,15)    = V(ip1    ,j      ,k);
    Vn(:,:,:,16)    = V(ip1    ,jp1    ,k);
    
    Vn(:,:,:,17)    = V(ip1    ,jm1    ,kp1);
    Vn(:,:,:,18)    = V(ip1    ,j      ,kp1);
    Vn(:,:,:,19)    = V(ip1    ,jp1    ,kp1);
    
    %%
    % top
    Vn(:,:,:,20)    = V(i       ,jm1    ,kp1);
    Vn(:,:,:,21)    = V(i       ,j      ,kp1);
    Vn(:,:,:,22)    = V(i       ,jp1    ,kp1);
    
    %%
    % bottom
    Vn(:,:,:,23)    = V(i       ,jm1    ,km1);
    Vn(:,:,:,24)    = V(i       ,j      ,km1);
    Vn(:,:,:,25)    = V(i       ,jp1    ,km1);
    
    %%
    % front
    Vn(:,:,:,26)    = V(i       ,jp1    ,k);
    
    %%
    % back
    Vn(:,:,:,27)    = V(i       ,jm1    ,k);
    
    Vn=sort(Vn,4);
    Vmedian(Ndx:NdxEnd,:,:) = Vn(:,:,:,14);
end


Vmedian = Vmedian(2:end-1,2:end-1,2:end-1,:);








