// Mathematics 361 Finite Automata
// Term Project: Simulation of Post Machine
// 
// Group Participants:
//	
// Qian Chang
// Ron Eggers
// Mando Gomez
//
// Due Date: May, 2000
//
// For detailed documentation consult analyst's notes and user's manual
//
// Note: There is error no exception handling as far entering the correct 
//       data types. For this program to execute and be useful. The user
//       must enter the correct types when prompted. There are two types
//       of data required interactively: (1) integer input to indicate a state
//       number, size of alphabet, or size of transition table and 
//       (2) character input to indicate the alphabet of the input tape or store. 
//       This must be done as requested otherwise this program will crash.
//
//
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <iomanip.h>
#define  MAXQUEUE  250			// MAXQUEUE is the upper bound on the
								// maximum number of characters in the
								// plus one
#define MAX 10

class CharQueue{

private:
	char elements[MAXQUEUE];	// CharQueue of characters
	int	 front;					// array index of slot preceding front
	int  rear;					// index of slot containing rear

public:

	// Constructor initailizes CharQueue to empty state

	CharQueue()
	{
		front = 0;
		rear  = 0;
	}

	// makenullCharQueue() initailizes CharQueue to empty state

	void makenullCharQueue()
	{
		front = 0;
		rear  = 0;
	}

	// emptyCharQueue() indicates whether queue is empty

	bool emptyCharQueue()
	{
		return front == rear;
	}

	// fullCharQueue() indicates whether queue is full

	bool fullCharQueue()
	{
		return ((rear % MAXQUEUE) + 1) == front;
	}

	// enqueue(char x) adds a new character to rear of queue

	void enqueue(char x)
	{
		rear = (rear % MAXQUEUE) + 1;
		elements[rear] = x;
	}

	// dequeue() removes the front element from the queue and returns it

	char dequeue()
	{
		front = (front % MAXQUEUE) + 1;
		return elements[front];

	}
	
	// printQueue() prints the contents of the queue

	void printQueue()
	{
		char c;
		if (!fullCharQueue())
			enqueue('@');
		while ( (c = dequeue() ) != '@' )
		{
			cout << c;
			enqueue(c);
		}
	}

	// addFront() adds a charcter to the front of the queue

	void addFront(char x)
	{	
		char c;
		if(!fullCharQueue())
			enqueue('@');		     // enqueue an endmarker '@'
		else
		{
			cout << "\nFull Queue\n";
			exit(1);
		}
		if (!fullCharQueue())
			enqueue(x);				// enqueue a character for the front
		else 
		{
			cout << "\nFull Queue\n";
			exit(1);
		}
		c = dequeue();
		while( c != '@')            // stops when character is at front
		{
			enqueue(c);
			c=dequeue();
		}

	} // add Front

	// src() rotates the queue to the right. Rear is now front.

	void src()
	{
		char hold, c;
		bool finished=false;
		if(!fullCharQueue())
			enqueue('@');
		else
		{
			cout << "\nFull Queue\n";
			exit(1);
		}
		hold=dequeue();	 // hold character if not the last in queue 	
		if (hold != '@') // Not an empty queue
		{
			while(!finished)
			{
				c=dequeue();
				if ( c != '@')
				{
					enqueue(hold);
					hold=c;
				}
				else
					finished=true;
			} // while
			addFront(hold);
		}
	} // src()


}; // class CharQueue

class AlphabetField{

private:
	char letter;				// letter of alphabet
	int index;					// array index of letter

public:
	
	// Constructor

	AlphabetField()
	{
		letter = ' ';
		index  = 0;
		
	}

	// inputAlphabetField() prompts user for an alphabet

	void inputAlphabetField(int i)
	{
		cout << "Enter letter: ";
		cin >> letter;
		index = i;
	}


	char getLetter()
	{
		return letter;
	}

	int getIndex()
	{
		return index;
	}


}; // class AlphabetField

class Alphabet{

private:
	AlphabetField alphabet[MAX];
	int sizeOfAlphabet;

public:
	Alphabet()
	{
		sizeOfAlphabet=0;
	}

	void makeNullAlphabet()
	{
		sizeOfAlphabet=0;
	}

	int matchAlphabet(char c)
	{
		for( int i=0; i < sizeOfAlphabet; i++)
			if( alphabet[i].getLetter() == c )
				return alphabet[i].getIndex();
		return -1;
	}

	int getAlphabetSize()
	{
		return sizeOfAlphabet;
	}
	
	char getLetter(int i)
	{
		return alphabet[i].getLetter();
	}

	void inputAlphabet()
	{
		bool inputOkay = false;
		while ( !inputOkay )
		{
			cout << "\nEnter the size of the alphabet: ";
			cin >> sizeOfAlphabet;
			if (((sizeOfAlphabet >=0) && (sizeOfAlphabet <= MAX) ))
				inputOkay = true;
			else
				cout << "\nError: Alphabet size is out of bounds.\n";
		}

		for( int i = 0; i<sizeOfAlphabet; i++ )
			alphabet[i].inputAlphabetField(i);
			
	}

	void printAlphabet()
	{
		cout << "\nAlphabet:\n";
		for (int i = 0; i < sizeOfAlphabet; i++)
			cout << "Letter " << i+1 << ": " << alphabet[i].getLetter() << endl;
	}

}; // class Alphabet

class TransitionTableField
{

private:

	char stateType;
	char letter;
	int  nextState;
	int  readNextState[MAX];
	int  consultNextState[MAX];

public:

	// public
	TransitionTableField()
	{
		stateType = 'X';  //  X stands for REJECT state
		letter = '-';
		nextState = 0;
		
		for ( int i = 0; i < MAX; i++ )
			readNextState[i]=0;
		
		for ( i = 0; i < MAX; i++ )
			consultNextState[i]=0;
	}
	
	void initializeTransitionTableField()
	{
		stateType = 'X';  //  X stands for REJECT state
		letter = '-';
		nextState = 0;
		
		for ( int i = 0; i < MAX; i++ )
			readNextState[i]=0;
		
		for ( i = 0; i < MAX; i++ )
			consultNextState[i]=0;
	}

	//public
	void inputStartStateType()
	{
		stateType = 'I';				// Start State
	}

	// public
	void inputStateType()
	{	
		int menuNumber;
		bool inputOkay = false;
		while( !inputOkay )
		{
			displayStateTypeMenu();
			cin >> menuNumber;
			if ( ! ( inputOkay = isInBounds( menuNumber, 1, 6 ) ) )
				cout << "\nError: number entered is not a choice.\n";
		}

		switch(menuNumber)
		{
			case 1:		stateType = 'R'; // Read input tape (queue)
						break;
			case 2:		stateType = 'K'; // Consult front of store queue
						break;
			case 3:		stateType = 'W'; // Store to end of store queue
						break;
			case 4:		stateType = 'S'; // Shift queue to the right 
						break;
			case 5:		stateType = 'F'; // add to front of queue
						break;
			case 6:		stateType = 'A'; // accept state
						break;
			default:	stateType = '-'; // Not defined
						break;
		}

	}

	char getStateType()
	{
		return stateType;
	}

	void inputLetter(Alphabet a)
	{ 
		bool inputOkay = false;
		while ( !inputOkay )
		{
			cout << "Enter letter to add at end of queue: ";
			cin >> letter;
			if ( !(inputOkay=isInAlphabet(letter, a)))
				cout << "Error: Letter not in Alphabet.\n";
		}
	}

	char getLetter()
	{
		return letter;
	}


	void inputNextState(int tableSize)
	{
		bool inputOkay = false;
		while ( !inputOkay )
		{
			cout << "\nEnter the next state (integer) : ";
			cin >> nextState;
			if ( ! (inputOkay = isInBounds(nextState, 0, tableSize) ) )
				cout << "\nError: State out of bounds of table.\n";
		}

	}

	int getNextState()
	{
		return nextState;
	}

	void inputReadNextStates(Alphabet a, int tableSize)
	{
		bool inputOkay;
		cout << "\nEnter Next State (integer) :\n";
		for( int i = 0; i < a.getAlphabetSize(); i++)
		{	
			inputOkay = false;
			while ( !inputOkay )
			{
				cout << "     If " << a.getLetter(i) << ": ";
				cin >> readNextState[i];
				if ( ! ( inputOkay = isInBounds( readNextState[i], 0, tableSize ) ) )
					cout << "\nError: State out of bounds of table.\n";
			}
		}
		
		inputOkay = false;
		while ( !inputOkay )
		{

			cout << "  If NULL: ";
			cin >> readNextState[a.getAlphabetSize()];
			if ( ! ( inputOkay = isInBounds( readNextState[a.getAlphabetSize()], 0, tableSize ) ) )
				cout << "\nError: State out of bounds of table.\n";
		}
	}

	int getReadNextState(int i)
	{
		return readNextState[i];

	}

	void inputConsultNextStates(Alphabet a, int tableSize)
	{
		bool inputOkay;
		cout << "\nEnter Next State (integer) :\n";
		for( int i = 0; i < a.getAlphabetSize(); i++)
		{
			inputOkay = false;
			while ( !inputOkay )
			{
				cout << "     If " << a.getLetter(i) << ": ";
				cin >> consultNextState[i];
				if ( ! ( inputOkay = isInBounds( consultNextState[i], 0, tableSize ) ) )
					cout << "\nError: State out of bounds of table.\n";
			}

		}
	
		inputOkay = false;
		while ( !inputOkay )
		{
			cout << "  If NULL: ";
			cin >> consultNextState[a.getAlphabetSize()];
			if ( ! ( inputOkay = isInBounds( consultNextState[a.getAlphabetSize()], 0, tableSize ) ) )
				cout << "\nError: State out of bounds of table.\n";
		}

	}

	int getConsultNextState(int i)
	{
		return consultNextState[i];

	}

private:
	void displayStateTypeMenu()
	{
		cout << "\nState Type:\n"
			 << "1: Read Tape\n"
			 << "2: Consult Queue\n"
			 << "3: Store Queue\n"
			 << "4: Shift Right Cyclically (SRC)\n"
			 << "5: Add Front (AF)\n"
			 << "6: Accept State\n\n"
			 << "Enter a number: ";
	}

	bool isInBounds( int x, int y, int z )
	{
		if ( x >= y && x <= z )
			return true;
		else
			return false;
	}

	bool isInAlphabet( char x, Alphabet a)
	{
		for ( int i=0; i<a.getAlphabetSize(); i++)
			if ( x == a.getLetter(i) )
				return true;
		return false;
	}

}; // TransitionTableField

class TransitionTable
{
private:
	TransitionTableField transitionTable[100];
	int sizeOfTransitionTable;
public:
	TransitionTable()
	{
		sizeOfTransitionTable = 0;
	}

	int getSizeOfTransitionTable()
	{
		return sizeOfTransitionTable;
	}

	void makeNullTransitionTable()
	{
		sizeOfTransitionTable = 0;
		for ( int i = 0; i < 100; i++ )
			transitionTable[i].initializeTransitionTableField();
				
	}

	void inputTransitionTable(Alphabet a, Alphabet b)
	{	
		bool inputOkay = false;

		cout << "\nDefining Post Machine:\n\n";
		cout << "\nAll Reject States are defined as 0 (zero).\n\n";
		while ( !inputOkay )
		{
			cout << "Enter the number of states excluding rejected states: ";
			cin >> sizeOfTransitionTable;
			if ( !( inputOkay = isInBounds(sizeOfTransitionTable,0, 99)))
				cout << "\nError: size entered is out of bounds.\n";
		}
		cout << "\nState 1: START\n";
		transitionTable[1].inputStartStateType();
		transitionTable[1].inputNextState(sizeOfTransitionTable);
		
		for ( int i =2; i< sizeOfTransitionTable+1; i++)
		{
			cout << "\nState " << i << ":\n";
			transitionTable[i].inputStateType();
			switch(transitionTable[i].getStateType() )
			{
			case 'A':  // Accept State
				break;
			case 'R': // Read State
				transitionTable[i].inputReadNextStates(a, sizeOfTransitionTable);
				break;
			case 'K':  // Consult Queue
				transitionTable[i].inputConsultNextStates(b, sizeOfTransitionTable);
				break; 
			case 'W':  // Store Queue
				transitionTable[i].inputLetter(b);
				transitionTable[i].inputNextState(sizeOfTransitionTable);
				break; 
			case 'S': // Shift Right Cyclically
				transitionTable[i].inputNextState(sizeOfTransitionTable);
				break;
			case 'F': // Add Front of Queue
				transitionTable[i].inputLetter(b);
				transitionTable[i].inputNextState(sizeOfTransitionTable);
				break;
			default:
				break;
			}


			
		} // for i
	} // inputTransitionTable

	void printTransitionTable(Alphabet a, Alphabet b)
	{
		cout << "\nPrint Transition Table:\n\n";
		cout << "Number State Add Queue  Next ";
			 
		for (int j = 0; j < a.getAlphabetSize(); j++)
			cout << " If" << setw(2) << a.getLetter(j);
		cout << " If NULL ";
		
		if ( b.getAlphabetSize() == 0 )
			cout << endl;

		for ( j = 0; j < b.getAlphabetSize(); j++)
			cout << " If" << setw(2) << b.getLetter(j);
		
		if ( b.getAlphabetSize() != 0)
		   cout << " If NULL\n";

		for (int i = 0; i < sizeOfTransitionTable+1; i++ )
		{
				
			cout << setw(3) << i
				 << setw(8) << transitionTable[i].getStateType()
				 << setw(8) << transitionTable[i].getLetter()
				 << setw(8) << transitionTable[i].getNextState();
			
			for( j=0; j < a.getAlphabetSize()+1; j++)
				cout << setw(6) <<transitionTable[i].getReadNextState(j);
			
			if ( b.getAlphabetSize() != 0)
				for( j=0; j < b.getAlphabetSize()+1; j++)
					cout << setw(6) <<transitionTable[i].getConsultNextState(j);
			
			cout << endl;
			
		}
		
		displayLegendForStateType();
	}

	char getTransitionTableStateType(int i)
	{
		return transitionTable[i].getStateType();
	}

	char getTransitionTableLetter(int i)
	{
		return transitionTable[i].getLetter();
	}

	int getTransitionTableNextState(int i)
	{
		return transitionTable[i].getNextState();
	}

	int getTransitionTableReadNextState(int i, int j)
	{
		return transitionTable[i].getReadNextState(j);
	}

	int getTransitionTableConsultNextState(int i, int j)
	{
		return transitionTable[i].getConsultNextState(j);
	}

private:

	void displayLegendForStateType()
	{
		cout << "\n\nLegend for State Type:\n\n"
			 << "I = Start,    A = Accept,   X=Reject\n"
			 << "R = Read,     K = Consult,  W = Store,\n"
			 << "S=Shift Right Cyclically,   F = Add Front\n";
	}

	bool isInBounds( int x, int y, int z )
	{
		if ( x >= y && x <= z )
			return true;
		else
			return false;
	}

}; // class TransitionTable

class PostMachine
{

private:
	Alphabet a;
	Alphabet b;
	TransitionTable t;
	CharQueue store;
	CharQueue tape;
	char input[120];
	bool off;

public:
	
	PostMachine()
	{
		off = false;
	}

	void resetPostMachine()
	{
		off = false;
	}

	void runPM()
	{
		//char c;
		bool finalState=false;
		int iter;

		a.makeNullAlphabet();
		b.makeNullAlphabet();
		t.makeNullTransitionTable();
		
		cout << "\nEnter Tape Alphabet:\n";
		a.inputAlphabet(); 
		//a.printAlphabet();

		
		cout << "\nEnter Store Alphabet:\n";
		cout << "If all states are read only, then Store alphabet is not applicable, Enter 0.\n\n";

		b.inputAlphabet(); 

		//if ( b.getAlphabetSize() != 0 )
		//	b.printAlphabet();

		t.inputTransitionTable(a,b);
		t.printTransitionTable(a,b);

		int i;
		
		inputWord();
		
		while ( !off )
		{
			store.makenullCharQueue();
			tape.makenullCharQueue();

			finalState=false;
			i=1;
			iter = 0;
			while ( !finalState  && iter < 1000 )
			{
				switch(t.getTransitionTableStateType(i))
				{
					case 'I': // Start State
					
						i=start(i);
						break;

					case 'R': // Read tape (queue)
						i=readTape(i);
						break;

					case 'K': // Read or consult State (dequeue)
						
						i=consult(i);
						break;

					case 'W':  // Add state or write state (enqueue)
						
						i=storeX(i);
						break;
			
					case 'S': // read back of queue or shift right cycically
						
						i=shiftRightCyclically(i);
						break;
				
					case 'F': // Add Front State
					
						i=addFront(i);
						break;
				
					case 'A': // Accept State
				
						cout << "State = " << setw(2) << i << " ACCEPT\n";
						finalState=true;
						break;
					case 'X': // Reject State
						cout << "State = " << setw(2) << i << " REJECT\n";
						finalState=true;
						break;
					default:
						break;
				} // switch
			
				iter++;

				if (iter%20 == 0)
				{	
					cout << "\nPausing output. Hit any key. --> ";
					cin.get(); cin.get();
				}

			} // while ( !finalState )
			
			inputWord();
		
		} // while ( !off )
	
	} // class PostMachine		

private:

	void inputWord()
	{
		cout << "\nEnter word or 'N' for null string or '*' to turn off machine: ";
		cin >> input;
		if ( input[0] == '*' )
			off = true;
	}

	int start(int i)
	{
		
		if( input[0] != 'N' )
		{
			for ( int k=0; k < (int)strlen(input); k++)
				if( !tape.fullCharQueue())
					tape.enqueue(input[k]);
				else	
				{
					cout << "\nFull Queue\n";
					exit(1);
				}
			cout << "\nState = " << setw(2) << i <<" START      Tape = ";
				tape.printQueue(); cout <<  "    Store = NULL\n";
		}
		else
			cout << "\nState = " << setw(2) << i <<" START      Tape = NULL   Store = NULL\n"; 
		return t.getTransitionTableNextState(i);     
	}

	int readTape(int i)
	{
		char c;
		int j;
		if( !tape.emptyCharQueue())
		{
			c=tape.dequeue();
			j = a.matchAlphabet(c);
		}
		else 
			j=a.getAlphabetSize();
	
		if( !tape.emptyCharQueue())                
		{
			cout << "State = " << setw(2) << i << " READ       Tape = "; 
			tape.printQueue();
		}
		else
			cout << "State = " << setw(2) << i << " READ       Tape = NULL ";

		if ( !store.emptyCharQueue())
		{
			cout << "    Store = ";
			store.printQueue(); 
			cout << endl;
		}
		else
			cout << "    Store = NULL\n";

		return t.getTransitionTableReadNextState(i,j);

	} // int readTape(int i)

	int consult(int i)
	{	
		char c;
		int j;
		if (!store.emptyCharQueue())
		{
			c=store.dequeue();
			j=b.matchAlphabet(c);
		}
		else
			j=b.getAlphabetSize();
				
		if( !tape.emptyCharQueue())
		{
			cout << "State = " << setw(2) << i << " CONSULT    Tape = "; 
			tape.printQueue();
		}
		else
			cout << "State = " << setw(2) << i << " CONSULT    Tape = NULL ";

		if ( !store.emptyCharQueue())
		{
			cout << "    Store = ";
			store.printQueue(); 
			cout << endl;
		}
		else
			cout << "    Store = NULL\n";

		return t.getTransitionTableConsultNextState(i,j);
	}

	int storeX(int i)
	{
		if (!store.fullCharQueue())
		{
			store.enqueue(t.getTransitionTableLetter(i));
			if ( !tape.emptyCharQueue() )
			{
				cout << "State = " << setw(2) << i << " STORE      Tape = ";
				tape.printQueue(); 
				cout << "    Store = "; 
				store.printQueue();
				cout << endl;
			}
			else
			{
				cout << "State = " << setw(2) << i << " STORE      Tape = NULL ";
				cout << "    Store = ";
				store.printQueue();
				cout << endl;
			}

			return t.getTransitionTableNextState(i);
		}
		else
		{
			cout << "\nFull Queue\n";
			exit(1);
		}
	}

	int shiftRightCyclically(int i)
	{
		if ( !store.emptyCharQueue() )
			store.src();

		if( !tape.emptyCharQueue())				   
		{
			cout << "State = " << setw(2) << i <<" SRC         Tape = "; 
			tape.printQueue();
		}
		else
			cout << "State = " << setw(2) << i << " SRC        Tape = NULL ";

		if ( !store.emptyCharQueue())
		{
			cout << "    Store = ";
			store.printQueue(); 
			cout << endl;
		}
		else
			cout << "    Store = NULL\n";

		
		return t.getTransitionTableNextState(i);
	}

	int addFront(int i)
	{
		store.addFront(t.getTransitionTableLetter(i));
		cout << "State = " << setw(2) << i << " AF         Store = ";
			store.printQueue(); cout << endl;
		return t.getTransitionTableNextState(i);
	}

}; // class PostMachine

void main()
{
	
	PostMachine pm;
	int i=1;
	while ( i != 2 )
	{
		cout << "\nMenu:\n\n"
			<<  "1: Run Post Machine\n"
			<<  "2: Quit\n\n"
			<<  "Enter: ";
		cin >> i;
		switch(i)
		{
			case 1: 
					pm.resetPostMachine();
					pm.runPM();
					break;
			default:
					i=2;
					break;
		}
	}

	cout << "Test to see if this program executes\n";
	cin.get();

}

