#include <iostream.h>
#include <stdlib.h>

class Cola{
      public:
      // los elementos de la cola son de tipo entero
      typedef int Item;
      // constructor de la clase. Inicializa una cola
      // y la deja sin elementos
      Cola();
      // destructor de la clase. Libera los recursos
      // ocupados cuando acaba el ambito del objeto
      ~Cola();
      // agrega el elemento x como ultimo elemento de
      // la cola
      void meter(Item x);
      // devuelve el primer elemento de la cola.
      // si esta vacia, eleva la excepcion ColaVacia
      Item frente () const;
      // elimina el primer elemento de la cola
      void sacar();
      // devuelve verdadero si no hay elementos en
      // la cola, falso en caso contrario
      bool esVacia() const;
      // excepciones que se elevan en caso de error
      enum ErrorCola{ColaVacia};
      private:
      // tipos privados
      struct Nodo{
             Item dato;
             Nodo * siguiente;
      };
             // atributos
             Nodo * ultimo;
             // metodos privados
             void borrarCircular();
};
             Cola::Cola(){
                  ultimo = NULL;
             }
             Cola::~Cola(){
                 borrarCircular();
             }
             void Cola::borrarCircular(){
                 Nodo * auxiliar = NULL;
                 if (ultimo != NULL) {
                     auxiliar = ultimo->siguiente;
                     ultimo->siguiente = NULL;    
                 }
                 while (auxiliar != NULL){
                     ultimo = auxiliar->siguiente;
                     delete auxiliar;
                     auxiliar = ultimo;
                 }
             }
              void Cola::meter(Item x){
                 Nodo * nuevo = new Nodo;
                 nuevo->dato = x;
                 if (ultimo != NULL){
                     nuevo->siguiente = ultimo->siguiente;
                     ultimo->siguiente = nuevo;
                 }else
                     nuevo->siguiente = nuevo;
                 ultimo = nuevo;
             }
             Cola::Item Cola::frente() const {
                 if (ultimo == NULL) throw ColaVacia;
                 return ultimo->siguiente->dato;
             }
             void Cola::sacar(){
                 if (ultimo != NULL){
                     Nodo * auxiliar = ultimo->siguiente;
                     if (ultimo->siguiente == ultimo)
                         ultimo = NULL;
                     else
                         ultimo->siguiente = ultimo->siguiente->siguiente;
                     delete auxiliar;
                 }
             }
             bool Cola::esVacia() const {
                 return (ultimo == NULL);
             }




void main(){
int i;
     Cola a,b;
     try{
         cout << a.frente();
     } catch (Cola::ErrorCola s){
       cout << s;
     };
    for(i=0;i<10;i++){
        a.meter(rand()%100);
        cout << "a: " << a.frente() << endl;
    }
    b=a;
    for(i=0;i<5;i++, a.sacar());     
    cout << "a: " << a.frente() << endl; 
    cout << "Vacia?: " << a.esVacia() << endl; 
    for(i=0;i<4;i++, a.sacar());     
    cout << "a: " << a.frente() << endl;
    for(i=0;i<1;i++, a.sacar());
    cout << "Vacia?: " << a.esVacia() << endl;      
    system("Pause");
}

