#ifndef _Cola_hpp
#define _Cola_hpp

class Cola{
      public:
      // los elementos de la cola son de tipo entero
      typedef int Item;
      // constructor de la clase. Inicializa una cola
      // y la deja sin elementos
      Cola();
      // destructor de la clase. Libera los recursos
      // ocupados cuando acaba el ambito del objeto
      ~Cola();
      // agrega el elemento x como ultimo elemento de
      // la cola
      void meter(Item x);
      // devuelve el primer elemento de la cola.
      // si esta vacia, eleva la excepcion ColaVacia
      Item frente () const;
      // elimina el primer elemento de la cola
      void sacar();
      // devuelve verdadero si no hay elementos en
      // la cola, falso en caso contrario
      bool esVacia() const;
      // excepciones que se elevan en caso de error
      enum ErrorCola{ColaVacia};
      private:
      // tipos privados
      struct Nodo{
             Item dato;
             Nodo * siguiente;
      };
             // atributos
             Nodo * ultimo;
             // metodos privados
             void borrarCircular();
};

#include "Cola.cpp"
#endif
