% ---------------- PORTABILITY PREDICATES --------------

% Prolog: BinProlog 5.75
% OS: Windows 95/NT

% --------------- term manipulation -------------

% readTerm(Term,Vars,Sings)
% reads the term 'Term', returning its variables 'Vars'
% and singletons 'Sings'

readTerm(G,V,S) :- read_with_singletons(G,V1,S),
                   formatVars(V1,V).

% formatVars(VarsBP,VarsISO)
% relates BinProlog ([var(Name,Var,_)]) and ISO ([(Name=Var)])
% variable formats

formatVars([var(A,V,_)|V1s],[A=V|Vs]) :- formatVars(V1s,Vs).
formatVars([],[]).

% --------------- list predicates ----------------

select(X,[X|Ys],Ys).
select(X,[Y|Ys],[Y|Zs]) :- select(X,Ys,Zs).

last([X],X).
last([_|Xs],X) :- last(Xs,X).

delete([],_,[]).
delete([D|Xs],D,Ys) :- !, delete(Xs,D,Ys).
delete([X|Xs],D,[X|Ys]) :- delete(Xs,D,Ys).

% --------------- operating system access -------------

showDir :- dir.

fileExists(F) :- exists_file(F).
