% ---------------- PORTABILITY PREDICATES --------------

% Prolog: SICStus 3 #5
% OS: Unix

:- op(700, yfx, (\=)).
A \= B :- \+(A = B).

% --------------- term manipulation -------------

% readTerm(Term,Vars,Sings)
% reads the term 'Term', returning its variables 'Vars'
% and singletons 'Sings'

readTerm(G,V,S) :- read_term(G,[variable_names(V),
                                singletons(S1),
                                syntax_errors(dec10)]),
                   formatSingletons(S1,S).

% formatSingletons(SingISO,SingBP)
% relates ISO ([(Name=Var)]) and BinProlog ([Name]) singleton
% format

formatSingletons([N=_|S1s],[N|Ss]) :- formatSingletons(S1s,Ss).
formatSingletons([],[]).

% --------------- list predicates ----------------

:- use_module(library(lists)).

% --------------- operating system access -------------

:- use_module(library(system)).

showDir :- system(ls).

fileExists(F) :- file_exists(F).
