/*
 * Decompiled with CFR 0.152.
 */
package ClientFerature;

import ClientFerature.Configuration;
import ClientFerature.Mediator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class CfgWindow
extends JDialog
implements ActionListener {
    private JTextField port;
    private JTextField server;
    JTable tableV;
    private int Port = 8000;
    private String Server = "127.0.0.1";
    private Configuration _cfg;
    Mediator md;

    public CfgWindow(JFrame frame, Configuration cfg) {
        super(frame, "Configuration Values", true);
        this.setLocation(10, 20);
        this.setLayout(null);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(350, 190));
        this._cfg = cfg;
        this.Server = this._cfg.getServer();
        this.Port = this._cfg.getPort();
        JPanel serverGeoPane = new JPanel(null);
        JLabel serverGeoL = new JLabel("Server: ");
        serverGeoL.setForeground(Color.GRAY);
        this.server = new JTextField();
        this.server.setText(this.Server);
        serverGeoL.setBounds(10, 10, 180, 40);
        this.server.setBounds(140, 20, 150, 20);
        serverGeoPane.add(serverGeoL);
        serverGeoPane.add(this.server);
        JLabel serverGeoPL = new JLabel("Server Port: ");
        serverGeoPL.setForeground(Color.GRAY);
        this.port = new JTextField();
        this.port.setText("" + this.Port);
        serverGeoPL.setBounds(10, 40, 180, 40);
        this.port.setBounds(140, 50, 150, 20);
        serverGeoPane.add(serverGeoPL);
        serverGeoPane.add(this.port);
        serverGeoPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Feature Gateway"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add(serverGeoPane);
        serverGeoPane.setBounds(20, 15, 300, 100);
        JButton SaveButton = new JButton("Save");
        SaveButton.setBounds(120, 120, 100, 25);
        SaveButton.addActionListener(this);
        this.add(SaveButton);
        this.pack();
    }

    public void showWindow() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Save")) {
            this.Save();
        }
    }

    private void Save() {
        if (this.port.getText().length() == 0) {
            this.Error("     Port field empty.");
            return;
        }
        try {
            this.Port = Integer.parseInt(this.port.getText().trim());
        }
        catch (NumberFormatException nfe) {
            this.Error("Port field must be a number.");
            return;
        }
        if (this.server.getText().length() == 0) {
            this.Error("     GeoServer field empty.");
            return;
        }
        this.Server = this.server.getText().trim();
        this._cfg = new Configuration(this.Server, this.Port);
        this.dispose();
    }

    private void Error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Configuration Error", 0);
    }

    public Configuration getConfiguracion() {
        return this._cfg;
    }
}

