/*
 * Decompiled with CFR 0.152.
 */
package ClientFerature;

import ClientFerature.NetworkManager;
import Packet.Packet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client {
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;
    Socket socket = null;
    String ip;
    int port;
    NetworkManager network;
    boolean online;
    Connect recieveThread;

    public Client(String ipP, int portP, NetworkManager networkp) {
        this.ip = ipP;
        this.port = portP;
        this.network = networkp;
    }

    public void Connect() throws UnknownHostException, IOException {
        this.socket = new Socket(this.ip, this.port);
        this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        this.ois = new ObjectInputStream(this.socket.getInputStream());
        this.online = true;
        this.recieveThread = new Connect(this.ois, this.network);
        this.recieveThread.start();
    }

    public void Disconnect() throws IOException {
        this.recieveThread.Disconnect();
        this.close();
        this.socket.close();
    }

    public void send(Packet packet) throws IOException {
        this.oos.writeObject(packet);
    }

    public void close() throws IOException {
        this.oos.close();
        this.ois.close();
    }

    class Connect
    extends Thread {
        private ObjectInputStream ois = null;
        NetworkManager network;

        public Connect(ObjectInputStream oisP, NetworkManager networkP) {
            this.network = networkP;
            this.ois = oisP;
        }

        public void Disconnect() {
            Client.this.online = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (Client.this.online) {
                try {
                    Object packet = this.ois.readObject();
                    this.network.packetReceived(packet);
                }
                catch (IOException ex) {
                    if (!Client.this.online) break;
                    this.network.networkErrorComunication();
                    break;
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
            }
        }
    }
}

