/*
 * Decompiled with CFR 0.152.
 */
package ClientFerature;

import Buttons.CfgButton;
import Buttons.Command;
import Buttons.ConnectButton;
import Buttons.DisConnectButton;
import Buttons.GeneticButton;
import Buttons.UFLPButton;
import Buttons.UserLabel;
import Buttons.infoLog;
import ClientFerature.Configuration;
import ClientFerature.LayerTable;
import ClientFerature.MapFrame;
import ClientFerature.Mediator;
import ClientFerature.NetworkManager;
import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import eu.hansolo.custom.SteelCheckBox;
import eu.hansolo.tools.ColorDef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClientWindow
implements ActionListener {
    private JFrame content_pane = new JFrame("Features Client");
    public LayerTable table;
    public int STATUS_AUCTION = -1;
    public Configuration cfg;
    private int x = 800;
    private int y = 650;

    public ClientWindow(Configuration Cfg) {
        this.content_pane.setLocation(0, 0);
        this.content_pane.setLayout(null);
        this.content_pane.setResizable(false);
        this.content_pane.setPreferredSize(new Dimension(this.x, this.y));
        this.cfg = Cfg;
        final Mediator med = new Mediator(this.cfg);
        ConnectButton connectButton = new ConnectButton(med, this);
        DisConnectButton disconnectButton = new DisConnectButton(med, this);
        UFLPButton uflpButton = new UFLPButton(med, this);
        GeneticButton geneticButton = new GeneticButton(med, this);
        CfgButton cfgButton = new CfgButton(med, this);
        infoLog infolog = new infoLog(med);
        UserLabel User = new UserLabel(med);
        NetworkManager network = new NetworkManager(this.cfg.getServer(), this.cfg.getPort(), med);
        this.loadIcon();
        med.init(this.content_pane);
        this.table = new LayerTable(med);
        JScrollPane scrollPane = new JScrollPane(this.table);
        JLabel UserS = new JLabel("USER:");
        UserS.setFont(new Font("ARIAL", 1, 18));
        UserS.setForeground(Color.WHITE);
        MapFrame map = new MapFrame(med);
        map.getMap();
        this.content_pane.add((Component)map.getMap());
        map.getMap().setBounds(170, 220, 600, 270);
        JLabel FeatureL = new JLabel("Features Status");
        this.content_pane.add(FeatureL);
        FeatureL.setFont(new Font("Tahoma", 1, 14));
        FeatureL.setForeground(Color.GRAY);
        SteelCheckBox del = new SteelCheckBox();
        del.setText("Add Mode");
        del.setColored(true);
        del.setRised(true);
        del.setSelectedColor(ColorDef.RED);
        this.content_pane.add((Component)del);
        med.registerDel(del);
        ChangeListener chListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                med.delCheck();
            }
        };
        del.addChangeListener(chListener);
        JLabel LogInfoL = new JLabel("LOG INFO");
        LogInfoL.setFont(new Font("Tahoma", 1, 14));
        LogInfoL.setForeground(Color.GRAY);
        this.content_pane.add(LogInfoL);
        JScrollPane scrollPaneLog = new JScrollPane(infolog);
        this.content_pane.add(scrollPaneLog);
        this.content_pane.add(UserS);
        this.content_pane.add(User);
        this.content_pane.add(connectButton);
        this.content_pane.add(disconnectButton);
        this.content_pane.add(uflpButton);
        this.content_pane.add(geneticButton);
        this.content_pane.add(cfgButton);
        this.content_pane.add(scrollPane);
        UserS.setBounds(25, 20, 120, 20);
        User.setBounds(90, 25, 200, 13);
        JSeparator separator2 = new JSeparator();
        JSeparator separator1 = new JSeparator();
        this.content_pane.add(separator1);
        this.content_pane.add(separator2);
        separator1.setBounds(15, 60, 135, 15);
        separator2.setBounds(15, 205, 135, 15);
        cfgButton.setBounds(20, 85, 122, 30);
        connectButton.setBounds(20, 125, 122, 30);
        disconnectButton.setBounds(20, 165, 122, 30);
        JSeparator separator4 = new JSeparator();
        JSeparator separator3 = new JSeparator();
        this.content_pane.add(separator3);
        this.content_pane.add(separator4);
        separator3.setBounds(15, 350, 135, 15);
        separator4.setBounds(15, 445, 135, 15);
        geneticButton.setBounds(20, 370, 122, 30);
        uflpButton.setBounds(20, 405, 122, 30);
        disconnectButton.setEnabled(false);
        scrollPane.setBounds(170, 65, 600, 150);
        FeatureL.setBounds(25, 215, 122, 26);
        del.setBounds(35, 255, 122, 26);
        LogInfoL.setBounds(25, 450, 100, 80);
        scrollPaneLog.setBounds(25, 500, 745, 80);
        uflpButton.setEnabled(false);
        this.content_pane.setDefaultCloseOperation(3);
        this.content_pane.pack();
        this.content_pane.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command cmd = (Command)e.getSource();
        cmd.Execute();
    }

    public void loadIcon() {
        String OS = System.getProperty("os.name");
        URL url = ClassLoader.getSystemResource("ClientIcon.jpeg");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.createImage(url);
        if (OS.startsWith("Mac")) {
            Application application = Application.getApplication();
            application.setDockIconImage(img);
            application.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent arg0) {
                    JOptionPane.showMessageDialog(ClientWindow.this.content_pane, "Client Features Gateway \nCreated at University of Malaga.");
                }
            });
        } else {
            this.content_pane.setIconImage(img);
        }
    }

    public static void main(String[] args) {
        Configuration cfg = new Configuration("127.0.0.1", 8000);
        ClientWindow cliente = new ClientWindow(cfg);
    }
}

