/*
 * Decompiled with CFR 0.152.
 */
package ClientFerature;

import ClientFerature.ColoredTableCellRenderer;
import ClientFerature.LayerData;
import ClientFerature.LayerDataTable;
import ClientFerature.Mediator;
import MapFrame.Feature;
import MapFrame.Layer;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class LayerTable
extends JTable {
    protected LayerDataTable m_data;
    int columnLayer = 0;
    int columnType = 1;
    int columnElements = 2;
    Mediator med;
    boolean outputReady = false;
    boolean disconnected = false;

    public LayerTable(Mediator md) {
        this.med = md;
        this.m_data = new LayerDataTable();
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(this.m_data);
        int k = 0;
        while (k < LayerDataTable.m_columns.length) {
            ColoredTableCellRenderer renderer = new ColoredTableCellRenderer();
            renderer.setHorizontalAlignment(LayerDataTable.m_columns[k].m_alignment);
            TableColumn column = new TableColumn(k, LayerDataTable.m_columns[k].m_width, renderer, null);
            this.addColumn(column);
            ++k;
        }
        JTableHeader header = this.getTableHeader();
        header.setUpdateTableInRealTime(false);
        this.setShowVerticalLines(false);
        this.setRowSelectionAllowed(true);
        this.setPreferredScrollableViewportSize(new Dimension(700, 370));
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LayerTable.this.med.tableSelected();
            }
        });
        this.med.registerBB(this);
    }

    public String[] getLayers() {
        int nLayers = this.m_data.m_vector.size();
        String[] ret = new String[nLayers];
        int i = 0;
        while (i < nLayers) {
            LayerData aux = (LayerData)this.m_data.m_vector.get(i);
            ret[i] = aux.m_layer;
            ++i;
        }
        return ret;
    }

    public List<Layer> getPointLayers() {
        int nLayers = this.m_data.m_vector.size();
        ArrayList<Layer> ret = new ArrayList<Layer>();
        int i = 0;
        while (i < nLayers) {
            LayerData aux = (LayerData)this.m_data.m_vector.get(i);
            if (aux.m_typelayer == Feature.type.Point) {
                ret.add(new Layer(aux.m_layer, aux.m_typelayer, aux.m_numElements));
            }
            ++i;
        }
        return ret;
    }

    public void loadNewData(String layer) {
        this.m_data.addElement(layer);
        this.addNotify();
        this.repaint();
    }

    public void loadNewData(String layer, Feature.type type2) {
        this.m_data.addElement(layer, type2);
        this.addNotify();
        this.repaint();
    }

    public void loadNewData(List<Layer> layers) {
        for (Layer layer : layers) {
            this.m_data.addElement(layer.getName(), layer.getTipo(), layer.getNelements());
        }
        this.addNotify();
        this.repaint();
    }

    public void loadNewData(String layer, Feature.type type2, int numElement) {
        this.m_data.addElement(layer, type2, numElement);
        this.addNotify();
        this.repaint();
    }

    public void updateFeatures(String layer, boolean add) {
        this.m_data.updateLayer(layer, add);
        this.addNotify();
        this.repaint();
    }

    public void clean() {
        this.m_data.clear();
        this.addNotify();
        this.repaint();
    }

    public void deleteSelected() {
        int index = this.getSelectedRow();
        if (index >= 0 & this.isRowSelected(index)) {
            this.m_data.deleteElement(index);
            this.addNotify();
            this.repaint();
        }
    }

    public boolean isAnyLayerSelected() {
        int index = this.getSelectedRow();
        return index >= 0 & this.isRowSelected(index);
    }

    public Feature.type getTypeSelected() {
        int index = this.getSelectedRow();
        if (index >= 0 & this.isRowSelected(index)) {
            return this.m_data.getType(index);
        }
        return null;
    }

    public int getTypeIntSelected() {
        int index = this.getSelectedRow();
        if (index >= 0 & this.isRowSelected(index)) {
            return this.m_data.getTypeInt(index);
        }
        return -1;
    }

    public String getLayerSelected() {
        int index = this.getSelectedRow();
        if (index >= 0 & this.isRowSelected(index)) {
            return this.m_data.getLayerName(index);
        }
        return null;
    }

    public int getNumElement() {
        return this.m_data.getRowCount();
    }
}

