/*
 * Decompiled with CFR 0.152.
 */
package ClientFerature;

import Buttons.CfgButton;
import Buttons.ConnectButton;
import Buttons.DisConnectButton;
import Buttons.UFLPButton;
import Buttons.UserLabel;
import Buttons.infoLog;
import ClientFerature.CfgWindow;
import ClientFerature.Configuration;
import ClientFerature.LayerTable;
import ClientFerature.Login;
import ClientFerature.MapFrame;
import ClientFerature.NetworkManager;
import ClientFerature.UserManager;
import MapFrame.Feature;
import MapFrame.Layer;
import MapFrame.Poly;
import MapFrame.Punto;
import Packet.PacketModifLayerDataB;
import UFLP.GeneticWindow;
import UFLP.UFLPWindow;
import eu.hansolo.custom.SteelCheckBox;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class Mediator {
    private ConnectButton connect;
    private DisConnectButton disconnect;
    private UFLPButton uflp;
    private CfgButton cfgbutton;
    private infoLog infolog;
    private UserLabel userInfo;
    private Container contPane;
    private NetworkManager network;
    private Configuration cfg;
    private UserManager useerManager;
    MapFrame map;
    private String loginTmp;
    UFLPWindow uflpWindow;
    private LayerTable LayersTable;
    SteelCheckBox del;
    boolean UFLP_mode = false;

    Mediator(Configuration Cfg) {
        this.cfg = Cfg;
        this.useerManager = new UserManager(this);
    }

    public void init(Container contPANEL) {
        this.contPane = contPANEL;
        this.connect.setEnabled(true);
        this.AddLog("Client configuration::> Server ip: " + this.cfg.getServer() + " Server port: " + this.cfg.getPort());
    }

    public void registerComm(NetworkManager networkP) {
        this.network = networkP;
    }

    public void register(JButton button) {
        if (button instanceof UFLPButton) {
            this.uflp = (UFLPButton)button;
        } else if (button instanceof ConnectButton) {
            this.connect = (ConnectButton)button;
        } else if (button instanceof DisConnectButton) {
            this.disconnect = (DisConnectButton)button;
        } else if (button instanceof CfgButton) {
            this.cfgbutton = (CfgButton)button;
        }
    }

    public void registerInfoLog(infoLog infoLOG) {
        this.infolog = infoLOG;
    }

    public void registerUserInfo(UserLabel label) {
        this.userInfo = label;
    }

    public void registerBB(LayerTable layerTable) {
        this.LayersTable = layerTable;
    }

    public void UFLP() {
        this.UFLP_mode = true;
        List<Layer> layers = this.LayersTable.getPointLayers();
        if (layers.size() < 2) {
            this.warningError("Two point layers is needed", "ULP");
        } else {
            JFrame uflpFrame = new JFrame();
            this.uflpWindow = new UFLPWindow(uflpFrame, this.network, layers);
            this.uflpWindow.requestLayerPoints();
            this.uflpWindow.showWindow();
            this.UFLP_mode = false;
        }
    }

    public void Connect() {
        this.cfgbutton.setEnabled(false);
        this.connect.setEnabled(false);
        Login login = this.useerManager.LoginManagement();
        if (login.cancelClick()) {
            this.cfgbutton.setEnabled(true);
            this.connect.setEnabled(true);
            this.disconnect.setEnabled(false);
            this.uflp.setEnabled(false);
        } else if (this.network.Connect()) {
            this.loginTmp = login.getUserName();
            String pwdS = login.getPassword();
            this.network.sendAuthentication(this.loginTmp, pwdS);
        } else {
            this.cfgbutton.setEnabled(true);
            this.connect.setEnabled(true);
            this.disconnect.setEnabled(false);
            this.uflp.setEnabled(false);
        }
    }

    public void DisConnect() {
        this.cfgbutton.setEnabled(true);
        this.connect.setEnabled(true);
        this.disconnect.setEnabled(false);
        this.uflp.setEnabled(false);
        this.LayersTable.clean();
        this.userInfo.setDisconnected();
        this.AddLog("Client " + this.loginTmp + " Desconected.");
        this.network.DisConnect();
        this.map.clear();
        this.LayersTable.clearSelection();
    }

    public void authIncorrect(boolean badPwd) {
        if (badPwd) {
            this.warningError("Client " + this.loginTmp + " NOT authenticated, WRONG password.", "Authentication");
            this.AddLog("C > Client " + this.loginTmp + " NOT authenticated, WRONG password.");
        } else {
            this.warningError("Client " + this.loginTmp + " NOT authenticated, user ONLINE yet.", "Authentication");
            this.AddLog("Client " + this.loginTmp + " NOT authenticated, user ONLINE yet.");
        }
        this.cfgbutton.setEnabled(true);
        this.connect.setEnabled(true);
        this.disconnect.setEnabled(false);
        this.uflp.setEnabled(false);
    }

    public void authValid(List<Layer> layers) {
        try {
            this.connect.setEnabled(false);
            this.userInfo.setId(this.loginTmp);
            this.AddLog("Client " + this.loginTmp + " Authenticated.");
            this.LayersTable.loadNewData(layers);
            this.disconnect.setEnabled(true);
            this.uflp.setEnabled(true);
        }
        catch (Exception ex) {
            Logger.getLogger(Mediator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void layerDataModif(PacketModifLayerDataB packet) {
        if (this.del.isSelected()) {
            this.map.setModeDel();
        } else {
            this.map.setModeAdd();
        }
        boolean isAdd = packet.isADD();
        String layerName = packet.getLayerName();
        this.LayersTable.updateFeatures(layerName, isAdd);
        int tipo = packet.getTypeIntLayer();
        this.network.sendLayer(layerName, tipo);
    }

    public void connexionReset(String User) {
    }

    public void tableSelected() {
        if (this.del.isSelected()) {
            this.map.setModeDel();
        } else {
            this.map.setModeAdd();
        }
        String layerName = this.LayersTable.getLayerSelected();
        Feature.type tipoFeature = this.LayersTable.getTypeSelected();
        this.map.setLayerAndType(layerName, tipoFeature);
        int tipo = this.LayersTable.getTypeIntSelected();
        this.network.sendLayer(layerName, tipo);
    }

    public void ptosReceive(String nameLayer, List<Punto> ptos) {
        if (!this.UFLP_mode) {
            this.map.displayWaypoint(ptos);
        } else {
            this.uflpWindow.receiveDatos(nameLayer, ptos);
        }
    }

    public void lynesReceive(List<Poly> lynes) {
        if (this.del.isSelected()) {
            this.map.displayLine(lynes, true);
        } else {
            this.map.displayLine(lynes, false);
        }
    }

    public void registerMap(MapFrame mapP) {
        this.map = mapP;
    }

    public void registerDel(SteelCheckBox delP) {
        this.del = delP;
    }

    public void delCheck() {
        if (this.del.isSelected()) {
            this.del.setText("Del Mode");
        } else {
            this.del.setText("Add Mode");
        }
        Feature.type tipoFeature = this.LayersTable.getTypeSelected();
        if (tipoFeature != Feature.type.Point) {
            this.tableSelected();
        } else if (this.del.isSelected()) {
            this.map.setModeDel();
        } else {
            this.map.setModeAdd();
        }
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public void AddLog(String txt) {
        this.infolog.addLog(txt);
    }

    public void severeError(String msg, String info) {
        JOptionPane.showMessageDialog(this.contPane, msg, info, 0);
        this.panicMode();
    }

    public void warningError(String msg, String info) {
        JOptionPane.showMessageDialog(this.contPane, msg, info, 0);
    }

    public void panicMode() {
        this.userInfo.setDisconnected();
        this.connect.setEnabled(false);
        this.disconnect.setEnabled(false);
    }

    public void addWayPoint(String layerName, GeoPosition ptoAdd) {
        this.LayersTable.updateFeatures(layerName, true);
        this.network.sendDataLayer(layerName, new Punto(ptoAdd.getLatitude(), ptoAdd.getLongitude()), true);
    }

    public void delWayPoint(String layerName, GeoPosition ptoAdd) {
        if (ptoAdd != null) {
            this.LayersTable.updateFeatures(layerName, false);
            this.network.sendDataLayer(layerName, new Punto(ptoAdd.getLatitude(), ptoAdd.getLongitude()), false);
        }
    }

    public void addLynePoint(String layerName, int tipo, List<GeoPosition> listaLineWay) {
        this.LayersTable.updateFeatures(layerName, true);
        Poly poly = new Poly(666L, listaLineWay.size());
        poly.setPtos(this.aux(listaLineWay));
        this.network.sendDataLayer(layerName, tipo, poly, true);
    }

    public void delLynePoint(String layerName, Poly ptos) {
        int tipo = this.LayersTable.getTypeIntSelected();
        if (ptos != null) {
            this.LayersTable.updateFeatures(layerName, false);
            this.network.sendDataLayer(layerName, tipo, ptos, false);
        }
    }

    public List<Punto> aux(List<GeoPosition> pointD) {
        ArrayList<Punto> point = new ArrayList<Punto>();
        for (GeoPosition pos : pointD) {
            point.add(new Punto(pos.getLatitude(), pos.getLongitude()));
        }
        return point;
    }

    public void Genetic() {
        JFrame geneticFrame = new JFrame();
        GeneticWindow geneticWindow = new GeneticWindow(geneticFrame);
        geneticWindow.showWindow();
    }

    public void Configuration() {
        JFrame cfgFrame = new JFrame();
        CfgWindow cfgWindow = new CfgWindow(cfgFrame, this.cfg);
        cfgWindow.showWindow();
        this.cfg = cfgWindow.getConfiguracion();
        this.AddLog(this.cfg.toString());
    }
}

