/*
 * Decompiled with CFR 0.152.
 */
package ClientFerature;

import ClientFerature.Client;
import ClientFerature.Mediator;
import MapFrame.Poly;
import MapFrame.Punto;
import Packet.Packet;
import Packet.PacketAuthR;
import Packet.PacketAuthS;
import Packet.PacketCNRst;
import Packet.PacketException;
import Packet.PacketLayerDataR;
import Packet.PacketLayerDataS;
import Packet.PacketModifLayerDataB;
import Packet.PacketModifLayerDataS;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkManager {
    String ip;
    int port;
    Mediator md;
    Client protocol;

    public NetworkManager(String ipP, int portP, Mediator med) {
        this.ip = ipP;
        this.port = portP;
        this.md = med;
        this.md.registerComm(this);
        this.protocol = new Client(this.ip, this.port, this);
    }

    public boolean Connect() {
        try {
            this.protocol.Connect();
        }
        catch (Exception e) {
            this.networkErrorComunication();
            return false;
        }
        return true;
    }

    public void DisConnect() {
        try {
            this.protocol.Disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAuthentication(String id, String pwd) {
        try {
            PacketAuthS packet = new PacketAuthS(id, pwd);
            this.protocol.send(packet);
        }
        catch (IOException ex) {
            this.networkErrorComunication();
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendLayer(String layername, int tipo) {
        try {
            PacketLayerDataS packet = new PacketLayerDataS(layername, tipo);
            this.protocol.send(packet);
            System.out.println("CLIENTE ENVIANDO --> " + packet);
        }
        catch (IOException ex) {
            this.networkErrorComunication();
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendDataLayer(String layername, int tipo, Poly ptos, boolean add) {
        try {
            PacketModifLayerDataS packet = new PacketModifLayerDataS(layername, tipo, ptos, add);
            this.protocol.send(packet);
            System.out.println("CLIENTE ENVIANDO --> " + packet);
        }
        catch (IOException ex) {
            this.networkErrorComunication();
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendDataLayer(String layername, Punto pto, boolean add) {
        try {
            PacketModifLayerDataS packet = new PacketModifLayerDataS(layername, pto, add);
            this.protocol.send(packet);
            System.out.println("CLIENTE ENVIANDO --> " + packet);
        }
        catch (IOException ex) {
            this.networkErrorComunication();
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void networkErrorComunication() {
        String msg = "Feature Server " + this.ip + ":" + this.port + " Not Reachable";
        String type2 = "Error Feature Connection.";
        this.md.severeError(msg, type2);
    }

    public void Auth(Packet packetAut) {
        PacketAuthR auth = (PacketAuthR)packetAut;
        if (auth.isPositive()) {
            this.md.authValid(auth.getLayers());
        } else {
            this.md.authIncorrect(auth.isBadPwd());
        }
    }

    public void Layer(Packet packetLayer) {
        PacketLayerDataR layer = (PacketLayerDataR)packetLayer;
        if (layer.tipoL == 0) {
            this.md.ptosReceive(layer.getLayerName(), layer.getPtos());
        } else {
            this.md.lynesReceive(layer.getLynes());
        }
        System.out.println("RECIVE LAYER: " + layer);
    }

    public void ConnexionReset(Packet packetCNReset) {
        PacketCNRst pWPRes = (PacketCNRst)packetCNReset;
        this.md.connexionReset(pWPRes.ID);
    }

    public void ReceiveData(Packet packetLayerData) {
        PacketModifLayerDataB pData = (PacketModifLayerDataB)packetLayerData;
        this.md.layerDataModif(pData);
        System.out.println("RECIVE LAYER: " + pData);
    }

    public void Selector(Packet packetAux) {
        if (packetAux.cmd.contentEquals("AUR")) {
            this.Auth(packetAux);
        } else if (packetAux.cmd.contentEquals("LDR")) {
            this.Layer(packetAux);
        } else if (packetAux.cmd.contentEquals("CNR")) {
            this.ConnexionReset(packetAux);
        } else if (packetAux.cmd.contentEquals("LMB")) {
            this.ReceiveData(packetAux);
        }
    }

    public void packetReceived(Object packet) {
        Packet auxpacket = (Packet)packet;
        this.Selector(auxpacket);
    }
}

