/*
 * Decompiled with CFR 0.152.
 */
package GeneticAlgorithm;

import GeneticAlgorithm.Genetico;
import GeneticAlgorithm.Individual;
import GeneticAlgorithm.Problem;
import java.io.IOException;
import java.util.List;

public class BatteriaPruebas {
    String _file;
    double _solucion;
    int _poblacion = 0;
    int _generaciones = 0;

    public BatteriaPruebas(String file, double solucion) {
        this._file = file;
        this._solucion = solucion;
    }

    public void setParamGenetico(int poblacion, int generaciones) {
        this._poblacion = poblacion;
        this._generaciones = generaciones;
    }

    public void run(boolean print_problema) throws IOException {
        Problem problemCurrent = new Problem(this._file);
        problemCurrent.setFitnesSolution(this._solucion);
        Genetico genProblemBasic = new Genetico(this._poblacion, this._generaciones, problemCurrent);
        genProblemBasic.run();
        Individual sol = genProblemBasic.getSolution();
        long timeConsumed = genProblemBasic.getTimeConsumed();
        List<Double> fitnessHistory = genProblemBasic.getHistoryFitness();
        int generationCountSol = genProblemBasic.getGenerationCount();
        problemCurrent.setGeneticParams(this._poblacion, this._generaciones);
        problemCurrent.setFindSolution(sol);
        problemCurrent.setTimeConsumed(timeConsumed);
        problemCurrent.setHisttoryFitness(fitnessHistory);
        problemCurrent.setGenerationCount(generationCountSol);
        problemCurrent.setHisttoryFitnessEliStd(genProblemBasic.getHistorySTDFitness());
        problemCurrent.printSolution(print_problema);
        genProblemBasic.clear();
    }

    public static void main(String[] args) throws IOException {
        int wharehouses = 6;
        int clients = 8;
        double[] fixed_costs = new double[]{29.0, 196.0, 241.0, 949.0, 385.0, 357.0};
        double[][] transport_cost = new double[][]{{219.62216620615933, 371.4461022141098, 354.9633979378833, 188.52374898037138, 38.396895131596544, 306.692587566809}, {137.84130821319806, 285.32783513707403, 273.22719406972146, 145.95542855258842, 71.50547427599622, 222.3013570754517}, {100.36066625303033, 182.51140086154183, 201.25528776627235, 199.24599968533596, 178.41708283928898, 102.33609064345852}, {167.98164279175901, 330.28556887146686, 292.2802212189338, 91.39542103265921, 125.75671846330327, 292.2603942862563}, {82.36527742513093, 81.56258940997219, 68.68517828082763, 192.3620660304472, 284.11770762333754, 103.1017901063886}, {183.12034735808953, 77.82806888231735, 50.86665617304768, 269.5759397745284, 390.28772397785195, 173.83716370977245}, {34.648596222871625, 169.90987005455943, 124.99261611907835, 103.73192260689697, 228.7691063804953, 167.5598182272201}, {105.02802173253049, 95.15763934865137, 132.802286539909, 226.74253176806502, 263.0258918812148, 37.39839654670215}};
        Problem problemCurrent = new Problem(wharehouses, clients);
        problemCurrent.setFixedCost(fixed_costs);
        problemCurrent.setTransportCost(transport_cost);
        int _poblacion = wharehouses * 2;
        int _generaciones = clients * 100;
        Genetico genProblemBasic = new Genetico(_poblacion, _generaciones, problemCurrent);
        genProblemBasic.run();
        Individual sol = genProblemBasic.getSolution();
        long timeConsumed = genProblemBasic.getTimeConsumed();
        List<Double> fitnessHistory = genProblemBasic.getHistoryFitness();
        int generationCountSol = genProblemBasic.getGenerationCount();
        problemCurrent.setGeneticParams(_poblacion, _generaciones);
        problemCurrent.setFindSolution(sol);
        problemCurrent.setTimeConsumed(timeConsumed);
        problemCurrent.setHisttoryFitness(fitnessHistory);
        problemCurrent.setHisttoryFitnessEliStd(genProblemBasic.getHistorySTDFitness());
        problemCurrent.setGenerationCount(generationCountSol);
        problemCurrent.printSolution(true);
    }
}

