/*
 * Decompiled with CFR 0.152.
 */
package GeneticAlgorithm;

import GeneticAlgorithm.Individual;
import GeneticAlgorithm.Problem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class Fitness {
    private double[] _fixedCost;
    private double[][] _transportCost;
    private int _clients;
    private double fitnessMAX = 0.0;
    private final int numDecimales = 3;
    private Map<Individual, Double> _cacheFitness;

    public Fitness(Problem problema) {
        this._clients = problema.getNumClients();
        this._fixedCost = problema.getFixedCost();
        this._transportCost = problema.getTransportCost();
        this._cacheFitness = new HashMap<Individual, Double>();
        this.fitnessMAX = problema.getMaxCost();
    }

    public double setFitness(Individual individuo) {
        if (this._cacheFitness.containsKey(individuo)) {
            return this.fitnessMAX;
        }
        boolean[] genes = individuo.getGenes();
        double fitness = 0.0;
        int length_facilities = genes.length;
        int length_clients = this._clients;
        int ind = 0;
        while (ind < length_facilities) {
            if (genes[ind]) {
                fitness += this._fixedCost[ind];
            }
            ++ind;
        }
        if (fitness == 0.0) {
            fitness = this.fitnessMAX;
        } else {
            int j = 0;
            while (j < length_clients) {
                double min = 2.147483647E9;
                int i = 0;
                while (i < length_facilities) {
                    double current;
                    if (genes[i] && (current = this._transportCost[j][i]) < min) {
                        min = current;
                    }
                    ++i;
                }
                fitness += min;
                ++j;
            }
            fitness = this.round(fitness, 3);
        }
        this._cacheFitness.put(individuo, fitness);
        return fitness;
    }

    private double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

