/*
 * Decompiled with CFR 0.152.
 */
package GeneticAlgorithm;

import GeneticAlgorithm.Fitness;
import GeneticAlgorithm.Individual;
import GeneticAlgorithm.Population;
import GeneticAlgorithm.Problem;
import GeneticAlgorithm.RandomSingleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Genetico {
    public Problem problemCurrent;
    public final double crossRateOriginal = 0.85;
    public final double mutateRateOriginal = 0.001;
    private double crossRate = 0.85;
    private double mutationRate = 0.001;
    private boolean elitism = true;
    private final double por_elitism = 0.1;
    private int num_elitism = 0;
    private int num_tama\u00f1oXover = 0;
    private final double por_Xover = 0.9;
    public boolean debug = false;
    private int estable = 0;
    private final double MAX_ITER_ESTABLE_rate = 0.1;
    private int MAX_ITER_ESTABLE;
    Individual better;
    private int _populationSize = 10;
    int _maxGeneraciones = 1;
    int _generationCount = 0;
    Population population;
    long time;
    Individual fittest;
    List<Double> historyFitness;
    List<Double> historySTDFitness;
    public static Fitness fitnessFunction;

    public Genetico(int populationSize, int maxGeneraciones, Problem problem) {
        this._populationSize = populationSize;
        this._maxGeneraciones = maxGeneraciones;
        this.problemCurrent = problem;
        fitnessFunction = new Fitness(problem);
        this.population = new Population(this._populationSize, this.problemCurrent, 0.1, true);
        this.historyFitness = new Vector<Double>();
        this.historySTDFitness = new Vector<Double>();
        this._generationCount = 0;
        this.num_elitism = (int)((double)this._populationSize * 0.1);
        this.num_tama\u00f1oXover = (int)((double)this._populationSize * 0.9);
        this.MAX_ITER_ESTABLE = (int)((double)this._maxGeneraciones * 0.1);
    }

    public void run() {
        long ini = System.currentTimeMillis();
        this.setFitness();
        if (this.debug) {
            System.out.println("RONDA INICIAL sum_fitness: " + this.population.getSumFitness() + " DESV: " + this.population.getDesvFitness());
            this.population.print();
        }
        while (!this.cond_parada()) {
            this.population = this.evolvePopulation(this.population);
            this.setFitness();
            if (this.debug) {
                System.out.println("RONDA " + this._generationCount + " sum_fitness: " + this.population.getSumFitness() + " " + this.population.getDesvFitness());
                this.population.print();
            }
            this.checkEstabilidad();
            ++this._generationCount;
        }
        this.better = this.fittest;
        long fin = System.currentTimeMillis();
        this.time = fin - ini;
    }

    public void checkEstabilidad() {
        if ((int)this.population.getDesvFitness() > 0) {
            this.elitism = true;
        } else {
            this.mutationRate += 1.0E-4;
            double d = this.crossRate = this.crossRate < 1.0 ? this.crossRate + 0.001 : 1.0;
            if (this.crossRate == 1.0) {
                this.crossRate = 0.85;
            }
            this.elitism = false;
        }
    }

    private boolean cond_parada() {
        boolean ret = false;
        if (this._generationCount < this._maxGeneraciones) {
            if (this.problemCurrent.isKnownSolution() & this.fittest.getFitness() == this.problemCurrent.getFitnesSolution()) {
                ret = true;
            } else if (!this.problemCurrent.isKnownSolution()) {
                if (this._generationCount > 1) {
                    this.estable = Double.compare(this.historyFitness.get(this._generationCount - 1), this.historyFitness.get(this._generationCount)) == 0 ? ++this.estable : 0;
                }
                if (this.estable >= this.MAX_ITER_ESTABLE) {
                    ret = true;
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public int getGenerationCount() {
        return this._generationCount;
    }

    private void copyElitism(Population oldPopulation, Population newPopulation) {
        if (this.elitism) {
            int i = 0;
            while (i < this.num_elitism) {
                newPopulation.addIndividual(oldPopulation.getIndividual(i));
                ++i;
            }
        }
    }

    private void copy(Population PopulationTarget, List<Individual> PopulationOrigin) {
        int leng = PopulationOrigin.size();
        int i = 0;
        while (i < leng) {
            PopulationTarget.addIndividual(PopulationOrigin.get(i));
            ++i;
        }
        PopulationOrigin.clear();
    }

    private Population evolvePopulation(Population Population2) {
        int elitismOffset = this.elitism ? this.num_elitism : 0;
        Population newPopulation = new Population(this._populationSize, this.problemCurrent, 0.1, false);
        this.copyElitism(Population2, newPopulation);
        List<Individual> xoverselected = this.selected_crossover(Population2, this.num_tama\u00f1oXover);
        List<Individual> crossover = this.CrossOver(xoverselected, Population2);
        this.copy(newPopulation, crossover);
        xoverselected.clear();
        crossover.clear();
        int padding_size = this._populationSize - newPopulation.size();
        List<Individual> padding = this.ramdonPadding(Population2, padding_size);
        this.copy(newPopulation, padding);
        padding.clear();
        newPopulation.mutate(elitismOffset, this.mutationRate);
        Population2.clear();
        return newPopulation;
    }

    public List<Individual> ramdonPadding(Population Population2, int tama\u00f1o) {
        ArrayList<Individual> newPopulation = new ArrayList<Individual>();
        boolean local = false;
        int i = 0;
        while (i < tama\u00f1o) {
            Individual newIndiv = Population2.generateRamdonIndividual(local);
            newPopulation.add(newIndiv);
            ++i;
        }
        return newPopulation;
    }

    private void setFitness() {
        this.population.calculateFitness();
        this.fittest = this.population.getFittest();
        this.historyFitness.add(this.fittest.getFitness());
        this.historySTDFitness.add(this.population.getDesvFitness());
    }

    private List<Individual> CrossOver(List<Individual> Population2, Population oldpopulation) {
        ArrayList<Individual> newPopulation = new ArrayList<Individual>();
        Vector<Integer> selected = new Vector<Integer>();
        int i = 0;
        while (i < Population2.size()) {
            selected.add(i);
            ++i;
        }
        if (selected.size() % 2 != 0) {
            selected.remove(0);
        }
        i = 0;
        while (i < selected.size()) {
            Individual[] newInd;
            Individual ind2;
            int posInd1 = (Integer)selected.get(i);
            int posInd2 = (Integer)selected.get(i + 1);
            Individual ind1 = Population2.get(posInd1);
            if (ind1.isEqual(ind2 = Population2.get(posInd2))) {
                ind2 = oldpopulation.generateRamdonIndividual(false);
            }
            if (RandomSingleton.getInstance().nextDouble() < this.crossRate) {
                newInd = this.crossoverTwoPoints(ind1, ind2);
                newInd[0].setXover(ind1.getID(), ind2.getID());
                newInd[1].setXover(ind2.getID(), ind1.getID());
            } else {
                newInd = new Individual[]{new Individual(ind1), new Individual(ind2)};
                newInd[0].setXover(ind1.getID(), ind1.getID());
                newInd[1].setXover(ind2.getID(), ind2.getID());
            }
            newPopulation.add(newInd[0]);
            newPopulation.add(newInd[1]);
            i += 2;
        }
        return newPopulation;
    }

    private Individual[] crossoverUniform(Individual indiv1, Individual indiv2) {
        double p_mask = 0.5;
        Individual[] newSol = new Individual[2];
        if (RandomSingleton.getInstance().nextDouble() <= this.crossRate) {
            newSol[0] = new Individual(this.problemCurrent.getNumFacilities(), this.problemCurrent.getNumClients());
            newSol[1] = new Individual(this.problemCurrent.getNumFacilities(), this.problemCurrent.getNumClients());
            int i = 0;
            while (i < indiv1.size()) {
                if (RandomSingleton.getInstance().nextDouble() <= p_mask) {
                    newSol[0].setGene(i, indiv1.getGene(i));
                    newSol[1].setGene(i, indiv2.getGene(i));
                } else {
                    newSol[0].setGene(i, indiv2.getGene(i));
                    newSol[1].setGene(i, indiv1.getGene(i));
                }
                ++i;
            }
        } else {
            newSol[0] = indiv1;
            newSol[1] = indiv2;
        }
        return newSol;
    }

    private Individual[] crossoverOnePoint(Individual indiv1, Individual indiv2) {
        Individual[] newSol = new Individual[2];
        int len = indiv1.size();
        newSol[0] = new Individual(this.problemCurrent.getNumFacilities(), this.problemCurrent.getNumClients());
        newSol[1] = new Individual(this.problemCurrent.getNumFacilities(), this.problemCurrent.getNumClients());
        int point = RandomSingleton.getInstance().nextInt(len);
        int i = 0;
        while (i < point) {
            newSol[0].setGene(i, indiv1.getGene(i));
            newSol[1].setGene(i, indiv2.getGene(i));
            ++i;
        }
        i = point;
        while (i < len) {
            newSol[0].setGene(i, indiv2.getGene(i));
            newSol[1].setGene(i, indiv1.getGene(i));
            ++i;
        }
        return newSol;
    }

    private Individual[] crossoverTwoPoints(Individual indiv1, Individual indiv2) {
        int point2;
        Individual[] newSol = new Individual[]{new Individual(this.problemCurrent.getNumFacilities(), this.problemCurrent.getNumClients()), new Individual(this.problemCurrent.getNumFacilities(), this.problemCurrent.getNumClients())};
        int point1 = (int)(RandomSingleton.getInstance().nextDouble() * (double)indiv1.size());
        if (point1 > (point2 = (int)(RandomSingleton.getInstance().nextDouble() * (double)indiv1.size()))) {
            int swap = point1;
            point1 = point2;
            point2 = swap;
        }
        int i = 0;
        while (i < point1) {
            newSol[0].setGene(i, indiv1.getGene(i));
            newSol[1].setGene(i, indiv2.getGene(i));
            ++i;
        }
        i = point1;
        while (i < point2) {
            newSol[0].setGene(i, indiv2.getGene(i));
            newSol[1].setGene(i, indiv1.getGene(i));
            ++i;
        }
        i = point2;
        while (i < indiv1.size()) {
            newSol[0].setGene(i, indiv1.getGene(i));
            newSol[1].setGene(i, indiv2.getGene(i));
            ++i;
        }
        return newSol;
    }

    private List<Individual> selected_crossover(Population oldPopulation, int tama\u00f1o) {
        ArrayList<Individual> selectedList = new ArrayList<Individual>();
        int i = 0;
        while (i < tama\u00f1o) {
            selectedList.add(new Individual(oldPopulation.getIndividual(oldPopulation.Roulette_wheel_int())));
            ++i;
        }
        return selectedList;
    }

    public Individual getSolution() {
        return this.better;
    }

    public boolean[] getSolutionVector() {
        return this.better.genes;
    }

    public long getTimeConsumed() {
        return this.time;
    }

    public List<Double> getHistoryFitness() {
        return this.historyFitness;
    }

    public List<Double> getHistorySTDFitness() {
        return this.historySTDFitness;
    }

    public void clear() {
        this.historyFitness.clear();
        this.historySTDFitness.clear();
    }
}

