/*
 * Decompiled with CFR 0.152.
 */
package GeneticAlgorithm;

import GeneticAlgorithm.Genetico;
import GeneticAlgorithm.RandomSingleton;

public class Individual
implements Comparable<Object> {
    int length = 0;
    public boolean[] genes = null;
    private double _fitness = 0.0;
    int _client = 0;
    int _hashCode = 0;
    static int ID = 0;
    int myID = 0;
    boolean xOver = false;
    int[] xOverp = null;
    boolean mutation = false;

    private Individual() {
    }

    public Individual(Individual other) {
        this.length = other.length;
        this._client = other._client;
        this._fitness = other._fitness;
        this._hashCode = other._hashCode;
        this.genes = new boolean[this.length];
        int i = 0;
        while (i < this.length) {
            this.genes[i] = other.genes[i];
            ++i;
        }
        this.myID = ++ID;
    }

    public Individual(int n, int m) {
        this.length = n;
        this.genes = new boolean[this.length];
        this._client = m;
        int i = 0;
        while (i < this.length) {
            this.genes[i] = false;
            ++i;
        }
        this.myID = ++ID;
    }

    public void generateIndividual() {
        int i = 0;
        while (i < this.length) {
            boolean gene;
            this.genes[i] = gene = RandomSingleton.getInstance().nextBoolean();
            ++i;
        }
    }

    public void generateIndividual(double t) {
        double cota = 1.5;
        double ro1 = 0.07;
        double ro2 = 0.3;
        int i = 0;
        while (i < this.length) {
            double r = RandomSingleton.getInstance().nextDouble();
            this.genes[i] = t >= cota ? r <= ro1 : r <= ro2;
            ++i;
        }
    }

    public boolean getGene(int index) {
        return this.genes[index];
    }

    public void setGene(int index, boolean value) {
        this.genes[index] = value;
        this._fitness = 0.0;
    }

    public int size() {
        return this.length;
    }

    public void setFitness(double fitness) {
        this._fitness = fitness;
    }

    private double calculateFitness() {
        this._fitness = Genetico.fitnessFunction.setFitness(this);
        return this._fitness;
    }

    public double getFitness() {
        if (this._fitness == 0.0) {
            this._fitness = this.calculateFitness();
        }
        return this._fitness;
    }

    public String toString() {
        String geneString = " FITNESS: " + this._fitness + " ID: " + this.myID;
        if (this.xOver) {
            geneString = String.valueOf(geneString) + "\tXover " + this.xOverp[0] + " " + this.xOverp[1];
        }
        if (this.mutation) {
            geneString = String.valueOf(geneString) + " Mutado";
        }
        int i = 0;
        while (i < this.size()) {
            geneString = String.valueOf(geneString) + " " + this.getGene(i);
            ++i;
        }
        return geneString;
    }

    public boolean equals(Object o) {
        Individual another = (Individual)o;
        int i = 0;
        while (i < this.length) {
            if (this.genes[i] != another.getGene(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int prime = 31;
            this._hashCode = 1;
            boolean[] blArray = this.genes;
            int n = this.genes.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean gen = blArray[n2];
                this._hashCode = 31 * this._hashCode + gen.hashCode();
                ++n2;
            }
        }
        return this._hashCode;
    }

    public void mutate(double mutationRate) {
        int len = this.genes.length;
        int i = 0;
        while (i < len) {
            if (RandomSingleton.getInstance().nextDouble() <= mutationRate) {
                this.genes[i] = !this.genes[i];
                this.mutation = true;
            }
            ++i;
        }
    }

    public boolean[] getGenes() {
        return this.genes;
    }

    @Override
    public int compareTo(Object o) {
        Individual a = (Individual)o;
        int dev = 0;
        double resta = this._fitness - a.getFitness();
        if (resta == 0.0) {
            return 0;
        }
        dev = resta > 0.0 ? 1 : -1;
        return dev;
    }

    public int distancia(Individual other) {
        int distancia = 0;
        int i = 0;
        while (i < this.length) {
            if (this.genes[i] != other.genes[i]) {
                ++distancia;
            }
            ++i;
        }
        return distancia;
    }

    public boolean isEqual(Individual other) {
        return this._fitness == other._fitness;
    }

    public int getID() {
        return this.myID;
    }

    public void setXover(int p1, int p2) {
        this.xOver = true;
        this.xOverp = new int[2];
        this.xOverp[0] = p1;
        this.xOverp[1] = p2;
    }

    public void setMutation() {
        this.mutation = true;
    }
}

