/*
 * Decompiled with CFR 0.152.
 */
package GeneticAlgorithm;

import GeneticAlgorithm.Individual;
import GeneticAlgorithm.Problem;
import GeneticAlgorithm.RandomSingleton;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class Population {
    List<Individual> individuals;
    int _length_individuals;
    int _length_client;
    int _populationSize;
    Problem _problem;
    Individual _fittest = null;
    int _numIndStd = 30;
    double sum_fitnessElitim = 0.0;
    double _t = 0.0;
    double max_fitness = Double.MIN_VALUE;
    double min_fitness = Double.MAX_VALUE;
    double sum_fitness = 0.0;

    public Population(int populationSize, Problem problem, double por_elitism, boolean initialise) {
        this._problem = problem;
        this._length_individuals = problem.getNumFacilities();
        this._length_client = problem.getNumClients();
        this._populationSize = populationSize;
        this.individuals = new Vector<Individual>();
        this._fittest = null;
        if (initialise) {
            this._t = problem.get_t();
            boolean local = true;
            int i = 0;
            while (i < this._populationSize) {
                this.addIndividual(this.generateRamdonIndividual(local));
                ++i;
            }
            Collections.sort(this.individuals);
        }
        this.max_fitness = Double.MIN_VALUE;
        this.min_fitness = Double.MAX_VALUE;
        this.sum_fitness = 0.0;
        this.sum_fitnessElitim = 0.0;
        this._numIndStd = (int)((double)this._populationSize * por_elitism);
    }

    public Individual getIndividual(int index) {
        return this.individuals.get(index);
    }

    public Individual getFittest() {
        Collections.sort(this.individuals);
        return this.individuals.get(0);
    }

    public int size() {
        return this.individuals.size();
    }

    public void addIndividual(Individual indiv) {
        this.individuals.add(indiv);
    }

    public void calculateFitness() {
        this.sum_fitness = 0.0;
        this._populationSize = this.individuals.size();
        int index = 0;
        while (index < this._populationSize) {
            Individual temp = this.individuals.get(index);
            double fit = temp.getFitness();
            if (fit > this.max_fitness) {
                this.max_fitness = fit;
            }
            if (fit < this.min_fitness) {
                this.min_fitness = fit;
                this._fittest = temp;
            }
            this.sum_fitness += fit;
            if (index < this._numIndStd) {
                this.sum_fitnessElitim += fit;
            }
            ++index;
        }
    }

    public void print() {
        int len = this.individuals.size();
        int i = 0;
        while (i < len) {
            System.out.println("i: " + i + " " + this.individuals.get(i));
            ++i;
        }
    }

    public void mutate(int elitismOffset, double mutationRate) {
        int length = this.individuals.size();
        int i = elitismOffset;
        while (i < length) {
            this.individuals.get(i).mutate(mutationRate);
            ++i;
        }
    }

    public double getDesvFitness() {
        double cont = 0.0;
        double sol = Double.MAX_VALUE;
        if (this._numIndStd > 1) {
            double media = this.sum_fitnessElitim / (double)this._numIndStd;
            int i = 0;
            while (i < this._numIndStd) {
                double temp = this.individuals.get(i).getFitness() - media;
                double resta = temp * temp;
                cont += resta;
                ++i;
            }
            double div = cont / (double)(this._numIndStd - 1);
            sol = Math.sqrt(div);
        }
        return sol;
    }

    public double getSumFitness() {
        return this.sum_fitness;
    }

    public Individual Roulette_wheel() {
        return this.individuals.get(this.Roulette_wheel_int());
    }

    public int Roulette_wheel_int() {
        double r = RandomSingleton.getInstance().nextDouble();
        double p = r * this.getSumFitness();
        double t = this.max_fitness + this.min_fitness;
        int i = 0;
        i = 0;
        while (i < this._populationSize) {
            if ((p -= t - this.individuals.get(i).getFitness()) < 0.0) break;
            ++i;
        }
        if (i == this._populationSize) {
            --i;
        }
        return i;
    }

    public void clear() {
        this.individuals.clear();
    }

    public Individual generateRamdonIndividual(boolean local) {
        Individual newIndividual = new Individual(this._length_individuals, this._length_client);
        if (local) {
            newIndividual.generateIndividual(this._t);
        } else {
            newIndividual.generateIndividual();
        }
        return newIndividual;
    }

    public void setNumIndStd(int numIndStd) {
        this._numIndStd = numIndStd;
    }
}

