/*
 * Decompiled with CFR 0.152.
 */
package GeneticAlgorithm;

import ClientFerature.geneticLog;
import GeneticAlgorithm.Individual;
import GeneticAlgorithm.RandomSingleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class Problem {
    int _facilities;
    int _clients;
    double[] _fixed_costs;
    double[][] _transport_cost;
    Individual _sol = null;
    double _fitness_sol;
    long _timeConsumed;
    int _poblacion;
    int _generaciones;
    int _generacionSol;
    List<Double> _fitnessHistory;
    List<Double> _fitnessSumHistory;
    boolean knowSolution = false;
    private double maxCost = -1.0;
    double t = 0.0;
    Map<Integer, Integer> minHash = null;
    geneticLog _log = null;
    boolean solutionFound = false;

    public Problem(String file) throws IOException {
        InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream(file));
        BufferedReader br = new BufferedReader(reader);
        String line = br.readLine();
        String[] elements = line.split(" ");
        int warehouse = Integer.parseInt(elements[1]);
        int clients = Integer.parseInt(elements[2]);
        int warehouse_cont = 0;
        int clients_cont = 0;
        double[] costs = new double[warehouse];
        double[] capacity = new double[warehouse];
        double[][] costsTransp = new double[clients][warehouse];
        double[] demand = new double[clients];
        int j = -1;
        int i = 0;
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            elements = line.split(" ");
            if (warehouse_cont < warehouse) {
                capacity[warehouse_cont] = elements[1].equalsIgnoreCase("capacity") ? 0.0 : Double.parseDouble(elements[1]);
                costs[warehouse_cont] = Double.parseDouble(elements[2]);
                ++warehouse_cont;
                continue;
            }
            if (elements.length == 2 && i != clients - 1) {
                demand[clients_cont] = Double.parseDouble(elements[1]);
                ++clients_cont;
                i = 0;
                ++j;
                continue;
            }
            int aux = 1;
            while (aux < elements.length) {
                costsTransp[j][i] = Double.parseDouble(elements[aux]);
                ++i;
                ++aux;
            }
        }
        this._facilities = warehouse;
        this._clients = clients;
        this.setFixedCost(costs);
        this.setTransportCost(costsTransp);
        br.close();
    }

    public Problem(int n, int m) {
        this._facilities = n;
        this._clients = m;
        this._fixed_costs = new double[n];
        this._transport_cost = new double[n][m];
    }

    public void setSeed(int seed) {
        RandomSingleton.clear();
        RandomSingleton.setSeed(seed);
    }

    public void setFixedCost(double[] fixed_costs) {
        this._fixed_costs = fixed_costs;
    }

    public void setTransportCost(double[][] transport_cost) {
        this._transport_cost = transport_cost;
    }

    public double[] getFixedCost() {
        return this._fixed_costs;
    }

    public double[][] getTransportCost() {
        return this._transport_cost;
    }

    public int getNumFacilities() {
        return this._facilities;
    }

    public int getNumClients() {
        return this._clients;
    }

    public void setFindSolution(Individual sol) {
        this._sol = sol;
    }

    public void setFitnesSolution(double fitness_sol) {
        this._fitness_sol = fitness_sol;
        this.knowSolution = true;
    }

    public double getFitnesSolution() {
        return this._fitness_sol;
    }

    public boolean isKnownSolution() {
        return this.knowSolution;
    }

    public void setTimeConsumed(long timeConsumed) {
        this._timeConsumed = timeConsumed;
    }

    public void setGeneticParams(int poblacion, int generaciones) {
        this._poblacion = poblacion;
        this._generaciones = generaciones;
    }

    public void setHisttoryFitness(List<Double> fitnessHistory) {
        this._fitnessHistory = fitnessHistory;
    }

    public void setHisttoryFitnessEliStd(List<Double> fitnessSumHistory) {
        this._fitnessSumHistory = fitnessSumHistory;
    }

    public void setGenerationCount(int count) {
        this._generacionSol = count;
    }

    public void printSolution(boolean problema) {
        int i;
        int i2;
        if (problema) {
            this.salida_ln("\n\n********* PROBLEM ********");
            this.salida_ln("Warehouse: " + this._facilities);
            this.salida_ln("Clients:  " + this._clients);
            this.salida("Fix Costs: ");
            i2 = 0;
            while (i2 < this._facilities) {
                this.salida(String.valueOf(this._fixed_costs[i2]) + " ");
                ++i2;
            }
            this.salida_ln("\nTransport Costs: ");
            int j = 0;
            while (j < this._clients) {
                i = 0;
                while (i < this._facilities) {
                    System.out.print(String.valueOf(this._transport_cost[j][i]) + " ");
                    ++i;
                }
                this.salida_ln(" ");
                ++j;
            }
        }
        if (this.knowSolution) {
            if (this._sol.getFitness() == this._fitness_sol) {
                this.solutionFound = true;
                this.salida_ln("\n******* SOLUTION FOUND**********");
            } else {
                this.salida_ln("\n******* SOLUTION NOT FOUND **********");
            }
        } else {
            this.salida_ln("\n******* STABLE SOLUTION **********");
        }
        if (this._sol == null) {
            this.salida_ln("Solution not  known");
        } else {
            this.salida_ln("Indivual: " + this._sol);
            this.salida_ln("fitness: " + this._sol.getFitness());
            this.salida("Warehouse open(s) [start on 0]: ");
            i2 = 0;
            while (i2 < this._facilities) {
                if (this._sol.getGene(i2)) {
                    this.salida(String.valueOf(i2) + " ");
                }
                ++i2;
            }
            this.salida_ln("");
            if (problema) {
                int[] assig = this.clientAsign();
                i = 0;
                while (i < this._clients) {
                    System.out.print("Cliente " + i + ": " + assig[i] + " ");
                    if (i > 1 & i % 7 == 0) {
                        this.salida_ln("");
                    }
                    ++i;
                }
            }
        }
        this.salida_ln("\nPoblation: " + this._poblacion + " Max Generation: " + this._generaciones + " Generation stopped: " + this._generacionSol);
        this.salida_ln("Time (milliseconds): " + this._timeConsumed + " Seed Random: " + RandomSingleton.getInstance().getSemilla());
        this.salida_ln("\nRecord Fitness:");
        int length = this._fitnessHistory.size();
        i = 0;
        while (i < length) {
            this.salida(this._fitnessHistory.get(i) + "; ");
            ++i;
        }
        this.salida_ln("\nElitism Record Fitness:");
        int lengthSum = this._fitnessSumHistory.size();
        int i3 = 0;
        while (i3 < lengthSum) {
            this.salida(this._fitnessSumHistory.get(i3) + "; ");
            ++i3;
        }
    }

    private void calculate_t() {
        double denominador = 0.0;
        int i = 0;
        while (i < this._facilities) {
            denominador += this._fixed_costs[i];
            ++i;
        }
        denominador /= (double)this._facilities;
        double divisor = 0.0;
        int j = 0;
        while (j < this._clients) {
            int i2 = 0;
            while (i2 < this._facilities) {
                divisor += this._transport_cost[j][i2];
                ++i2;
            }
            ++j;
        }
        this.t = denominador / (divisor /= (double)(this._facilities * this._clients));
    }

    public double get_t() {
        if (this.t == 0.0) {
            this.calculate_t();
        }
        return this.t;
    }

    private double calculateMaxCost() {
        double maxCost = 0.0;
        int ind = 0;
        while (ind < this._facilities) {
            maxCost += this._fixed_costs[ind];
            int j = 0;
            while (j < this._clients) {
                maxCost += this._transport_cost[j][ind];
                ++j;
            }
            ++ind;
        }
        return Math.round(maxCost);
    }

    public double getMaxCost() {
        if (this.maxCost == -1.0) {
            this.maxCost = this.calculateMaxCost();
        }
        return this.maxCost;
    }

    public int[] clientAsign() {
        int[] clientAsignMin = new int[this._clients];
        double current = 0.0;
        boolean[] genes = this._sol.getGenes();
        int j = 0;
        while (j < this._clients) {
            double min = 2.147483647E9;
            int min_j = 0;
            int i = 0;
            while (i < this._facilities) {
                if (genes[i] && (current = this._transport_cost[j][i]) < min) {
                    min = current;
                    min_j = i;
                }
                ++i;
            }
            clientAsignMin[j] = min_j;
            ++j;
        }
        return clientAsignMin;
    }

    public void setLog(geneticLog log) {
        this._log = log;
    }

    public void salida_ln(String out) {
        if (this._log == null) {
            System.out.println(out);
        } else {
            this._log.addLog(out);
        }
    }

    public void salida(String out) {
        if (this._log == null) {
            System.out.print(out);
        } else {
            this._log.addLog_S(out);
        }
    }

    public boolean isSolutionFound() {
        return this.solutionFound;
    }
}

