/*
 * Decompiled with CFR 0.152.
 */
package MapFrame;

import java.io.Serializable;

public class Punto
implements Serializable {
    double latitude = 0.0;
    double longitude = 0.0;

    Punto() {
    }

    public Punto(double latitudep, double longitudep) {
        this.latitude = latitudep;
        this.longitude = longitudep;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return "\t " + this.latitude + " " + this.longitude;
    }

    public double distance(Punto other) {
        double R = 6371.0;
        double dLat = this.deg2rad(other.latitude - this.latitude);
        double dLon = this.deg2rad(other.longitude - this.longitude);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(this.deg2rad(this.latitude)) * Math.cos(this.deg2rad(other.latitude)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double d = R * c;
        return d;
    }

    private double deg2rad(double deg) {
        return deg * (Math.PI / 180);
    }
}

