/*
 * Decompiled with CFR 0.152.
 */
package Packet;

import MapFrame.Layer;
import Packet.Packet;
import Packet.PacketException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class PacketAuthR
extends Packet {
    public static final transient String HEAD = "AUR";
    public static final transient String OKA = "OKA";
    public static final transient String WPW = "WPW";
    public static final transient String ONL = "ONL";
    public String Option = null;
    List<Layer> layerL;

    public PacketAuthR(List<Layer> layers) throws PacketException {
        super('+', HEAD);
        this.setMessage(OKA, layers);
    }

    public PacketAuthR(String OptionP) throws PacketException {
        super('-', HEAD);
        this.setMessage(OptionP, null);
    }

    public void setMessage(String OptionP, List<Layer> layers) throws PacketException {
        if (!OptionP.contentEquals(OKA)) {
            if (!OptionP.contentEquals(WPW) && !OptionP.contentEquals(ONL)) {
                this.nEx = new PacketException(OptionP);
                this.nEx.setDescription("Message is void.");
                throw this.nEx;
            }
            this.Option = OptionP;
            this.code = (char)45;
        } else {
            this.Option = OptionP;
            this.layerL = layers;
        }
    }

    @Override
    protected void writeObject(ObjectOutputStream s) throws IOException {
        super.writeObject(s);
        int length = this.layerL.size();
        s.writeUTF(this.Option);
        s.writeInt(length);
        if (length > 0) {
            for (Layer layer : this.layerL) {
                int size = layer.getNelements();
                int layerType = layer.getTipo();
                String layerName = layer.getName();
                s.writeInt(size);
                s.writeInt(layerType);
                s.writeUTF(layerName);
            }
        }
    }

    @Override
    protected void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readObject(s);
        this.Option = s.readUTF();
        int numLayer = s.readInt();
        if (numLayer > 0) {
            this.layerL = new ArrayList<Layer>();
            int i = 0;
            while (i < numLayer) {
                int size = s.readInt();
                int layerType = s.readInt();
                String layerName = s.readUTF();
                Layer newlayer = new Layer(layerName, layerType, size);
                this.layerL.add(newlayer);
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        String msg = "<--";
        msg = msg.concat(super.toString());
        msg = msg.concat(" " + this.Option);
        if (this.layerL != null) {
            int length = this.layerL.size();
            msg = msg.concat(" " + length);
            if (length > 0) {
                for (Layer layer : this.layerL) {
                    int size = layer.getNelements();
                    int layerType = layer.getTipo();
                    String layerName = layer.getName();
                    msg = msg.concat(" " + layerName + " " + layerType + " " + size + " ");
                }
            }
        }
        return msg;
    }

    public boolean isBadPwd() {
        return this.Option.contentEquals(WPW);
    }

    public int LayerSize() {
        if (this.layerL != null) {
            return this.layerL.size();
        }
        return 0;
    }

    public List<Layer> getLayers() {
        return this.layerL;
    }
}

