/*
 * Decompiled with CFR 0.152.
 */
package Packet;

import MapFrame.Feature;
import MapFrame.Poly;
import MapFrame.Punto;
import Packet.Packet;
import Packet.PacketException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class PacketLayerDataR
extends Packet {
    public static final transient String HEAD = "LDR";
    public String layerNameL = null;
    public int tipoL = 0;
    List<Punto> ptosL = null;
    List<Poly> polyL = null;

    public PacketLayerDataR(String layerName, List<Punto> ptos) throws PacketException {
        super('+', HEAD);
        this.setMessage(layerName, 0, ptos, null);
    }

    public PacketLayerDataR(String layerName, Feature.type type2, List<Poly> poly) throws PacketException {
        super('+', HEAD);
        int tipo = 1;
        if (type2 == Feature.type.Polygon) {
            tipo = 2;
        }
        this.setMessage(layerName, tipo, null, poly);
    }

    public void setMessage(String layerName, int tipo, List<Punto> ptos, List<Poly> poly) throws PacketException {
        this.layerNameL = layerName;
        this.tipoL = tipo;
        this.ptosL = ptos;
        this.polyL = poly;
    }

    @Override
    protected void writeObject(ObjectOutputStream s) throws IOException {
        super.writeObject(s);
        s.writeUTF(this.layerNameL);
        s.writeInt(this.tipoL);
        if (this.tipoL == 0) {
            if (this.ptosL != null) {
                s.writeInt(this.ptosL.size());
                for (Punto pto : this.ptosL) {
                    s.writeObject(pto);
                }
            } else {
                s.writeInt(0);
            }
        } else if (this.polyL != null) {
            s.writeInt(this.polyL.size());
            for (Poly lyne : this.polyL) {
                s.writeObject(lyne);
            }
        } else {
            s.writeInt(0);
        }
    }

    @Override
    protected void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readObject(s);
        this.layerNameL = s.readUTF();
        this.tipoL = s.readInt();
        int size = s.readInt();
        if (this.tipoL == 0) {
            this.ptosL = new ArrayList<Punto>();
            int i = 0;
            while (i < size) {
                Punto pto = (Punto)s.readObject();
                this.ptosL.add(pto);
                ++i;
            }
        } else {
            this.polyL = new ArrayList<Poly>();
            int i = 0;
            while (i < size) {
                Poly lyne = (Poly)s.readObject();
                this.polyL.add(lyne);
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        String msg = "-->";
        msg = msg.concat(super.toString());
        msg = msg.concat(" " + this.layerNameL + " " + this.tipoL);
        return msg;
    }

    public String getLayerName() {
        return this.layerNameL;
    }

    public int getTypeIntLayer() {
        return this.tipoL;
    }

    public List<Punto> getPtos() {
        return this.ptosL;
    }

    public List<Poly> getLynes() {
        return this.polyL;
    }

    public Feature.type getTypeLayer() {
        switch (this.tipoL) {
            case 0: {
                return Feature.type.Point;
            }
            case 1: {
                return Feature.type.LineString;
            }
            case 2: {
                return Feature.type.Polygon;
            }
        }
        return Feature.type.Point;
    }
}

