/*
 * Decompiled with CFR 0.152.
 */
package UFLP;

import UFLP.CustomWayPoint;
import UFLP.MultiplyComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;

public class FancyWaypointRenderer
implements WaypointRenderer<CustomWayPoint> {
    private static final Log log = LogFactory.getLog(FancyWaypointRenderer.class);
    private final Map<Color, BufferedImage> map = new HashMap<Color, BufferedImage>();
    private final Font font = new Font("Verdana", 1, 10);
    private BufferedImage origImage;

    public FancyWaypointRenderer() {
        URL resource = this.getClass().getResource("/waypoint_white.png");
        try {
            this.origImage = ImageIO.read(resource);
        }
        catch (Exception ex) {
            log.warn((Object)"couldn't read waypoint_white.png", (Throwable)ex);
        }
    }

    private BufferedImage convert(BufferedImage loadImg, Color newColor) {
        int w = loadImg.getWidth();
        int h = loadImg.getHeight();
        BufferedImage imgOut = new BufferedImage(w, h, 2);
        BufferedImage imgColor = new BufferedImage(w, h, 2);
        Graphics2D g = imgColor.createGraphics();
        g.setColor(newColor);
        g.fillRect(0, 0, w + 1, h + 1);
        g.dispose();
        Graphics2D graphics = imgOut.createGraphics();
        graphics.drawImage((Image)loadImg, 0, 0, null);
        graphics.setComposite(MultiplyComposite.Default);
        graphics.drawImage((Image)imgColor, 0, 0, null);
        graphics.dispose();
        return imgOut;
    }

    public void paintWaypoint(Graphics2D g, JXMapViewer viewer, CustomWayPoint w) {
        g = (Graphics2D)g.create();
        if (this.origImage == null) {
            return;
        }
        BufferedImage myImg = this.map.get(w.getColor());
        if (myImg == null) {
            myImg = this.convert(this.origImage, w.getColor());
            this.map.put(w.getColor(), myImg);
        }
        Point2D point = viewer.getTileFactory().geoToPixel(w.getPosition(), viewer.getZoom());
        int x = (int)point.getX();
        int y = (int)point.getY();
        g.drawImage((Image)myImg, x - myImg.getWidth() / 2, y - myImg.getHeight(), null);
        String label = w.getLabel();
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics();
        int tw = metrics.stringWidth(label);
        int th = 1 + metrics.getAscent();
        g.drawString(label, x - tw / 2, y + th - myImg.getHeight());
        g.dispose();
    }
}

