/*
 * Decompiled with CFR 0.152.
 */
package UFLP;

import ClientFerature.Plot;
import ClientFerature.geneticLog;
import GeneticAlgorithm.Genetico;
import GeneticAlgorithm.Individual;
import GeneticAlgorithm.Problem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class GeneticWindow
extends JDialog
implements ActionListener {
    private final String LoadProblem = "Load Problem";
    private final String RunGeneticAlg = "Find a Solution";
    JComboBox ProblemsCbox;
    JComboBox ClientsCbox;
    DefaultTableModel tableFixedCostModel;
    DefaultTableModel tableTransportationCostModel;
    DefaultTableModel tableFacilitiesSolModel;
    JButton RunGenetic;
    String[] problemas = new String[]{"cap71", "cap72", "cap73", "cap74", "cap101", "cap102", "cap103", "cap104", "cap131", "cap132", "cap133", "cap134", "capa", "capb", "capc"};
    double[] soluciones = new double[]{932615.75, 977799.4, 1010641.45, 1034976.975, 796648.438, 854704.2, 893782.113, 928941.75, 793439.563, 851495.325, 893076.713, 928941.75, 1.7156454478E7, 1.2979071581E7, 1.1505594329E7};
    JLabel CostValue;
    JLabel TimeValue;
    Problem problemCurrent;
    Plot plot = null;
    geneticLog log;
    JTextField Seed;

    public GeneticWindow(JFrame frame) {
        super(frame, "Genetic algorithm", true);
        this.setLocation(100, 100);
        this.setLayout(null);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(770, 520));
        this.log = new geneticLog();
        JLabel ProblemsL = new JLabel("Problems: ");
        ProblemsL.setForeground(Color.GRAY);
        ProblemsL.setBounds(10, 20, 150, 25);
        this.add(ProblemsL);
        this.ProblemsCbox = new JComboBox<String>(this.problemas);
        this.ProblemsCbox.addActionListener(this);
        this.ProblemsCbox.setBounds(80, 20, 120, 25);
        this.add(this.ProblemsCbox);
        JButton LoadButton = new JButton("Load Problem");
        LoadButton.setBounds(225, 20, 140, 25);
        LoadButton.addActionListener(this);
        this.add(LoadButton);
        this.RunGenetic = new JButton("Find a Solution");
        this.RunGenetic.setBounds(610, 20, 150, 25);
        this.RunGenetic.addActionListener(this);
        this.RunGenetic.setEnabled(false);
        this.add(this.RunGenetic);
        JLabel SeedL = new JLabel("Random Seed: ");
        SeedL.setForeground(Color.BLACK);
        SeedL.setBounds(380, 20, 150, 25);
        this.add(SeedL);
        this.Seed = new JTextField(15);
        this.Seed.setBounds(470, 20, 100, 20);
        this.Seed.setText("5");
        this.add(this.Seed);
        JLabel FixedCostS = new JLabel("FIXED COST:");
        FixedCostS.setFont(new Font("ARIAL", 1, 16));
        FixedCostS.setForeground(Color.GRAY);
        FixedCostS.setBounds(10, 55, 130, 25);
        this.add(FixedCostS);
        this.tableFixedCostModel = new DefaultTableModel();
        JTable tableFixedCost = new JTable(this.tableFixedCostModel);
        tableFixedCost.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPaneFixedCost = new JScrollPane(tableFixedCost);
        this.getContentPane().add((Component)scrollPaneFixedCost, "Center");
        scrollPaneFixedCost.setBounds(10, 75, 750, 60);
        this.add(scrollPaneFixedCost);
        JLabel TransCostS = new JLabel("TRANSPORTATION COST:");
        TransCostS.setFont(new Font("ARIAL", 1, 16));
        TransCostS.setForeground(Color.GRAY);
        TransCostS.setBounds(10, 140, 260, 25);
        this.add(TransCostS);
        this.tableTransportationCostModel = new DefaultTableModel();
        JTable tableTransportationCost = new JTable(this.tableTransportationCostModel);
        tableTransportationCost.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPaneTransportationCost = new JScrollPane(tableTransportationCost);
        this.getContentPane().add((Component)scrollPaneTransportationCost, "Center");
        scrollPaneTransportationCost.setBounds(10, 160, 750, 100);
        this.add(scrollPaneTransportationCost);
        JLabel SolS = new JLabel("SOLUTION: ");
        SolS.setFont(new Font("ARIAL", 1, 16));
        SolS.setForeground(Color.GRAY);
        SolS.setBounds(10, 260, 130, 25);
        this.add(SolS);
        this.CostValue = new JLabel();
        this.CostValue.setFont(new Font("ARIAL", 1, 14));
        this.CostValue.setForeground(Color.BLUE);
        this.CostValue.setBounds(105, 260, 270, 25);
        this.add(this.CostValue);
        this.TimeValue = new JLabel("");
        this.TimeValue.setFont(new Font("ARIAL", 1, 12));
        this.TimeValue.setForeground(Color.BLACK);
        this.TimeValue.setBounds(370, 260, 290, 25);
        this.add(this.TimeValue);
        this.tableFacilitiesSolModel = new DefaultTableModel();
        JTable tableFacilitiesSol = new JTable(this.tableFacilitiesSolModel);
        tableFacilitiesSol.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrolltableFacilitiesSol = new JScrollPane(tableFacilitiesSol);
        this.getContentPane().add((Component)scrolltableFacilitiesSol, "Center");
        scrolltableFacilitiesSol.setBounds(10, 280, 750, 75);
        this.add(scrolltableFacilitiesSol);
        tableFacilitiesSol.setAutoResizeMode(0);
        tableFixedCost.setAutoResizeMode(0);
        tableTransportationCost.setAutoResizeMode(0);
        JLabel LogInfoL = new JLabel("Genetic Algorithm Info");
        LogInfoL.setFont(new Font("Tahoma", 1, 12));
        LogInfoL.setForeground(Color.GRAY);
        JScrollPane scrollPaneLog = new JScrollPane(this.log);
        this.add(LogInfoL);
        this.add(scrollPaneLog);
        LogInfoL.setBounds(10, 358, 180, 15);
        scrollPaneLog.setBounds(10, 378, 750, 100);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (GeneticWindow.this.plot != null) {
                    GeneticWindow.this.plot.closing();
                }
            }
        });
    }

    public void showWindow() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Load Problem")) {
            this.Load();
        } else if (cmd.equals("Find a Solution")) {
            this.Evaluation();
        }
    }

    private void Load() {
        String file = (String)this.ProblemsCbox.getSelectedItem();
        file = file.concat(".txt");
        double[] fixedCost = null;
        double[][] transportCost = null;
        int clients = -1;
        int facilities = -1;
        this.TimeValue.setText("");
        this.CostValue.setText("");
        this.log.clear();
        if (this.plot != null) {
            this.plot.closing();
            this.plot = null;
        }
        try {
            this.problemCurrent = new Problem(file);
            fixedCost = this.problemCurrent.getFixedCost();
            transportCost = this.problemCurrent.getTransportCost();
            clients = this.problemCurrent.getNumClients();
            facilities = this.problemCurrent.getNumFacilities();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.clearTable(this.tableFacilitiesSolModel);
        this.tableFacilitiesSolModel.setColumnCount(0);
        this.clearTable(this.tableFixedCostModel);
        this.tableFixedCostModel.setColumnCount(0);
        int index = 0;
        while (index < fixedCost.length) {
            this.tableFixedCostModel.addColumn("F" + index);
            ++index;
        }
        Object[] tmp = new Double[fixedCost.length];
        int index2 = 0;
        while (index2 < fixedCost.length) {
            tmp[index2] = new Double(fixedCost[index2]);
            ++index2;
        }
        this.tableFixedCostModel.addRow(tmp);
        this.clearTable(this.tableTransportationCostModel);
        this.tableTransportationCostModel.setColumnCount(0);
        Object[] facilitiesSol = new Object[facilities];
        Object[] clientSol = new Object[facilities];
        this.tableTransportationCostModel.addColumn("Clients");
        int index3 = 0;
        while (index3 < facilities) {
            this.tableTransportationCostModel.addColumn("F" + index3);
            this.tableFacilitiesSolModel.addColumn("F" + index3);
            facilitiesSol[index3] = false;
            clientSol[index3] = "";
            ++index3;
        }
        this.tableFacilitiesSolModel.addRow(facilitiesSol);
        this.tableFacilitiesSolModel.addRow(clientSol);
        int indexClients = 0;
        while (indexClients < clients) {
            Object[] rowX = new Object[facilities + 1];
            rowX[0] = "C" + indexClients;
            int indexFacilities = 0;
            while (indexFacilities < facilities) {
                rowX[indexFacilities + 1] = transportCost[indexClients][indexFacilities];
                ++indexFacilities;
            }
            this.tableTransportationCostModel.addRow(rowX);
            ++indexClients;
        }
        this.RunGenetic.setEnabled(true);
    }

    private void Evaluation() {
        int randomSeed = 5;
        try {
            randomSeed = Integer.parseInt(this.Seed.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showConfirmDialog(null, "Please enter numbers only", "Random seed", -1);
            return;
        }
        String file = (String)this.ProblemsCbox.getSelectedItem();
        file = file.concat(".txt");
        int selected = this.ProblemsCbox.getSelectedIndex();
        double solucion = this.soluciones[selected];
        this.problemCurrent.setFitnesSolution(solucion);
        this.problemCurrent.setSeed(randomSeed);
        int _poblacion = this.problemCurrent.getNumFacilities() * 2;
        int _generaciones = this.problemCurrent.getNumClients() * 100;
        this.problemCurrent.setLog(this.log);
        Genetico genProblemBasic = new Genetico(_poblacion, _generaciones, this.problemCurrent);
        genProblemBasic.run();
        Individual sol = genProblemBasic.getSolution();
        long timeConsumed = genProblemBasic.getTimeConsumed();
        List<Double> fitnessHistory = genProblemBasic.getHistoryFitness();
        int generationCountSol = genProblemBasic.getGenerationCount();
        this.problemCurrent.setGeneticParams(_poblacion, _generaciones);
        this.problemCurrent.setFindSolution(sol);
        this.problemCurrent.setTimeConsumed(timeConsumed);
        this.problemCurrent.setHisttoryFitness(fitnessHistory);
        this.problemCurrent.setHisttoryFitnessEliStd(genProblemBasic.getHistorySTDFitness());
        this.problemCurrent.setGenerationCount(generationCountSol);
        this.problemCurrent.printSolution(false);
        boolean[] solution = genProblemBasic.getSolutionVector();
        int i = 0;
        while (i < solution.length) {
            this.tableFacilitiesSolModel.setValueAt(solution[i], 0, i);
            ++i;
        }
        int[] asign = this.problemCurrent.clientAsign();
        int i2 = 0;
        while (i2 < asign.length) {
            String value = (String)this.tableFacilitiesSolModel.getValueAt(1, asign[i2]);
            value = value.length() == 0 ? "C" + i2 : String.valueOf(value) + ",C" + i2;
            this.tableFacilitiesSolModel.setValueAt(value, 1, asign[i2]);
            ++i2;
        }
        if (this.problemCurrent.isSolutionFound()) {
            this.CostValue.setText("Found, fitness value " + fitnessHistory.get(generationCountSol));
        } else {
            this.CostValue.setText("Not Found, fitness value " + fitnessHistory.get(generationCountSol));
        }
        this.TimeValue.setText("took " + timeConsumed + " milliseconds " + " and " + generationCountSol + " generations.");
        this.Chart("Fitness vs STD Elitism", fitnessHistory, "fitness", genProblemBasic.getHistorySTDFitness(), "STD Elitism");
    }

    public void clearTable(DefaultTableModel mode) {
        mode.getDataVector().removeAllElements();
        this.revalidate();
    }

    public void Chart(String title, List<Double> valores, String funcionLabe, List<Double> valores2, String funcionLabe2) {
        if (this.plot != null) {
            this.plot.closing();
        }
        this.plot = new Plot(title);
        this.plot.addData(valores, funcionLabe);
        this.plot.addData(valores2, funcionLabe2);
        this.plot.paint();
        this.plot.pack();
        this.plot.setVisible(true);
    }
}

