/*
 * Decompiled with CFR 0.152.
 */
package UFLP;

import MapFrame.Feature;
import MapFrame.Punto;
import UFLP.CustomWayPoint;
import UFLP.FancyWaypointRenderer;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.OSMTileFactoryInfo;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.DefaultWaypoint;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.LocalResponseCache;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointPainter;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

public class MapFrameGenetic {
    JXMapKit jXMapKit;
    JXMapViewer mapViewer;
    Set<Waypoint> listaWayPoints = new HashSet<Waypoint>();
    List<Punto> _ptoFacilities;
    List<Punto> _ptoClients;
    String layerName;
    Feature.type tipo = null;

    public MapFrameGenetic() {
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        tileFactory.setThreadPoolSize(50);
        File cacheDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".jxmapviewer2");
        LocalResponseCache.installResponseCache((String)info.getBaseURL(), (File)cacheDir, (boolean)false);
        this.jXMapKit = new JXMapKit();
        this.jXMapKit.setTileFactory((TileFactory)tileFactory);
        GeoPosition deportes = new GeoPosition(36.715503, -4.480589);
        this.jXMapKit.setZoom(3);
        this.jXMapKit.setAddressLocation(deportes);
        this.jXMapKit.setAddressLocationShown(false);
        this.mapViewer = this.jXMapKit.getMainMap();
    }

    public void addWaypoint(GeoPosition ptoAdd) {
        this.listaWayPoints.add((Waypoint)new DefaultWaypoint(ptoAdd));
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setWaypoints(this.listaWayPoints);
        ArrayList<WaypointPainter> painters = new ArrayList<WaypointPainter>();
        painters.add(waypointPainter);
        CompoundPainter painter = new CompoundPainter(painters);
        this.mapViewer.setOverlayPainter((Painter)painter);
    }

    public void displaySolution(boolean[] solutions) {
        this.clear();
        Color[] clientsColor = new Color[this._ptoClients.size()];
        int i = 0;
        while (i < this._ptoClients.size()) {
            clientsColor[i] = Color.CYAN;
            ++i;
        }
        Color[] facilitiesColor = new Color[this._ptoFacilities.size()];
        int i2 = 0;
        while (i2 < this._ptoFacilities.size()) {
            facilitiesColor[i2] = solutions[i2] ? Color.GREEN : Color.WHITE;
            ++i2;
        }
        this.displayWaypoints(facilitiesColor, clientsColor);
    }

    public void displayClientsandFacilities(List<Punto> ptoFacilities, List<Punto> ptoClients) {
        this._ptoFacilities = ptoFacilities;
        this._ptoClients = ptoClients;
        Color[] clientsColor = new Color[this._ptoClients.size()];
        int i = 0;
        while (i < this._ptoClients.size()) {
            clientsColor[i] = Color.CYAN;
            ++i;
        }
        Color[] facilitiesColor = new Color[this._ptoFacilities.size()];
        int i2 = 0;
        while (i2 < this._ptoFacilities.size()) {
            facilitiesColor[i2] = Color.WHITE;
            ++i2;
        }
        this.displayWaypoints(facilitiesColor, clientsColor);
    }

    public void displayWaypoints(Color[] facilitiesColor, Color[] clientsColor) {
        ArrayList<GeoPosition> track = new ArrayList<GeoPosition>();
        this.listaWayPoints = new HashSet<Waypoint>();
        int index = 0;
        for (Punto p : this._ptoFacilities) {
            this.listaWayPoints.add((Waypoint)new CustomWayPoint("F" + index, facilitiesColor[index], p.getLatitude(), p.getLongitude()));
            track.add(new GeoPosition(p.getLatitude(), p.getLongitude()));
            ++index;
        }
        index = 0;
        for (Punto p : this._ptoClients) {
            this.listaWayPoints.add((Waypoint)new CustomWayPoint("C" + index, clientsColor[index], p.getLatitude(), p.getLongitude()));
            track.add(new GeoPosition(p.getLatitude(), p.getLongitude()));
            ++index;
        }
        this.showWaypoints(track, this.listaWayPoints);
    }

    private void showWaypoints(List<GeoPosition> track, Set<Waypoint> listaWayPoints) {
        this.mapViewer.zoomToBestFit(new HashSet<GeoPosition>(track), 0.7);
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setRenderer((WaypointRenderer)new FancyWaypointRenderer());
        waypointPainter.setWaypoints(listaWayPoints);
        ArrayList<WaypointPainter> painters = new ArrayList<WaypointPainter>();
        painters.add(waypointPainter);
        CompoundPainter painter = new CompoundPainter(painters);
        this.mapViewer.setOverlayPainter((Painter)painter);
    }

    public void clear() {
        this.mapViewer.setOverlayPainter(null);
    }

    public JXMapKit getMap() {
        return this.jXMapKit;
    }
}

