/*
 * Decompiled with CFR 0.152.
 */
package UFLP;

import ClientFerature.NetworkManager;
import GeneticAlgorithm.Genetico;
import GeneticAlgorithm.Individual;
import GeneticAlgorithm.Problem;
import MapFrame.Layer;
import MapFrame.Punto;
import UFLP.MapFrameGenetic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class UFLPWindow
extends JDialog
implements ActionListener {
    private final String Evaluation = "Find a Solution";
    private final String Cost = "Calculate Cost";
    List<Layer> _layers;
    HashMap _layerPoints;
    NetworkManager _network;
    JComboBox FacilitiesCbox;
    JComboBox ClientsCbox;
    DefaultTableModel tableFixedCostModel;
    DefaultTableModel tableTransportationCostModel;
    DefaultTableModel tableFacilitiesSolModel;
    DefaultTableModel tableClientSolModel;
    JButton EvaluationButton;
    JButton CalculateCostButton;
    MapFrameGenetic map;
    JLabel CostValue;

    public UFLPWindow(JFrame frame, NetworkManager network, List<Layer> layers) {
        super(frame, "UFLP evaluation", true);
        this._network = network;
        this._layers = layers;
        this._layerPoints = new HashMap();
        this.setLocation(100, 100);
        this.setLayout(null);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(750, 600));
        this.map = new MapFrameGenetic();
        this.map.getMap();
        this.add((Component)this.map.getMap());
        this.map.getMap().setBounds(10, 10, 530, 270);
        JLabel FixedCostS = new JLabel("FIXED COST:");
        FixedCostS.setFont(new Font("ARIAL", 1, 16));
        FixedCostS.setForeground(Color.GRAY);
        FixedCostS.setBounds(10, 285, 130, 25);
        this.add(FixedCostS);
        JLabel TransCostS = new JLabel("TRANSPORTATION COST:");
        TransCostS.setFont(new Font("ARIAL", 1, 16));
        TransCostS.setForeground(Color.GRAY);
        TransCostS.setBounds(120, 285, 260, 25);
        this.add(TransCostS);
        JLabel CostS = new JLabel("SOLUTION COST: ");
        CostS.setFont(new Font("ARIAL", 1, 14));
        CostS.setForeground(Color.GRAY);
        CostS.setBounds(520, 530, 130, 25);
        this.add(CostS);
        this.CostValue = new JLabel("0");
        this.CostValue.setFont(new Font("ARIAL", 1, 14));
        this.CostValue.setForeground(Color.BLUE);
        this.CostValue.setBounds(650, 530, 130, 25);
        this.add(this.CostValue);
        Object[][] dataLayer = this.getLayers(this._layers);
        Object[] tableLayercolumnNames = new String[]{"Layer", "Npuntos"};
        JTable tableLayer = new JTable(dataLayer, tableLayercolumnNames);
        tableLayer.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPaneLayer = new JScrollPane(tableLayer);
        this.getContentPane().add((Component)scrollPaneLayer, "Center");
        scrollPaneLayer.setBounds(560, 15, 170, 200);
        this.add(scrollPaneLayer);
        this.pack();
        JLabel Facilities = new JLabel("Facilities: ");
        Facilities.setForeground(Color.GRAY);
        Facilities.setBounds(560, 220, 150, 25);
        this.add(Facilities);
        String[] FacilitiesSandClients = this.getLayersComboBox(this._layers);
        this.FacilitiesCbox = new JComboBox<String>(FacilitiesSandClients);
        this.FacilitiesCbox.addActionListener(this);
        this.FacilitiesCbox.setBounds(560, 240, 60, 25);
        this.add(this.FacilitiesCbox);
        JLabel Clients = new JLabel("Clients: ");
        Clients.setForeground(Color.GRAY);
        Clients.setBounds(670, 220, 150, 25);
        this.add(Clients);
        this.ClientsCbox = new JComboBox<String>(FacilitiesSandClients);
        this.ClientsCbox.addActionListener(this);
        this.ClientsCbox.setBounds(670, 240, 60, 25);
        this.add(this.ClientsCbox);
        this.CalculateCostButton = new JButton("Calculate Cost");
        this.CalculateCostButton.setBounds(70, 530, 150, 25);
        this.CalculateCostButton.addActionListener(this);
        this.add(this.CalculateCostButton);
        this.tableFixedCostModel = new DefaultTableModel();
        this.tableFixedCostModel.addColumn("Facility");
        this.tableFixedCostModel.addColumn("Costs");
        JTable tableFixedCost = new JTable(this.tableFixedCostModel);
        tableFixedCost.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPaneFixedCost = new JScrollPane(tableFixedCost);
        this.getContentPane().add((Component)scrollPaneFixedCost, "Center");
        scrollPaneFixedCost.setBounds(10, 315, 100, 200);
        this.add(scrollPaneFixedCost);
        this.pack();
        this.tableTransportationCostModel = new DefaultTableModel();
        JTable tableTransportationCost = new JTable(this.tableTransportationCostModel);
        tableTransportationCost.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPaneTransportationCost = new JScrollPane(tableTransportationCost);
        this.getContentPane().add((Component)scrollPaneTransportationCost, "Center");
        scrollPaneTransportationCost.setBounds(120, 315, 390, 200);
        this.add(scrollPaneTransportationCost);
        this.pack();
        JLabel SolutionS = new JLabel("SOLUTION:");
        SolutionS.setFont(new Font("ARIAL", 1, 16));
        SolutionS.setForeground(Color.GRAY);
        SolutionS.setBounds(520, 285, 260, 25);
        this.add(SolutionS);
        this.tableClientSolModel = new DefaultTableModel();
        this.tableClientSolModel.addColumn("Facility");
        this.tableClientSolModel.addColumn("Open");
        JTable tableClientSol = new JTable(this.tableClientSolModel);
        tableTransportationCost.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPanetableClientSolModel = new JScrollPane(tableClientSol);
        this.getContentPane().add((Component)scrollPanetableClientSolModel, "Center");
        scrollPanetableClientSolModel.setBounds(520, 315, 100, 200);
        this.add(scrollPanetableClientSolModel);
        this.pack();
        this.tableFacilitiesSolModel = new DefaultTableModel();
        this.tableFacilitiesSolModel.addColumn("Client");
        this.tableFacilitiesSolModel.addColumn("Facility");
        JTable tableFacilitytSol = new JTable(this.tableFacilitiesSolModel);
        tableFacilitytSol.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPanetableFacilitySolModel = new JScrollPane(tableFacilitytSol);
        this.getContentPane().add((Component)scrollPanetableFacilitySolModel, "Center");
        scrollPanetableFacilitySolModel.setBounds(630, 315, 100, 200);
        this.add(scrollPanetableFacilitySolModel);
        this.pack();
        this.EvaluationButton = new JButton("Find a Solution");
        this.EvaluationButton.setBounds(280, 530, 140, 25);
        this.EvaluationButton.addActionListener(this);
        this.EvaluationButton.setEnabled(false);
        this.add(this.EvaluationButton);
    }

    public void showWindow() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Find a Solution")) {
            this.Evaluation();
        } else if (cmd.equals("Calculate Cost")) {
            this.Cost();
        }
    }

    private void Evaluation() {
        int facilities = this.tableFixedCostModel.getRowCount();
        double[] fixed_costs = new double[facilities];
        int index = 0;
        while (index < facilities) {
            String temp = (String)this.tableFixedCostModel.getValueAt(index, 1);
            fixed_costs[index] = temp.length() == 0 ? 0.0 : Double.parseDouble(temp);
            ++index;
        }
        int clients = this.tableTransportationCostModel.getRowCount();
        double[][] transport_cost = new double[clients][facilities];
        int indexClients = 0;
        while (indexClients < clients) {
            int indexnFacilities = 0;
            while (indexnFacilities < facilities) {
                Double temp = (Double)this.tableTransportationCostModel.getValueAt(indexClients, indexnFacilities + 1);
                transport_cost[indexClients][indexnFacilities] = temp;
                ++indexnFacilities;
            }
            ++indexClients;
        }
        Problem problemCurrent = new Problem(facilities, clients);
        problemCurrent.setFixedCost(fixed_costs);
        problemCurrent.setTransportCost(transport_cost);
        int _poblacion = facilities * 2;
        int _generaciones = clients * 100;
        Genetico genProblemBasic = new Genetico(_poblacion, _generaciones, problemCurrent);
        genProblemBasic.run();
        Individual sol = genProblemBasic.getSolution();
        long timeConsumed = genProblemBasic.getTimeConsumed();
        List<Double> fitnessHistory = genProblemBasic.getHistoryFitness();
        int generationCountSol = genProblemBasic.getGenerationCount();
        problemCurrent.setGeneticParams(_poblacion, _generaciones);
        problemCurrent.setFindSolution(sol);
        problemCurrent.setTimeConsumed(timeConsumed);
        problemCurrent.setHisttoryFitness(fitnessHistory);
        problemCurrent.setHisttoryFitnessEliStd(genProblemBasic.getHistorySTDFitness());
        problemCurrent.setGenerationCount(generationCountSol);
        problemCurrent.printSolution(true);
        boolean[] solution = genProblemBasic.getSolutionVector();
        this.map.displaySolution(solution);
        int i = 0;
        while (i < solution.length) {
            this.tableClientSolModel.setValueAt(solution[i], i, 1);
            ++i;
        }
        int[] asign = problemCurrent.clientAsign();
        int i2 = 0;
        while (i2 < asign.length) {
            this.tableFacilitiesSolModel.setValueAt("F" + asign[i2], i2, 1);
            ++i2;
        }
        this.CostValue.setText("" + fitnessHistory.get(generationCountSol));
    }

    private void Cost() {
        int facilities;
        int clients = this.ClientsCbox.getSelectedIndex();
        if (clients == (facilities = this.FacilitiesCbox.getSelectedIndex())) {
            this.Error("Clients and Facilities can not be the same selection");
        } else {
            String facilitiesLayer = this._layers.get(facilities).getName();
            String clientsLayer = this._layers.get(clients).getName();
            this.clearTable(this.tableFixedCostModel);
            this.clearTable(this.tableTransportationCostModel);
            this.tableTransportationCostModel.setColumnCount(0);
            this.tableTransportationCostModel.addColumn("Clients");
            List ptosFacilities = (List)this._layerPoints.get(facilitiesLayer);
            int index = 0;
            while (index < ptosFacilities.size()) {
                Punto pto = (Punto)ptosFacilities.get(index);
                Random random = new Random();
                this.tableTransportationCostModel.addColumn("F" + index);
                this.tableFixedCostModel.addRow(new Object[]{"F" + index, "" + random.nextInt(1000)});
                ++index;
            }
            List ptosClients = (List)this._layerPoints.get(clientsLayer);
            this.map.displayClientsandFacilities(ptosFacilities, ptosClients);
            double[][] distancePtos = new double[ptosClients.size()][ptosFacilities.size()];
            int indexClients = 0;
            while (indexClients < ptosClients.size()) {
                int indexFacilities = 0;
                while (indexFacilities < ptosFacilities.size()) {
                    distancePtos[indexClients][indexFacilities] = ((Punto)ptosClients.get(indexClients)).distance((Punto)ptosFacilities.get(indexFacilities));
                    ++indexFacilities;
                }
                ++indexClients;
            }
            indexClients = 0;
            while (indexClients < ptosClients.size()) {
                Object[] rowX = new Object[ptosFacilities.size() + 1];
                rowX[0] = "C" + indexClients;
                int indexFacilities = 0;
                while (indexFacilities < ptosFacilities.size()) {
                    rowX[indexFacilities + 1] = distancePtos[indexClients][indexFacilities];
                    ++indexFacilities;
                }
                this.tableTransportationCostModel.addRow(rowX);
                ++indexClients;
            }
            this.clearTable(this.tableClientSolModel);
            this.tableClientSolModel.setColumnCount(0);
            this.tableClientSolModel.addColumn("Clients");
            this.tableClientSolModel.addColumn("Open");
            int index2 = 0;
            while (index2 < ptosFacilities.size()) {
                this.tableClientSolModel.addRow(new Object[]{"F" + index2, "false"});
                ++index2;
            }
            this.clearTable(this.tableFacilitiesSolModel);
            this.tableFacilitiesSolModel.setColumnCount(0);
            this.tableFacilitiesSolModel.addColumn("Clients");
            this.tableFacilitiesSolModel.addColumn("Facility");
            index2 = 0;
            while (index2 < ptosClients.size()) {
                this.tableFacilitiesSolModel.addRow(new Object[]{"C" + index2, "?"});
                ++index2;
            }
            this.EvaluationButton.setEnabled(true);
        }
    }

    private void Error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Configuration Error", 0);
    }

    private Object[][] getLayers(List<Layer> layers) {
        Object[][] ret = new Object[layers.size()][2];
        int i = 0;
        while (i < layers.size()) {
            ret[i][0] = layers.get(i).getName();
            ret[i][1] = layers.get(i).getNelements();
            ++i;
        }
        return ret;
    }

    private String[] getLayersComboBox(List<Layer> layers) {
        String[] ret = new String[layers.size()];
        int i = 0;
        while (i < layers.size()) {
            ret[i] = "" + i;
            ++i;
        }
        return ret;
    }

    public void receiveDatos(String name, List<Punto> ptos) {
        this._layerPoints.put(name, ptos);
    }

    public void requestLayerPoints() {
        int i = 0;
        while (i < this._layers.size()) {
            this._network.sendLayer(this._layers.get(i).getName(), this._layers.get(i).getTipo());
            ++i;
        }
    }

    public void clearTable(DefaultTableModel mode) {
        mode.getDataVector().removeAllElements();
        this.revalidate();
    }
}

