/*
 * Decompiled with CFR 0.152.
 */
package GeoServer;

import GeoServer.Zip;
import MapFrame.Feature;
import MapFrame.Poly;
import MapFrame.Punto;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PublishGeoserver {
    String layerName;
    String OUTPUT_SHAPE;
    String OUTPUT_SHAP_FILE;
    String OUTPUT_ZIP_FILE;
    String SOURCE_FOLDER;
    String RESTURL;
    String RESTUSER;
    String RESTPW;
    String workspace;
    String storename;
    GeoServerRESTReader reader;
    GeoServerRESTPublisher publisher;
    Zip zippedShapefile;

    public PublishGeoserver(String ServerURL, int port, String user, String pwd) {
        this.OUTPUT_SHAPE = this.layerName = "bancos";
        this.OUTPUT_SHAP_FILE = String.valueOf(this.OUTPUT_SHAPE) + ".shp";
        this.OUTPUT_ZIP_FILE = String.valueOf(this.OUTPUT_SHAPE) + ".zip";
        this.SOURCE_FOLDER = "Zip";
        this.RESTURL = "http://127.0.0.1:8080/geoserver";
        this.RESTUSER = "admin";
        this.RESTPW = "1qaz2wsx";
        this.workspace = "ws1";
        this.storename = "ResourceServer";
        this.reader = null;
        this.publisher = null;
        this.RESTURL = "http://" + ServerURL + ":" + port + "/geoserver";
        this.RESTUSER = user;
        this.RESTPW = pwd;
    }

    public boolean connect() {
        try {
            this.reader = new GeoServerRESTReader(this.RESTURL, this.RESTUSER, this.RESTPW);
        }
        catch (Exception e) {
            return false;
        }
        this.publisher = new GeoServerRESTPublisher(this.RESTURL, this.RESTUSER, this.RESTPW);
        boolean serverRunning = true;
        serverRunning = this.reader.existGeoserver();
        return serverRunning;
    }

    public boolean checkWorkspace() {
        return this.checkWorkspace(this.workspace);
    }

    private void setNames(String layerName) {
        this.storename = layerName;
        this.OUTPUT_SHAPE = layerName;
        this.OUTPUT_SHAP_FILE = String.valueOf(this.OUTPUT_SHAPE) + ".shp";
        this.OUTPUT_ZIP_FILE = String.valueOf(this.OUTPUT_SHAPE) + ".zip";
    }

    public boolean checkWorkspace(String workspaceP) {
        this.workspace = workspaceP;
        boolean workSpace = true;
        workSpace = this.reader.existsWorkspace(this.workspace);
        if (workSpace) {
            System.out.format("WorkSpace %s est\u00e1.", this.workspace);
        } else {
            System.out.format("WorkSpace %s no est\u00e1.", this.workspace);
            workSpace = this.publisher.createWorkspace(this.workspace);
            if (workSpace) {
                System.out.format("WorkSpace %s creado.", this.workspace);
            } else {
                System.out.format("WorkSpace %s no creado.", this.workspace);
            }
        }
        return workSpace;
    }

    public boolean publish() throws IOException {
        File zipFile = new File(this.OUTPUT_ZIP_FILE);
        boolean published = false;
        try {
            this.publisher.removeDatastore(this.workspace, this.storename, true);
            published = this.publisher.publishShp(this.workspace, this.storename, this.layerName, zipFile, "EPSG:4326", new NameValuePair[]{new NameValuePair("charset", "UTF-8")});
        }
        catch (Exception e) {
            return false;
        }
        this.zippedShapefile.deleteZip();
        return published;
    }

    private void checkDirectory() {
        File theDir = new File(this.SOURCE_FOLDER);
        if (!theDir.exists()) {
            System.out.println("creating directory: " + this.SOURCE_FOLDER);
            boolean result = false;
            try {
                theDir.mkdir();
                result = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (result) {
                System.out.println("DIR created");
            }
        } else {
            System.out.println("DIR exists " + this.SOURCE_FOLDER);
        }
    }

    public void shapefilePtos(String layerNameP, List<Punto> ptos) throws SchemaException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.layerName = layerNameP;
        this.setNames(layerNameP);
        this.checkDirectory();
        SimpleFeatureType TYPE = DataUtilities.createType((String)"Location", (String)"the_geom:Point:srid=4326,");
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        for (Punto puntos : ptos) {
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
            featureBuilder.add((Object)geometryFactory.createPoint(new Coordinate(puntos.getLongitude(), puntos.getLatitude())));
            SimpleFeature feature = featureBuilder.buildFeature(null);
            features.add(feature);
        }
        File newFile = new File(String.valueOf(this.SOURCE_FOLDER) + "//" + this.OUTPUT_SHAP_FILE);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", newFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(TYPE);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        newDataStore.forceSchemaCRS(crs);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        SimpleFeatureType SHAPE_TYPE = (SimpleFeatureType)featureSource.getSchema();
        System.out.println("SHAPE:" + SHAPE_TYPE);
        if (featureSource instanceof SimpleFeatureStore) {
            block8: {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                ListFeatureCollection collection = new ListFeatureCollection(TYPE, features);
                featureStore.setTransaction((Transaction)transaction);
                try {
                    try {
                        featureStore.addFeatures((FeatureCollection)collection);
                        transaction.commit();
                    }
                    catch (Exception problem) {
                        problem.printStackTrace();
                        transaction.rollback();
                        transaction.close();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    transaction.close();
                    throw throwable;
                }
                transaction.close();
            }
            this.zippedShapefile = new Zip(this.SOURCE_FOLDER, this.OUTPUT_ZIP_FILE);
            this.zippedShapefile.Zipit();
        } else {
            System.out.println(String.valueOf(typeName) + " does not support read/write access");
        }
    }

    public void shapefileLines(String layerNameP, List<Poly> polys, Feature.type tipo) throws SchemaException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.layerName = layerNameP;
        this.setNames(layerNameP);
        this.checkDirectory();
        SimpleFeatureType TYPE_LINE = tipo == Feature.type.LineString ? DataUtilities.createType((String)"Location", (String)"the_geom:LineString:srid=4326,") : DataUtilities.createType((String)"Location", (String)"the_geom:Polygon:srid=4326,");
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (Poly poly : polys) {
            List<Punto> ptos = poly.getPtos();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE_LINE);
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            Coordinate[] coord = new Coordinate[ptos.size()];
            int i = 0;
            while (i < ptos.size()) {
                coord[i] = new Coordinate(ptos.get(i).getLongitude(), ptos.get(i).getLatitude());
                ++i;
            }
            LineString line = geometryFactory.createLineString(coord);
            featureBuilder.add((Object)line);
            SimpleFeature feature = featureBuilder.buildFeature(null);
            features.add(feature);
        }
        File newFile = new File(String.valueOf(this.SOURCE_FOLDER) + "//" + this.OUTPUT_SHAP_FILE);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", newFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(TYPE_LINE);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        newDataStore.forceSchemaCRS(crs);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        SimpleFeatureType SHAPE_TYPE = (SimpleFeatureType)featureSource.getSchema();
        System.out.println("SHAPE:" + SHAPE_TYPE);
        if (featureSource instanceof SimpleFeatureStore) {
            block9: {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                ListFeatureCollection collection = new ListFeatureCollection(TYPE_LINE, features);
                featureStore.setTransaction((Transaction)transaction);
                try {
                    try {
                        featureStore.addFeatures((FeatureCollection)collection);
                        transaction.commit();
                    }
                    catch (Exception problem) {
                        problem.printStackTrace();
                        transaction.rollback();
                        transaction.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    transaction.close();
                    throw throwable;
                }
                transaction.close();
            }
            this.zippedShapefile = new Zip(this.SOURCE_FOLDER, this.OUTPUT_ZIP_FILE);
            this.zippedShapefile.Zipit();
        } else {
            System.out.println(String.valueOf(typeName) + " does not support read/write access");
        }
    }

    public static void main(String[] args) throws IOException, SchemaException, NoSuchAuthorityCodeException, FactoryException {
    }
}

