/*
 * Decompiled with CFR 0.152.
 */
package OSM;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.painter.Painter;

public class LinePainter
implements Painter<JXMapViewer> {
    private Color color = Color.RED;
    private boolean antiAlias = true;
    private boolean line = false;
    private List<GeoPosition> track;

    public LinePainter(List<GeoPosition> track) {
        this.track = new ArrayList<GeoPosition>(track);
    }

    public void setLine(boolean lineDraw) {
        this.line = lineDraw;
    }

    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(4.0f));
        this.drawRoute(g, map);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(2.0f));
        this.drawRoute(g, map);
        g.dispose();
    }

    private void drawRoute(Graphics2D g, JXMapViewer map) {
        int lastX = 0;
        int lastY = 0;
        boolean first = true;
        for (GeoPosition gp : this.track) {
            Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
            if (first) {
                first = false;
            } else {
                g.drawOval(lastX - 2, lastY - 2, 4, 4);
                g.drawOval((int)pt.getX() - 2, (int)pt.getY() - 2, 4, 4);
                g.drawLine(lastX, lastY, (int)pt.getX(), (int)pt.getY());
                if (this.line) {
                    first = true;
                }
            }
            lastX = (int)pt.getX();
            lastY = (int)pt.getY();
        }
    }

    public GeoPosition getIni() {
        return this.track.get(0);
    }

    public List<GeoPosition> getPtos() {
        return this.track;
    }

    public int getNumPtos() {
        return this.track.size();
    }
}

