/*
 * Decompiled with CFR 0.152.
 */
package Server;

import MapFrame.Feature;
import MapFrame.Layer;
import MapFrame.Poly;
import MapFrame.Punto;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class GeoDatabase {
    private Connection con = null;
    private String urlUsers = "jdbc:derby://localhost:1527/layer;create=true";
    private String urlUsersLocal = "jdbc:derby:layer;create=true";

    public GeoDatabase() {
        Properties p = System.getProperties();
        p.put("derby.storage.fileSyncTransactionLog", "true");
    }

    public boolean connect() {
        Boolean op = true;
        try {
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            this.con = DriverManager.getConnection(this.urlUsers, "monte", "1qaz2wsx");
        }
        catch (Exception e) {
            System.out.println("BASE DATOS LOCAL: " + e.getMessage());
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                this.con = DriverManager.getConnection(this.urlUsersLocal, "monte", "1qaz2wsx");
            }
            catch (Exception ex) {
                System.err.println("SQLException: " + e.getMessage());
                op = false;
            }
        }
        return op;
    }

    public boolean deleteTables() {
        String createString = "DROP TABLE users";
        Boolean op0 = this.updateSQL(createString);
        createString = "DROP TABLE layers";
        Boolean op1 = this.updateSQL(createString);
        createString = "DROP TABLE waypoints";
        Boolean op2 = this.updateSQL(createString);
        createString = "DROP TABLE poly";
        Boolean op3 = this.updateSQL(createString);
        createString = "DROP TABLE points";
        Boolean op4 = this.updateSQL(createString);
        return op0 & op1 & op2 & op3 & op4;
    }

    public boolean createTables() {
        boolean op1 = this.createTableUsers();
        boolean op2 = this.createTableLayers();
        return op1 & op2;
    }

    public boolean createTableLayers() {
        boolean op1 = true;
        boolean op2 = true;
        boolean op3 = true;
        boolean op4 = true;
        String createString = "CREATE TABLE  layers (id VARCHAR(100) NOT NULL PRIMARY KEY, type  int, nelements INTEGER)";
        op1 = this.updateSQL(createString);
        createString = "CREATE TABLE  waypoints (layer VARCHAR(100), latitude DOUBLE PRECISION, longitude DOUBLE PRECISION)";
        op2 = this.updateSQL(createString);
        createString = "CREATE TABLE  poly (layer  VARCHAR(100), idpoints BIGINT, nelements INTEGER)";
        op3 = this.updateSQL(createString);
        createString = "CREATE TABLE  points (idpoints BIGINT, latitude DOUBLE PRECISION, longitude DOUBLE PRECISION, posicion INTEGER)";
        op4 = this.updateSQL(createString);
        return op1 & op2 & op3 & op4;
    }

    public boolean createTableUsers() {
        boolean op = true;
        String createString = "CREATE TABLE  users(id VARCHAR(10) NOT NULL PRIMARY KEY, passwd  VARCHAR(512), online INT)";
        op = this.updateSQL(createString);
        return op;
    }

    public boolean deleteLayer(String layerName, Feature.type tipo) {
        String createString;
        boolean op1 = true;
        boolean op2 = true;
        if (tipo == Feature.type.Point) {
            createString = "DELETE FROM waypoints WHERE layer='" + layerName + "'";
            op1 = this.updateSQL(createString);
        } else {
            List<Long> ids = this.getIDPolys(layerName);
            for (Long id : ids) {
                createString = "DELETE FROM points WHERE idpoints=" + id;
                op2 &= this.updateSQL(createString);
            }
            createString = "DELETE FROM poly WHERE layer='" + layerName + "'";
            op1 = this.updateSQL(createString);
        }
        createString = "DELETE FROM layers WHERE id='" + layerName + "'";
        boolean op3 = this.updateSQL(createString);
        return op1 & op2 & op3;
    }

    public boolean deletePto(String layer, double latitude, double longitude) {
        int num = this.getNumElements(layer) - 1;
        String createString = "UPDATE layers SET nelements=" + num + " WHERE id='" + layer + "'";
        this.updateSQL(createString);
        createString = "DELETE FROM waypoints WHERE layer='" + layer + "' AND latitude=" + latitude + " AND longitude=" + longitude;
        return this.updateSQL(createString);
    }

    public boolean deleteLine(String layer, Poly pto) {
        long idpoints = pto.getID();
        String sentenceSQL = "DELETE FROM points WHERE idpoints=" + idpoints;
        boolean op1 = this.updateSQL(sentenceSQL);
        int num = this.getNumElements(layer);
        sentenceSQL = "UPDATE layers SET nelements=" + --num + " WHERE id='" + layer + "'";
        boolean op2 = this.updateSQL(sentenceSQL);
        sentenceSQL = "DELETE FROM poly WHERE idpoints=" + idpoints;
        boolean op3 = this.updateSQL(sentenceSQL);
        return op1 & op2 & op3;
    }

    public boolean insertLayer_(String Id, int type2) {
        String createString = "INSERT INTO layers VALUES('" + Id + "'," + type2 + ",0)";
        return this.updateSQL(createString);
    }

    public boolean insertPto_(String layer, double latitude, double longitude) {
        return this.insertPto_(layer, new Punto(latitude, longitude));
    }

    public boolean insertPtos_(String layer, List<Punto> pts) {
        String createString;
        int nelements = this.getNumElements(layer);
        int sizePtos = pts.size();
        int num = nelements + sizePtos;
        boolean op1 = false;
        int i = 0;
        while (i < sizePtos) {
            createString = "INSERT INTO waypoints VALUES('" + layer + "'," + pts.get(i).getLatitude() + "," + pts.get(i).getLongitude() + ")";
            op1 = this.updateSQL(createString);
            ++i;
        }
        createString = "UPDATE layers SET nelements=" + num + " WHERE id='" + layer + "'";
        boolean op2 = this.updateSQL(createString);
        return op1 & op2;
    }

    public boolean insertPto_(String layer, Punto pts) {
        int nelements = this.getNumElements(layer);
        int num = nelements + 1;
        String createString = "INSERT INTO waypoints VALUES('" + layer + "'," + pts.getLatitude() + "," + pts.getLongitude() + ")";
        boolean op1 = this.updateSQL(createString);
        createString = "UPDATE layers SET nelements=" + num + " WHERE id='" + layer + "'";
        boolean op2 = this.updateSQL(createString);
        return op1 & op2;
    }

    public boolean insertLine(String layer, List<GeoPosition> ptos) {
        boolean op2 = true;
        long time = System.currentTimeMillis();
        int num = this.getNumElements(layer) + 1;
        int ptosSize = ptos.size();
        String createString = "INSERT INTO poly VALUES('" + layer + "'," + time + "," + ptosSize + ")";
        boolean op1 = this.updateSQL(createString);
        int index = 0;
        for (GeoPosition pto : ptos) {
            createString = "INSERT INTO points VALUES(" + time + "," + pto.getLatitude() + "," + pto.getLongitude() + "," + index + ")";
            op2 &= this.updateSQL(createString);
            ++index;
        }
        createString = "UPDATE layers SET nelements=" + num + " WHERE id='" + layer + "'";
        boolean op3 = this.updateSQL(createString);
        return op1 & op2 & op3;
    }

    private boolean updateSQL(String createString) {
        boolean estado = true;
        try {
            Statement stmt = this.con.createStatement();
            stmt.executeUpdate(createString);
            stmt.close();
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 30000) {
                return true;
            }
            System.err.println("SQLException: " + ex.getMessage() + "cc " + ex.getErrorCode());
            estado = false;
        }
        return estado;
    }

    public int getNumElements(String layer) {
        int numelements = 0;
        try {
            Statement stmt = this.con.createStatement();
            String createString = "select nelements from layers where id='" + layer + "'";
            ResultSet rs = stmt.executeQuery(createString);
            if (rs.next()) {
                numelements = rs.getInt("nelements");
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException login: " + ex.getMessage());
        }
        return numelements;
    }

    public List<Long> getIDPolys(String layer) {
        ArrayList<Long> listaID = new ArrayList<Long>();
        try {
            Statement stmt = this.con.createStatement();
            String createString = "select idpoints from poly where layer='" + layer + "'";
            ResultSet rs = stmt.executeQuery(createString);
            while (rs.next()) {
                Long idpoints = rs.getLong("idpoints");
                listaID.add(idpoints);
            }
        }
        catch (SQLException ex) {
            System.err.println("SQLException login: " + ex.getMessage());
        }
        return listaID;
    }

    public List<Punto> getPtos(String layer) {
        ArrayList<Punto> ptos = new ArrayList<Punto>();
        try {
            Statement stmt = this.con.createStatement();
            String createString = "select latitude,longitude from waypoints where layer='" + layer + "'";
            ResultSet rs = stmt.executeQuery(createString);
            while (rs.next()) {
                double latitude = rs.getDouble("latitude");
                double longitude = rs.getDouble("longitude");
                ptos.add(new Punto(latitude, longitude));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException login: " + ex.getMessage());
        }
        return ptos;
    }

    public List<Punto> getPtosfromPoly(long idpoints) {
        ArrayList<Punto> point = new ArrayList<Punto>();
        try {
            Statement stmt = this.con.createStatement();
            String createString = "SELECT latitude, longitude, posicion from points where idpoints=" + idpoints;
            ResultSet rs = stmt.executeQuery(createString);
            while (rs.next()) {
                double latitude = rs.getDouble("latitude");
                double longitude = rs.getDouble("longitude");
                int posicion = rs.getInt("posicion");
                point.add(posicion, new Punto(latitude, longitude));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException login: " + ex.getMessage());
        }
        return point;
    }

    public List<Poly> getLines(String layer) {
        ArrayList<Poly> polys = new ArrayList<Poly>();
        try {
            Statement stmt = this.con.createStatement();
            String createString = "select idpoints, nelements from poly where layer='" + layer + "'";
            ResultSet rs = stmt.executeQuery(createString);
            while (rs.next()) {
                long idpoints = rs.getLong("idpoints");
                int nelements = rs.getInt("nelements");
                Poly polyFeature = new Poly(idpoints, nelements);
                polyFeature.setPtos(this.getPtosfromPoly(idpoints));
                polys.add(polyFeature);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException login: " + ex.getMessage());
        }
        return polys;
    }

    public List<Layer> getLayers() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        String createString = "select * from layers";
        ResultSet rs = this.consul(createString);
        try {
            while (rs.next()) {
                String layer = rs.getString("id");
                int type2 = rs.getInt("type");
                int nelements = rs.getInt("nelements");
                layers.add(new Layer(layer, type2, nelements));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return layers;
    }

    public int isAuthenticated(String user, String pwd) {
        int authenticatedB = 0;
        String DBpwd = null;
        int online = -1;
        try {
            Statement stmt = this.con.createStatement();
            String createString = "select passwd,online from users where id='" + user + "'";
            ResultSet rs = stmt.executeQuery(createString);
            while (rs.next()) {
                DBpwd = rs.getString("passwd");
                online = rs.getInt("online");
            }
            if (online == 1) {
                authenticatedB = -1;
            } else if (DBpwd != null && DBpwd.contentEquals(pwd)) {
                authenticatedB = 1;
            }
            rs.close();
            stmt.close();
            if (authenticatedB == 1) {
                this.setOnline(true, user);
            }
        }
        catch (SQLException ex) {
            System.err.println("SQLException login: " + ex.getMessage());
        }
        return authenticatedB;
    }

    public boolean setOnline(boolean online, String user) {
        String createString = online ? "UPDATE users SET online=1  WHERE id='" + user + "'" : "UPDATE users SET online=0  WHERE id='" + user + "'";
        return this.updateSQL(createString);
    }

    public boolean updatePwd(String user, String pwd) {
        String createString = "UPDATE users SET passwd='" + pwd + "'  WHERE id='" + user + "'";
        return this.updateSQL(createString);
    }

    private ResultSet consul(String consult) {
        ResultSet rs = null;
        try {
            Statement stmt = this.con.createStatement();
            rs = stmt.executeQuery(consult);
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return rs;
    }

    public Hashtable<String, String> getUsers() {
        Hashtable<String, String> users = new Hashtable<String, String>();
        try {
            Statement stmt = this.con.createStatement();
            String createString = "select id,passwd from users";
            ResultSet rs = stmt.executeQuery(createString);
            while (rs.next()) {
                String ID = rs.getString(1);
                String PWD = rs.getString(2);
                users.put(ID, PWD);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            System.err.println(" getUsers SQLException: " + ex.getMessage());
        }
        return users;
    }

    public boolean deleteUser(String Id) {
        String createString = "DELETE FROM users WHERE id='" + Id + "'";
        return this.updateSQL(createString);
    }

    public boolean insertUsers() {
        boolean op = true;
        String key = new String("12");
        String keyC = this.codifPwd(key);
        op = this.insertUser("Admin", keyC);
        int i = 1;
        while (i < 5) {
            op = this.insertUser("User" + i, keyC);
            ++i;
        }
        return op;
    }

    private static String stringHexa(byte[] bytes) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            int parteAlta = (bytes[i] >> 4 & 0xF) << 4;
            int parteBaixa = bytes[i] & 0xF;
            if (parteAlta == 0) {
                s.append('0');
            }
            s.append(Integer.toHexString(parteAlta | parteBaixa));
            ++i;
        }
        return s.toString();
    }

    private String codifPwd(String pwd) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pwd.getBytes());
            return GeoDatabase.stringHexa(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public boolean insertUser(String Id, String Pwd) {
        String createString = "INSERT INTO users VALUES('" + Id + "','" + Pwd + "',0)";
        return this.updateSQL(createString);
    }

    public void closeDatabase() {
        try {
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    protected void Debug() {
        List<Layer> layers = this.getLayers();
        for (Layer layer : layers) {
            System.out.println(layer);
            if (layer.getTipo() == 0) {
                List<Punto> ptos = this.getPtos(layer.getName());
                for (Punto pto : ptos) {
                    System.out.println(pto);
                }
                continue;
            }
            List<Poly> polys = this.getLines(layer.getName());
            System.out.println(polys);
        }
    }

    public static void main(String[] args) {
    }
}

