/*
 * Decompiled with CFR 0.152.
 */
package Server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.geojson.Feature;
import org.geojson.FeatureCollection;
import org.geojson.GeoJsonObject;
import org.geojson.LngLatAlt;
import org.geojson.Point;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class GeoJSON {
    URL url = null;
    int nptos = 0;
    String layer_name;
    List<GeoPosition> ptos = new ArrayList<GeoPosition>();

    public void setURL(String urlS) throws MalformedURLException {
        this.url = new URL(urlS);
    }

    public void readPoints() throws JsonParseException, JsonMappingException, IOException {
        GeoJsonObject object = null;
        ObjectMapper obj = new ObjectMapper();
        obj.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        object = (GeoJsonObject)obj.readValue(this.url, GeoJsonObject.class);
        if (object instanceof FeatureCollection) {
            List features = ((FeatureCollection)object).getFeatures();
            this.nptos = features.size() - 1;
            if (this.nptos > 0) {
                this.layer_name = (String)((Feature)features.get(0)).getProperty("Name");
                if (this.layer_name == null) {
                    this.layer_name = "Unkown";
                }
            }
            int i = 0;
            while (i < this.nptos) {
                LngLatAlt coor;
                GeoJsonObject pto = ((Feature)features.get(i)).getGeometry();
                if (pto instanceof Point && (coor = ((Point)pto).getCoordinates()) != null) {
                    this.ptos.add(new GeoPosition(coor.getLatitude(), coor.getLongitude()));
                }
                ++i;
            }
        }
    }

    public List<GeoPosition> getPoints() {
        return this.ptos;
    }

    public int getnumPoints() {
        return this.nptos;
    }

    public String getLayerName() {
        return this.layer_name;
    }

    public void setLayerName(String layer) {
        this.layer_name = layer;
    }
}

