/*
 * Decompiled with CFR 0.152.
 */
package Server;

import MapFrame.Feature;
import MapFrame.Poly;
import MapFrame.Punto;
import OSM.LinePainter;
import Server.Mediator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.OSMTileFactoryInfo;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.DefaultWaypoint;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.LocalResponseCache;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

public class MapFrame {
    final JXMapKit jXMapKit;
    JXMapViewer mapViewer;
    Set<Waypoint> listaWayPoints = new HashSet<Waypoint>();
    List<Poly> listaPolyView = new ArrayList<Poly>();
    List<GeoPosition> listaLineWay = new ArrayList<GeoPosition>();
    Mediator med;
    String layerName;
    Feature.type tipo = null;

    public MapFrame(Mediator md) {
        this.med = md;
        if (this.med != null) {
            this.med.registerMap(this);
        }
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        tileFactory.setThreadPoolSize(50);
        File cacheDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".jxmapviewer2");
        LocalResponseCache.installResponseCache((String)info.getBaseURL(), (File)cacheDir, (boolean)false);
        this.jXMapKit = new JXMapKit();
        this.jXMapKit.setTileFactory((TileFactory)tileFactory);
        GeoPosition deportes = new GeoPosition(36.715503, -4.480589);
        this.jXMapKit.setZoom(3);
        this.jXMapKit.setAddressLocation(deportes);
        this.jXMapKit.setAddressLocationShown(false);
        this.mapViewer = this.jXMapKit.getMainMap();
        this.jXMapKit.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int zoom = MapFrame.this.mapViewer.getZoom();
                Rectangle rect2 = MapFrame.this.mapViewer.getViewportBounds();
                Point ptoEvent = new Point(me.getX() + rect2.x, me.getY() + rect2.y);
                GeoPosition pto = MapFrame.this.mapViewer.getTileFactory().pixelToGeo((Point2D)ptoEvent, zoom);
                MapFrame.this.med.EventMapa(pto);
            }
        });
    }

    public void addWaypoint(GeoPosition ptoAdd) {
        this.listaWayPoints.add((Waypoint)new DefaultWaypoint(ptoAdd));
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setWaypoints(this.listaWayPoints);
        ArrayList<WaypointPainter> painters = new ArrayList<WaypointPainter>();
        painters.add(waypointPainter);
        CompoundPainter painter = new CompoundPainter(painters);
        this.mapViewer.setOverlayPainter((Painter)painter);
        this.med.addWayPoint(this.layerName, ptoAdd);
    }

    public void displayWaypoint(List<Punto> ptoAdd) {
        ArrayList<GeoPosition> track = new ArrayList<GeoPosition>();
        this.listaWayPoints = new HashSet<Waypoint>();
        for (Punto p : ptoAdd) {
            this.listaWayPoints.add((Waypoint)new DefaultWaypoint(p.getLatitude(), p.getLongitude()));
            track.add(new GeoPosition(p.getLatitude(), p.getLongitude()));
        }
        this.mapViewer.zoomToBestFit(new HashSet(track), 0.7);
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setWaypoints(this.listaWayPoints);
        ArrayList<WaypointPainter> painters = new ArrayList<WaypointPainter>();
        painters.add(waypointPainter);
        CompoundPainter painter = new CompoundPainter(painters);
        this.mapViewer.setOverlayPainter((Painter)painter);
    }

    public void delWaypoint(GeoPosition ptoAdd) {
        HashSet<Waypoint> listaWayPointsLocal = new HashSet<Waypoint>();
        GeoPosition pointDel = null;
        Rectangle rect = this.mapViewer.getViewportBounds();
        Point2D point = this.mapViewer.getTileFactory().geoToPixel(ptoAdd, this.mapViewer.getZoom());
        Point gp_point = new Point((int)point.getX() - rect.x, (int)point.getY() - rect.y);
        for (Waypoint waypoint : this.listaWayPoints) {
            Point2D gp_pt = this.mapViewer.getTileFactory().geoToPixel(waypoint.getPosition(), this.mapViewer.getZoom());
            Point converted_gp_pt = new Point((int)gp_pt.getX() - rect.x, (int)gp_pt.getY() - rect.y);
            if (converted_gp_pt.distance(gp_point) < 10.0) {
                pointDel = waypoint.getPosition();
                continue;
            }
            listaWayPointsLocal.add(waypoint);
        }
        this.listaWayPoints.clear();
        this.listaWayPoints.addAll(listaWayPointsLocal);
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setWaypoints(this.listaWayPoints);
        ArrayList<WaypointPainter> painters = new ArrayList<WaypointPainter>();
        painters.add(waypointPainter);
        CompoundPainter painter = new CompoundPainter(painters);
        this.mapViewer.setOverlayPainter((Painter)painter);
        this.med.delWayPoint(this.layerName, pointDel);
    }

    public void addLine(GeoPosition point, boolean showPoints) {
        int size = this.listaLineWay.size();
        double ratio = 0.0;
        if (size > 1) {
            GeoPosition compara = this.listaLineWay.get(size - 1);
            ratio = 0.001;
            double dist = Math.abs(point.getLatitude() - compara.getLatitude()) + Math.abs(point.getLongitude() - compara.getLongitude());
            if (dist < ratio) {
                this.med.addLynePoint(this.layerName, this.listaLineWay);
                int nelementsP = this.listaLineWay.size();
                long idP = System.currentTimeMillis();
                Poly polyFeature = new Poly(idP, nelementsP);
                polyFeature.setPtos(this.aux(this.listaLineWay));
                this.listaPolyView.add(polyFeature);
                this.listaLineWay = new ArrayList<GeoPosition>();
            } else {
                this.listaLineWay.add(point);
            }
        } else {
            this.listaLineWay.add(point);
        }
        int index = 0;
        HashSet<DefaultWaypoint> listaWayPointsLocal = new HashSet<DefaultWaypoint>();
        size = this.listaLineWay.size();
        for (GeoPosition waypoint : this.listaLineWay) {
            if (index == 0) {
                listaWayPointsLocal.add(new DefaultWaypoint(waypoint));
            }
            ++index;
        }
        LinePainter routePainter = new LinePainter(this.listaLineWay);
        this.displayLine(this.listaPolyView, showPoints, routePainter);
    }

    public void addPoly(GeoPosition point, boolean showPoints) {
        int size = this.listaLineWay.size();
        double ratio = 0.0;
        if (size > 1) {
            GeoPosition compara = this.listaLineWay.get(0);
            ratio = 0.001;
            double dist = Math.abs(point.getLatitude() - compara.getLatitude()) + Math.abs(point.getLongitude() - compara.getLongitude());
            if (dist < ratio) {
                this.listaLineWay.add(compara);
                this.med.addLynePoint(this.layerName, this.listaLineWay);
                int nelementsP = this.listaLineWay.size();
                long idP = System.currentTimeMillis();
                Poly polyFeature = new Poly(idP, nelementsP);
                polyFeature.setPtos(this.aux(this.listaLineWay));
                this.listaPolyView.add(polyFeature);
                this.listaLineWay = new ArrayList<GeoPosition>();
            } else {
                this.listaLineWay.add(point);
            }
        } else {
            this.listaLineWay.add(point);
        }
        int index = 0;
        HashSet<DefaultWaypoint> listaWayPointsLocal = new HashSet<DefaultWaypoint>();
        size = this.listaLineWay.size();
        for (GeoPosition waypoint : this.listaLineWay) {
            if (index == 0) {
                listaWayPointsLocal.add(new DefaultWaypoint(waypoint));
            }
            ++index;
        }
        LinePainter routePainter = new LinePainter(this.listaLineWay);
        this.displayLine(this.listaPolyView, showPoints, routePainter);
    }

    public void displayLine(List<Poly> polyShow, boolean showPoints) {
        this.displayLine(polyShow, showPoints, null);
    }

    private void displayLine(List<Poly> polyShow, boolean showPoints, LinePainter routePainterAdd) {
        ArrayList<LinePainter> painters = new ArrayList<LinePainter>();
        this.listaPolyView = polyShow;
        ArrayList<GeoPosition> track = new ArrayList<GeoPosition>();
        HashSet<DefaultWaypoint> listaLineWayLocal = new HashSet<DefaultWaypoint>();
        for (Poly poly : polyShow) {
            List<Punto> puntos = poly.getPtos();
            ArrayList<GeoPosition> lineString = new ArrayList<GeoPosition>();
            for (Punto point : puntos) {
                GeoPosition geoPto = new GeoPosition(point.getLatitude(), point.getLongitude());
                lineString.add(geoPto);
                track.add(geoPto);
                if (!showPoints) continue;
                listaLineWayLocal.add(new DefaultWaypoint(point.getLatitude(), point.getLongitude()));
            }
            LinePainter routePainter = new LinePainter(lineString);
            painters.add(routePainter);
        }
        if (routePainterAdd != null && routePainterAdd.getNumPtos() > 0) {
            painters.add(routePainterAdd);
            GeoPosition ini = routePainterAdd.getIni();
            listaLineWayLocal.add(new DefaultWaypoint(ini.getLatitude(), ini.getLongitude()));
        } else {
            this.mapViewer.zoomToBestFit(new HashSet(track), 0.7);
        }
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setWaypoints(listaLineWayLocal);
        painters.add((LinePainter)waypointPainter);
        CompoundPainter painter = new CompoundPainter(painters);
        this.mapViewer.setOverlayPainter((Painter)painter);
    }

    public void delLine(GeoPosition ptoDEL) {
        Rectangle rect = this.mapViewer.getViewportBounds();
        Point2D pointDEL = this.mapViewer.getTileFactory().geoToPixel(ptoDEL, this.mapViewer.getZoom());
        Point gp_pointDEL = new Point((int)pointDEL.getX() - rect.x, (int)pointDEL.getY() - rect.y);
        boolean target = false;
        int index = 0;
        for (Poly poly : this.listaPolyView) {
            List<Punto> puntoList = poly.getPtos();
            for (Punto point : puntoList) {
                GeoPosition waypoint = new GeoPosition(point.getLatitude(), point.getLongitude());
                Point2D gp_pt = this.mapViewer.getTileFactory().geoToPixel(waypoint, this.mapViewer.getZoom());
                Point converted_gp_pt = new Point((int)gp_pt.getX() - rect.x, (int)gp_pt.getY() - rect.y);
                if (!(converted_gp_pt.distance(gp_pointDEL) < 10.0)) continue;
                target = true;
                break;
            }
            if (target) break;
            ++index;
        }
        if (target) {
            this.med.delLynePoint(this.layerName, this.listaPolyView.get(index));
            this.listaPolyView.remove(index);
        }
        this.displayLine(this.listaPolyView, true, null);
    }

    public JXMapKit getMap() {
        return this.jXMapKit;
    }

    public void setLayerAndType(String layer, Feature.type tipoP) {
        this.tipo = tipoP;
        this.layerName = layer;
        if (this.tipo == null) {
            this.listaWayPoints = new HashSet<Waypoint>();
            this.listaPolyView = new ArrayList<Poly>();
            this.listaLineWay = new ArrayList<GeoPosition>();
        }
    }

    public List<Punto> aux(List<GeoPosition> pointD) {
        ArrayList<Punto> point = new ArrayList<Punto>();
        for (GeoPosition pos : pointD) {
            point.add(new Punto(pos.getLatitude(), pos.getLongitude()));
        }
        return point;
    }

    public void clear() {
        this.mapViewer.setOverlayPainter(null);
    }
}

