/*
 * Decompiled with CFR 0.152.
 */
package Server;

import ButtonListener.ButtonAbstract;
import GeoServer.PublishGeoserver;
import MapFrame.Feature;
import MapFrame.Layer;
import MapFrame.Poly;
import MapFrame.Punto;
import Server.Configuration;
import Server.GeoDatabase;
import Server.GeoJSON;
import Server.MapFrame;
import Server.Server;
import Users.PoolThreadUsers;
import Users.UserManager;
import Visual.CfgWindow;
import Visual.ImportURLLayersWindow;
import Visual.LayerTable;
import Visual.UserWindow;
import Visual.featureModePanel;
import Visual.infoLog;
import Visual.newLayerPanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class Mediator {
    private GeoDatabase database;
    private ButtonAbstract startButton;
    private ButtonAbstract configButton;
    private ButtonAbstract userButton;
    private ButtonAbstract stopButton;
    private ButtonAbstract Import;
    private ButtonAbstract addLayerButton;
    private ButtonAbstract delLayerButton;
    private ButtonAbstract publishLayer;
    private CfgWindow cfgWindow;
    private JFrame cfgFrame;
    private UserWindow userWindow;
    private JFrame userFrame;
    private infoLog infoLOG;
    private newLayerPanel layerPanel;
    private Server server;
    private LayerTable BBTable;
    private JFrame principalFrame;
    private MapFrame map;
    private featureModePanel feature;
    private PoolThreadUsers pool;

    public Mediator(JFrame frame) {
        this.principalFrame = frame;
        this.cfgFrame = new JFrame();
        this.cfgWindow = new CfgWindow(this.cfgFrame);
        this.pool = new PoolThreadUsers();
    }

    public boolean init() {
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(false);
        this.configButton.setEnabled(false);
        this.userButton.setEnabled(false);
        if (this.iniDataBase()) {
            this.userFrame = new JFrame();
            this.userWindow = new UserWindow(this.cfgFrame, this.database);
            return true;
        }
        return false;
    }

    public void registerInfoPanel(newLayerPanel newlayerPanelP) {
        this.layerPanel = newlayerPanelP;
    }

    public void registerMap(MapFrame mapP) {
        this.map = mapP;
    }

    public void registerMode(featureModePanel featurP) {
        this.feature = featurP;
    }

    public void registerInfoLog(infoLog info) {
        this.infoLOG = info;
    }

    public void registerBB(LayerTable table) {
        this.BBTable = table;
    }

    boolean iniDataBase() {
        this.database = new GeoDatabase();
        if (!this.database.connect()) {
            System.err.println("S: Error connecting  DataBase. EXIT!!!");
            this.infoLOG.addLog("S: Error connecting  DataBase. EXIT!!!.");
            return false;
        }
        if (!this.database.createTables()) {
            System.err.println("S: Error creating Tables of DataBase. EXIT!!!");
            return false;
        }
        this.infoLOG.addLog("S: Database Configured.");
        if (!this.database.insertUsers()) {
            System.err.println("S: Error insert users. EXIT!!!");
            return false;
        }
        this.infoLOG.addLog("S: Users Inserted. Database Ready!!");
        this.startButton.setEnabled(true);
        this.configButton.setEnabled(true);
        this.userButton.setEnabled(true);
        return true;
    }

    public void LoadData() {
        List<Layer> layers = this.getLayers();
        if (layers.size() > 0) {
            for (Layer layer : layers) {
                Feature.type tipo = Feature.type.Point;
                int size = layer.getNelements();
                int layerType = layer.getTipo();
                String layerName = layer.getName();
                switch (layerType) {
                    case 0: {
                        tipo = Feature.type.Point;
                        break;
                    }
                    case 1: {
                        tipo = Feature.type.LineString;
                        break;
                    }
                    case 2: {
                        tipo = Feature.type.Polygon;
                    }
                }
                this.BBTable.loadNewData(layerName, tipo, size);
            }
        }
    }

    public List<Layer> getLayers() {
        List<Layer> layers = this.database.getLayers();
        return layers;
    }

    public void AddLog(String msg) {
        this.infoLOG.addLog(msg);
    }

    public int isAuthenticated(String user, String pwd) {
        int ret = 0;
        ret = this.database.isAuthenticated(user, pwd);
        return ret;
    }

    public void severeError(String msg, String info) {
        JOptionPane.showMessageDialog(this.principalFrame, msg, info, 0);
        this.panicMode();
    }

    public void panicMode() {
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.configButton.setEnabled(false);
        this.userButton.setEnabled(false);
    }

    public void registerButton(ButtonAbstract button) {
        switch (button.tipo) {
            case AddLayer: {
                this.addLayerButton = button;
                break;
            }
            case DelLayer: {
                this.delLayerButton = button;
                break;
            }
            case Config: {
                this.configButton = button;
                break;
            }
            case Start: {
                this.startButton = button;
                break;
            }
            case Stop: {
                this.stopButton = button;
                break;
            }
            case Users: {
                this.userButton = button;
                break;
            }
            case Publish: {
                this.publishLayer = button;
            }
        }
    }

    public void addWayPoint(String layerName, GeoPosition ptoAdd) {
        this.BBTable.updateFeatures(layerName, true);
        this.database.insertPto_(layerName, ptoAdd.getLatitude(), ptoAdd.getLongitude());
    }

    public void addWayPoint(String layerName, List<GeoPosition> ptoAdd) {
        ArrayList<Punto> ptPuntos = new ArrayList<Punto>();
        int i = 0;
        while (i < ptoAdd.size()) {
            ptPuntos.add(new Punto(ptoAdd.get(i).getLatitude(), ptoAdd.get(i).getLongitude()));
            ++i;
        }
        this.database.insertPtos_(layerName, ptPuntos);
        this.BBTable.updateFeatures(layerName, true, ptoAdd.size());
    }

    public void delWayPoint(String layerName, GeoPosition ptoAdd) {
        if (ptoAdd != null) {
            this.BBTable.updateFeatures(layerName, false);
            this.database.deletePto(layerName, ptoAdd.getLatitude(), ptoAdd.getLongitude());
        }
    }

    public void addLynePoint(String layerName, List<GeoPosition> ptosAdd) {
        if (ptosAdd != null) {
            this.BBTable.updateFeatures(layerName, true);
            this.database.insertLine(layerName, ptosAdd);
        }
    }

    public void delLynePoint(String layerName, Poly ptos) {
        if (ptos != null) {
            this.BBTable.updateFeatures(layerName, false);
            this.database.deleteLine(layerName, ptos);
        }
    }

    public void modeChanged() {
        if (this.BBTable.getRowCount() > 0) {
            Feature.type tipoFeature = this.BBTable.getTypeSelected();
            List<Poly> ptosLines = null;
            String layerName = null;
            layerName = this.BBTable.getLayerSelected();
            this.map.setLayerAndType(layerName, tipoFeature);
            if (tipoFeature != null && tipoFeature != Feature.type.Point) {
                ptosLines = this.database.getLines(layerName);
            }
            if (this.feature.isAddSelected()) {
                if (tipoFeature != null && tipoFeature != Feature.type.Point) {
                    this.map.displayLine(ptosLines, false);
                }
            } else if (tipoFeature != null && tipoFeature != Feature.type.Point) {
                this.map.displayLine(ptosLines, true);
            }
        }
    }

    public void tableSelected() {
        String layerName = this.BBTable.getLayerSelected();
        Feature.type tipoFeature = this.BBTable.getTypeSelected();
        this.map.setLayerAndType(layerName, tipoFeature);
        if (tipoFeature != null) {
            switch (tipoFeature) {
                case Point: {
                    List<Punto> ptos = this.database.getPtos(layerName);
                    this.map.displayWaypoint(ptos);
                    break;
                }
                case LineString: {
                    List<Poly> ptosLines = this.database.getLines(layerName);
                    if (this.feature.isAddSelected()) {
                        this.map.displayLine(ptosLines, false);
                        break;
                    }
                    this.map.displayLine(ptosLines, true);
                    break;
                }
                case Polygon: {
                    List<Poly> ptosLinesPoly = this.database.getLines(layerName);
                    if (this.feature.isAddSelected()) {
                        this.map.displayLine(ptosLinesPoly, false);
                        break;
                    }
                    this.map.displayLine(ptosLinesPoly, true);
                }
            }
        }
    }

    public List<Punto> getPuntos(String layerName) {
        return this.database.getPtos(layerName);
    }

    public List<Poly> getPoly(String layerName) {
        return this.database.getLines(layerName);
    }

    public void onClick(tipoBotones tipo) {
        switch (tipo) {
            case AddLayer: {
                if (!this.layerPanel.isLayerEmpty()) {
                    String layer = this.layerPanel.getLayerName();
                    Feature.type type2 = this.layerPanel.getType();
                    this.BBTable.loadNewData(layer, type2);
                    this.database.insertLayer_(layer, this.layerPanel.getTypeIndex());
                    this.layerPanel.cleanLayerName();
                    this.layerPanel.cleanType();
                }
                this.BBTable.clearSelection();
                this.map.setLayerAndType(null, null);
                break;
            }
            case DelLayer: {
                String layer = this.BBTable.getLayerSelected();
                Feature.type FeatureSel = this.BBTable.getTypeSelected();
                this.database.deleteLayer(layer, FeatureSel);
                this.BBTable.deleteSelected();
                if (FeatureSel == Feature.type.Point) {
                    ArrayList<Punto> ptos = new ArrayList<Punto>();
                    this.map.displayWaypoint(ptos);
                } else {
                    ArrayList<Poly> polyShow = new ArrayList<Poly>();
                    this.map.displayLine(polyShow, false);
                }
                this.BBTable.clearSelection();
                this.map.setLayerAndType(null, null);
                break;
            }
            case Config: {
                this.configButton.setEnabled(false);
                this.cfgWindow.showWindow();
                this.cfgFrame.requestFocus();
                this.configButton.setEnabled(true);
                break;
            }
            case Start: {
                this.startButton.setEnabled(false);
                this.server = new Server(this, this.cfgWindow.getConfiguracion());
                this.server.start();
                this.configButton.setEnabled(false);
                this.userButton.setEnabled(false);
                this.publishLayer.setEnabled(false);
                this.stopButton.setEnabled(true);
                this.addLayerButton.setEnabled(false);
                this.delLayerButton.setEnabled(false);
                this.feature.setEnabled(false);
                this.layerPanel.setEnabled(false);
                this.BBTable.setEnabled(false);
                this.BBTable.clearSelection();
                this.map.clear();
                break;
            }
            case Stop: {
                this.stopButton.setEnabled(false);
                this.startButton.setEnabled(true);
                this.configButton.setEnabled(true);
                this.userButton.setEnabled(true);
                this.infoLOG.clear();
                this.publishLayer.setEnabled(true);
                this.server.stopServer();
                this.addLayerButton.setEnabled(true);
                this.delLayerButton.setEnabled(true);
                this.feature.setEnabled(true);
                this.layerPanel.setEnabled(true);
                this.BBTable.setEnabled(true);
                break;
            }
            case Users: {
                this.userButton.setEnabled(false);
                this.userWindow.showWindow();
                this.userFrame.requestFocus();
                this.userButton.setEnabled(true);
                break;
            }
            case Publish: {
                int selected = this.BBTable.getSelectedRow();
                if (selected > -1) {
                    String layerName = this.BBTable.getLayerSelected();
                    Feature.type FeatureSel = this.BBTable.getTypeSelected();
                    List<Punto> puntos = null;
                    List<Poly> poly = null;
                    switch (FeatureSel) {
                        case Point: {
                            puntos = this.database.getPtos(layerName);
                            this.publishPtoGeoserver(layerName, puntos);
                            break;
                        }
                        case LineString: 
                        case Polygon: {
                            poly = this.database.getLines(layerName);
                            this.publishPolyGeoserver(layerName, poly, FeatureSel);
                        }
                    }
                    break;
                }
                JOptionPane.showMessageDialog(this.principalFrame, "Please, select first a layer", "Publish", 0);
                break;
            }
            case Import: {
                GeoJSON result;
                JFrame GeoJSONFrame = new JFrame();
                ImportURLLayersWindow GeoJSON2 = new ImportURLLayersWindow(GeoJSONFrame);
                GeoJSON2.showWindow();
                if (!GeoJSON2.havetoSave() || (result = GeoJSON2.getResult()) == null) break;
                String layerS = result.getLayerName();
                this.BBTable.loadNewData(layerS, Feature.type.Point);
                this.database.insertLayer_(layerS, 0);
                int nptos = result.getnumPoints();
                List<GeoPosition> ptos = result.getPoints();
                this.addWayPoint(layerS, ptos);
            }
        }
    }

    public void EventMapa(GeoPosition pto) {
        Feature.type tipo = null;
        boolean add = this.feature.isAddSelected();
        tipo = this.BBTable.getTypeSelected();
        if (this.BBTable.isEnabled() && tipo != null) {
            switch (tipo) {
                case Point: {
                    if (add) {
                        this.map.addWaypoint(pto);
                        break;
                    }
                    this.map.delWaypoint(pto);
                    break;
                }
                case LineString: {
                    if (add) {
                        this.map.addLine(pto, false);
                        break;
                    }
                    this.map.delLine(pto);
                    break;
                }
                case Polygon: {
                    if (add) {
                        this.map.addPoly(pto, false);
                        break;
                    }
                    this.map.delLine(pto);
                }
            }
        }
    }

    private void publishPtoGeoserver(String layerName, List<Punto> listaPuntos) {
        Configuration cfg = this.cfgWindow.getConfiguracion();
        String Geoserver = cfg.getGeoServer();
        int GeoserverPort = cfg.getGeoServerPort();
        String pwd = cfg.getPwd();
        String user = cfg.getUser();
        PublishGeoserver conexionServer = new PublishGeoserver(Geoserver, GeoserverPort, user, pwd);
        if (conexionServer.connect()) {
            if (conexionServer.checkWorkspace("workSpaceUMA")) {
                boolean published = false;
                try {
                    conexionServer.shapefilePtos(layerName, listaPuntos);
                    published = conexionServer.publish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (published) {
                    System.out.println("Zip publicado.");
                } else {
                    System.out.println("Zip no publicado.");
                }
            }
        } else {
            String mensaje = "Server " + Geoserver + " in port " + GeoserverPort + " not responding.";
            JOptionPane.showMessageDialog(this.principalFrame, mensaje, "Geoserver Connection", 0);
        }
    }

    private void publishPolyGeoserver(String layerName, List<Poly> listaPuntos, Feature.type tipo) {
        Configuration cfg = this.cfgWindow.getConfiguracion();
        String Geoserver = cfg.getGeoServer();
        int GeoserverPort = cfg.getGeoServerPort();
        String pwd = cfg.getPwd();
        String user = cfg.getUser();
        PublishGeoserver conexionServer = new PublishGeoserver(Geoserver, GeoserverPort, user, pwd);
        if (conexionServer.connect()) {
            if (conexionServer.checkWorkspace("workSpaceUMA")) {
                boolean published = false;
                try {
                    conexionServer.shapefileLines(layerName, listaPuntos, tipo);
                    published = conexionServer.publish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (published) {
                    System.out.println("Zip publicado.");
                } else {
                    System.out.println("Zip no publicado.");
                }
            }
        } else {
            String mensaje = "Server " + Geoserver + " in port " + GeoserverPort + " not responding.";
            JOptionPane.showMessageDialog(this.principalFrame, mensaje, "Geoserver Connection", 0);
        }
    }

    public void addElementPool(UserManager cl) {
        this.pool.addClients(cl);
    }

    public void disconnected(String user, String addressClient) {
        this.AddLog("C->S: Client " + user + " disconnected from " + addressClient);
        this.database.setOnline(false, user);
    }

    public void sendBroadCastModif(String layerName, int tipo, boolean add, String userL) {
        this.pool.sendBroadCastModif(layerName, tipo, add, userL);
    }

    public static enum tipoBotones {
        AddLayer,
        DelLayer,
        Config,
        Start,
        Stop,
        Users,
        Publish,
        Import;

    }
}

